


\NeedsTeXFormat{LaTeX2e}

\ProvidesClass{iaria}[2024/09/16 unofficial IARIA conference template v0.4]

\newcounter{iaria@subfigtracker}
\newcounter{iaria@subcaptiontracker}
\newcounter{iaria@pbalancetracker}
\newcounter{iaria@flushendtracker}


\DeclareOption{subfig}{
  \setcounter{iaria@subfigtracker}{1}
  \typeout{iaria class: subfig option is set (use subfloat command).}
}
\DeclareOption{subcaption}{
  \setcounter{iaria@subcaptiontracker}{1}
  \typeout{iaria class: subcaption option is set (use subfigure command).}
}

\DeclareOption{onecolumn}{\OptionNotUsed} % IEEE option onecolumn will be ignored

\DeclareOption{pbalance}{
  \setcounter{iaria@pbalancetracker}{1}
  \typeout{iaria class: pbalance option is set.}
}
\DeclareOption{flushend}{
  \setcounter{iaria@flushendtracker}{1}
  \typeout{iaria class: flushend option is set.}
}

\DeclareOption*{%
  \PassOptionsToClass{\CurrentOption}{IEEEtran}% required IEEE options: conference (for IARIA purposes)
}

\ProcessOptions\relax

\LoadClass{IEEEtran}


\RequirePackage{times} % Times New Roman

\RequirePackage[utf8]{inputenc}

\RequirePackage[T1]{fontenc}

\RequirePackage{graphicx}
\RequirePackage{xcolor}

\RequirePackage{url}
\RequirePackage{orcidlink}
\RequirePackage{hyperref}
\hypersetup{hidelinks,unicode}

\RequirePackage[defernumbers=true,style=ieee, backend=biber, url=false, hyperref, maxnames=5, minnames=1, maxcitenames=2, mincitenames=1]{biblatex}

\makeatletter
\let\blx@rerun@biber\relax
\makeatother

\renewcommand*{\bibfont}{\small}

\DeclareBibliographyDriver{online}{%
    \usebibmacro{bibindex}%
    \usebibmacro{begentry}%
    \usebibmacro{author/editor+others/translator+others}
    \setunit{\labelnamepunct}\newblock
    \usebibmacro{title}%
    \newunit
    \printlist{language}%
    \newunit\newblock
    \usebibmacro{byauthor}%
    \newunit\newblock
    \usebibmacro{byeditor+others}%
    \newunit\newblock
    \printfield{version}%
    \newunit
    \printfield{note}%
    \newunit\newblock
    \printlist{organization}
    \newunit\newblock
    \usebibmacro{date}%
    \newunit\newblock
    \iftoggle{bbx:eprint}
    {\usebibmacro{eprint}}
    {}%
    \newunit\newblock
    \usebibmacro{url+urldate}%
    \newunit\newblock
    \usebibmacro{addendum+pubstate}%
    \setunit{\bibpagerefpunct}\newblock
    \usebibmacro{pageref}%
    \usebibmacro{finentry}}

\makeatletter
\renewcommand{\fnum@figure}{Figure~\thefigure}
\renewcommand{\title}[1]{\renewcommand{\@title}{\bfseries\Large #1}}
\renewcommand\IEEEkeywordsname{Keywords}
\makeatother

\RequirePackage{xpatch}
\xpatchcmd\IEEEkeywords{---}{-}{}{}

\let\oldIEEEkeywords\IEEEkeywords
\def\IEEEkeywords{\oldIEEEkeywords\itshape\ignorespaces}

\makeatletter
\renewcommand{\IEEEauthorblockN}[1]{%
    \relax\@IEEEauthorblockNstyle% set the default text style
    \gdef\@IEEEauthorblockXinterlinespace{0pt}% disable strut for spacer row
    % the \expandafter hides the \cr in conditional tex, see the array.sty docs
    % for details, probably not needed here as the \cr is in a macro
    % do a spacer row if needed
    \if@IEEEprevauthorblockincol\expandafter\@IEEEauthorblockNtopspaceline\fi
    \global\@IEEEprevauthorblockincoltrue% we now have a block in this column
    %restore the correct strut value
    \gdef\@IEEEauthorblockXinterlinespace{\@IEEEauthorblockNinterlinespace}%
    % input the author names
    \large
    #1%
    % end the row if the user did not already
    \crcr}
\makeatother

\usepackage{etoolbox}
\makeatletter
\patchcmd{\@makecaption}
  {\\}
  {.\ }
  {}
  {}
\makeatother

\ifnum\value{iaria@subfigtracker}=1
  \typeout{iaria class: load subfig package (use subfloat command).}
  \RequirePackage[caption=false,font=footnotesize]{subfig}
\fi
\ifnum\value{iaria@subcaptiontracker}=1
  \typeout{iaria class: load subcaption package (use subfigure command).}
  \RequirePackage{subcaption}
  \captionsetup[subfigure]{labelformat=parens,font=footnotesize}
\fi

\ifnum\value{iaria@pbalancetracker}=1
  \typeout{iaria class: load pbalance package.}
  \RequirePackage{pbalance}
\fi
\ifnum\value{iaria@flushendtracker}=1
  \typeout{iaria class: load flushend package.}
  \RequirePackage{flushend}
\fi


\RequirePackage[shortcuts]{extdash} % Use \-/ for a breakable dash that does not prevent the remainer of the word to be hyphenated

\endinput
%%
%% End of file `iaria.cls'.
