;;; bdf.el --- BDF font file manager for Meadow.

;; Copyright (C) 2002 KOSEKI Yoshinori <kose@meadowy.org>

;; Author: KOSEKI Yoshinori <kose@meadowy.org>
;; Keywords: BDF, meadow

;;; Commentary:

;; Set BDF fonts directory to bdf-directory-list.

;;; Code:

(defun bdf-configure-fontset (fontset bdf-font-file-alist)
  "if not exist fontset, then make fontset, else return fontlist."
  (let* ((exist (member fontset (fontset-list)))
	 (fontlist (mapcar 
	    (lambda (x)
	      (let* ((charset (nth 0 x))
		     (files (nth 1 x))
		     (encoding (nth 2 x))
		     (fontname 
		      (concat fontset "-" (symbol-name charset))))
		(if (not exist)
		    (bdf-auto-regist-fonts fontname files encoding))
		(cons charset fontname)))
	    bdf-font-file-alist)))
    (if exist
	fontlist
      (new-fontset fontset fontlist))))

(defun bdf-auto-regist-fonts (fontname files encoding)
  "Set normal, bold, italic, bold-itaric fonts."
  (let ((normal (nth 0 files))
	(bold (nth 1 files))
	(italic (nth 2 files))
	(bold-italic (nth 3 files))
	file)
    (if (and normal
	     (setq file (bdf-file-exists-p normal bdf-directory-list)))
	(w32-auto-regist-bdf-font fontname file encoding))
    (if (and bold
	     (setq file (bdf-file-exists-p bold bdf-directory-list)))
	(w32-change-font-logfont fontname 1 (list 'bdf-font file)))
    (if (and italic
	     (setq file (bdf-file-exists-p italic bdf-directory-list)))
	(w32-change-font-logfont fontname 2 (list 'bdf-font file)))
    (if (and bold-italic
	     (setq file (bdf-file-exists-p bold-italic bdf-directory-list)))
	(w32-change-font-logfont fontname 3 (list 'bdf-font file)))))

;; internal function
(defun bdf-file-exists-p (FILE LIST)
  "return filename"
  (let ((lst LIST)
	file)
    (catch 'font
      (while lst
	(if (file-exists-p (setq file (expand-file-name FILE (car lst))))
	  (throw 'font file))
      (setq lst (cdr lst))))))

(provide 'bdf)

;;; bdf.el ends here
