;;; jde-autoload.el -- Integrated Development Environment for Java.
;; $Revision: 1.6 $ 

;; Author: Paul Kinnucan <paulk@mathworks.com>
;; Maintainer: Paul Kinnucan
;; Keywords: java, tools

;; Copyright (C) 1997, 1998, 2000, 2001, 2002 Paul Kinnucan.

;; GNU Emacs is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; Gnu Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.
;;

;; Commentary:

;; This file is intended to decrease the startup time for the JDEE by
;; delaying the loading of many JDEE packages until they are used for
;; the first time in a session.

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                                                                            ;;
;; Make package                                                               ;;
;;                                                                            ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(autoload 
  'jde-xref-make-xref-db
  "jde-xref" 
  "Create a database of caller to callee (and the reverse) from the
classes in `jde-xref-class-path' and store the data in the location
specified by `jde-xref-db-file'"
  t)

(autoload 
  'jde-xref-first-caller
  "jde-xref" 
  "Put the list of who calls the current function on the stack and
display the first caller.  Subsequent callers are displayed through
`jde-xref-show-next-caller'.  STRICT should be set to true if the
callers of interfaces to a function should not be considered"
  t)

(autoload 
  'jde-xref-next-caller
  "jde-xref" 
  "If there are items still on the caller stack, pop the first one off
and show it"
  t)

(autoload 
  'jde-xref-display-call-tree
  "jde-xref" 
  "Display an interactive call tree of which function call the current
  function, which can be expanded outward.  STRICT should be set to
  true if the callers of interfaces to a function should not be
  considered"
  t)

(autoload 
  'jde-xref-list-uncalled-functions 
  "jde-xref" 
  "Displays a simple list of function that are never called, at least
not directly.  Do not assume that this means this code can never be
reached, since reflection could always call any method.  Use this list
and your best judgement to figure out what are good candidates for
code cleanup.  STRICT should be set to true if the callers of
interfaces to a function should not be considered"
  t)

(autoload 
  'jde-xref-update-caller-table
  "jde-xref" 
  "Update the caller table after a recompile.  This can be called by
the user when they recompile outside of emacs.  It will update the
call list of all files modified in emacs"
  t)


(autoload 
  'jde-xref-customize
  "jde-xref" 
  "Display the customization buffer for the xref package."
  t)




;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                                                                            ;;
;; Make package                                                               ;;
;;                                                                            ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(autoload 
  'jde-make
  "jde-make" 
 "Run the make program specified by `jde-make-program' with the
command-line arguments specified by `jde-make-args'. If
`jde-read-make-args' is nonnil, this command also prompts you to enter
make arguments in the minibuffer and passes any arguments that you
enter to the make program along with the arguments specified by
`jde-make-args'."
  t)

(autoload 
  'jde-make-show-options
  "jde-make" 
 "Show the JDE Make Options panel."
  t)


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                                                                            ;;
;; Ant package                                                                ;;
;;                                                                            ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(autoload 
  'jde-ant-build
  "jde-ant" 
 "Build the current project using Ant. If interactive, prompt the
  user for certain variables."
  t)

(autoload 
  'jde-ant-projecthelp
  "jde-ant" 
 "Display Ant project help for the current project.
This will execute the Ant program with the `-projecthelp' switch to output
available targets with their descriptions for the current buildfile. This
function uses the same rules as `jde-ant-build' for finding the buildfile."
  t)

(autoload 
  'jde-ant-show-options
  "jde-ant" 
 "Show the JDE Ant Options panel."
  t)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                                                                            ;;
;; Statistics package                                                         ;;
;;                                                                            ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(autoload 
  'jde-stat-loc-report
  "jde-stat" 
 "Generates a report showing the number of code, comment,
javadoc, and blank lines in the current Java source buffer. Optionally
a total count could be passed to be displayes, as well as the number of
processed files."
  t)

(autoload 
  'jde-stat-loc-report-project
  "jde-stat" 
  "Generates a report showing the number of code, comment,
javadoc, and blank lines in all the java files in the current
directory and subdirectories. This method will kill any
buffer containing a java file contained in dir."
  t)

(autoload 
  'jde-stat-loc-report-directory
  "jde-stat" 
  "Generates a report showing the number of code, comment,
javadoc, and blank lines in all the java files in the current
directory. This method will kill any buffer containing a java file
contained in dir."
  t)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                                                                            ;;
;; Javadoc package                                                            ;;
;;                                                                            ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(autoload 
  'jde-javadoc-checker-previous 
  "jde-javadoc" 
  "Go to the previous token with doc errors."
  t)

(autoload 
  'jde-javadoc-checker-next
  "jde-javadoc" 
  "Go to the next token with doc errors."
  t)

(autoload 
  'jde-javadoc-checker-fix
  "jde-javadoc" 
  "Fix documentation of checked token.
Used in `jde-javadoc-checker-report-mode'."
  t)

(autoload 
  'jde-javadoc-checker-quit
  "jde-javadoc" 
  "Quit the `jde-javadoc-checker' report buffer.
Used in `jde-javadoc-checker-report-mode'."
  t)

(autoload 
  'jde-javadoc-customize
  "jde-javadoc" 
  "Show the jde-javadoc options panel."
  t)

(autoload 
  'jde-javadoc-autodoc-at-line
  "jde-javadoc" 
  "Update javadoc comment block for declaration at current line.

Uses the semantic bovinator parser table to find declarations (see
`jde-javadoc-nonterminal-at-line').

BEFORE EXECUTING THE COMMAND, THE POINT MUST BE LOCATED AT THE FIRST
LINE OF THE CLASS OR METHOD DECLARATION.  IF NOT RESULT IS UNCERTAIN.

In the following examples, point is located at the beginning of the
line, before the word 'public' (but it could be anywhere on this
line):

1- Class example:
   -------------

-|-  public class MyClass
       extends MySuperClass implements Runnable, java.io.Serializable
     {
       ...

\\[jde-javadoc-autodoc-at-line] inserts:

+    /**
+     * Describe class <code>MyClass</code> here.
+     *
+     * @author \"David Ponce\" <david.ponce@wanadoo.fr>
+     * @version 1.0
+     * @since 1.0
+     * @see MySuperClass
+     * @see Runnable
+     * @see java.io.Serializable
+     */
     public class MyClass
       extends MySuperClass implements Runnable, java.io.Serializable
     {
       ...

2- Method example:
   --------------

-|-  public
     void   myMethod( int  x,  int y )
       throws Exception
     {
       ...

\\[jde-javadoc-autodoc-at-line] inserts:

+    /**
+     * Describe <code>myMethod</code> method here.
+     *
+     * @param x an <code>int</code> value
+     * @param y a <code>long</code> value
+     * @exception Exception if an error occurs
+     */
     public
     void   myMethod( int  x,  long y )
       throws Exception
     {
       ...

3- Field example:
   --------------

-|-  private static final int SIZE = 10;

\\[jde-javadoc-autodoc-at-line] inserts:

+    /**
+     * Describe constant <code>SIZE</code> here.
+     */
     private static final int SIZE = 10;


`tempo' templates are used for each category of javadoc line.  The
following templates are currently defined and fully customizable (see
`tempo-define-template' for the different items that can be used in a
tempo template):

- - `jde-javadoc-author-tag-template'
- - `jde-javadoc-describe-class-template'
- - `jde-javadoc-describe-constructor-template'
- - `jde-javadoc-describe-interface-template'
- - `jde-javadoc-describe-method-template'
- - `jde-javadoc-describe-field-template'
- - `jde-javadoc-exception-tag-template'
- - `jde-javadoc-param-tag-template'
- - `jde-javadoc-return-tag-template'
- - `jde-javadoc-version-tag-template'

For example if you customize `jde-javadoc-describe-class-template'
with the following value:

'(\"* \" (P \"Class description: \"))

you will be asked to enter the class description in the minibuffer.
See also the `jde-javadoc-field-type', `jde-javadoc-a' and
`jde-javadoc-code' helper functions."
  t)

(autoload 
  'jde-javadoc-checkdoc-at-line
  "jde-javadoc" 
  "Check javadoc comment block of declaration at current line.

Uses the semantic bovinator parser table to find declarations (see
`jde-javadoc-nonterminal-at-line').

BEFORE EXECUTING THE COMMAND, THE POINT MUST BE LOCATED AT THE FIRST
LINE OF THE CLASS OR METHOD DECLARATION.  IF NOT RESULT IS UNCERTAIN."
  t)

(autoload 
  'jde-javadoc-checkdoc
  "jde-javadoc" 
  "Check doc comments of tokens in the current buffer.
Report the next token with documentation errors."
  t)

(autoload 
  'jde-javadoc-enable-menu-p
  "jde-javadoc" 
 "Return non-nil if corresponding doc menu item is enabled.
That is point is on the first line of a class, method, or field
definition.")


(autoload 
  'jde-javadoc-make
  "jde-javadoc-gen" 
  "Generates javadoc for the current project. This command runs the
JDE javadoc program to generate the documentation. The variable
`jde-javadoc-command-path' specifies the path of the javadoc excutable.
The variable `jde-global-classpath' specifies the javadoc 
-classpath argument. The variable `jde-sourcepath'
specifies the javadoc  -sourcepath argument. You can specify all
other javadoc options via JDE customization variables. To specify the
options, select Project->Options->Javadoc from the JDE menu. Use 
`jde-javadoc-gen-packages' to specify the packages, classes, or source
files for which you want to generate javadoc. If this variable is nil,
this command generates javadoc for the Java source file in the current
buffer. If `jde-javadoc-display-doc' is nonnil, this command displays
the generated documentation in a browser."
 t)


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                                                                            ;;
;; Check style package                                                        ;;
;;                                                                            ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(autoload 
  'jde-checkstyle-customize
  "jde-checkstyle" 
  "Set Java style checking options."
  t)

(autoload 
  'jde-checkstyle
  "jde-checkstyle" 
  "Checks the Java program in the current buffer.
This command invokes the style checker specified by `jde-checkstyle-class'
with the options specified by the JDEE customization variables
that begin with `jde-checkstyle'. If the variable
`jde-read-checkstyle-args' is non-nil, this command reads
additional compilation options from the minibuffer, with
history enabled."
  t)


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                                                                            ;;
;; Enterprise Java Bean package                                               ;;
;;                                                                            ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


(autoload 
  'jde-ejb-session-bean-buffer 
  "jde-ejb" 
  "Create a new Java buffer containing an EJB session bean class of the same name.
This command also creates buffers with the EJB Home and EJB Remote interfaces
and the XML Deployment descriptor defined
by the jde-ejb templates.  This includes naming the files according 
to the EJB naming convention."  
  t)

(autoload 
  'jde-ejb-entity-bean-buffer 
  "jde-ejb" 
  "Create a new Java buffer containing an EJB entity bean class of the same name.
This command also creates buffers with the EJB Home and EJB Remote interfaces
and the XML Deployment descriptor defined
by the jde-ejb templates.  This includes naming the files according 
to the EJB naming convention."
  t)

(provide 'jde-autoload)

;; $Log: jde-autoload.el,v $
;; Revision 1.6  2002/11/28 13:09:11  paulk
;; Fix incorrect name for jde-javadoc-customize proxie.
;;
;; Revision 1.5  2002/11/18 07:03:53  paulk
;; Added Andy Hyatt's xref commands to the JDEE autoloads.
;;
;; Revision 1.4  2002/10/22 04:59:56  paulk
;; Autoload jde-make command.
;;
;; Revision 1.3  2002/10/21 04:47:26  paulk
;; Add autloads for ant commands.
;;
;; Revision 1.2  2002/10/11 05:53:24  paulk
;; Added more packages to the list of packages that are demand loaded. This is intended to reduce the startup time for the JDEE.
;;
;; Revision 1.1  2002/09/30 05:18:17  paulk
;; Initial revision.
;;

;; end of jde-autoload.el
