;;; default.el --- load auto-autoload.el

;;; Copyright (C) 2002 The Meadow Team

;; Author: KOSEKI Yoshinori <kose@meadowy.org>
;; Keywords: elisp

;;; Commentary:

;; Emacs Lisp Packages for Meadow.

;; If you don't want to load this file, set ~/.emacs.
;; (setq inhibit-default-init t)

;;; Code:

;; When Meadow/pkginfo/***/auto-autoloads.el exists, load it.
(let* ((basedir (expand-file-name (concat data-directory "../../pkginfo")))
       (dirs (directory-files basedir))
       el)
  (while dirs
    (setq el (concat basedir "/" (car dirs) "/auto-autoloads.el"))
    (if (file-exists-p el)
	(load-file el))
    (setq dirs (cdr dirs))))

;;; default.el ends here
