;;; pkginfo/bitmap-mule/auto-autoloads.el

;;; Copyright (C) 2002 The Meadow Team

;; Author: KOSEKI Yoshinori <kose@meadowy.org>

;; Make bitmap16 font and set to all fontsets.
;; Using Meadow/fonts/intlfonts/bmp16-etl.bdf.

(require 'bitmap)

;; Set bitmap16 font.
(let ((font "bitmap16")
      (bdf (expand-file-name "../../fonts/intlfonts/bitmap16.bdf" 
			     data-directory)))
  (when (and (file-exists-p bdf)
	     (not (member font (w32-font-list))))
    (w32-auto-regist-bdf-font font bdf 0)
    ;; Set bitmap16 font to all fontsets.
    (let ((fset (fontset-list)))
      (while fset
	(when (string-match "fixed-medium-r" (cdr (assoc 'bitmap 
				 (assoc (car fset) global-fontset-alist))))
	  (set-fontset-font (car fset) 'bitmap "bitmap16"))
	(setq fset (cdr fset))))))

;;; auto-autoloads.el ends here
