; -*- coding: iso-2022-7bit  -*-
;;; u-cns-4.el --- tables between UCS and CNS 11643:1992 plain 4

;; Copyright (C) 1998 Koichi Yasuoka.
;; Copyright (C) 1998 MORIOKA Tomohiko.

;; Author: MORIOKA Tomohiko <morioka@jaist.ac.jp>

;; Keywords: CCL, mule, multilingual, character set, coding-system,
;;                ISO/IEC 10646, Unicode 2.0, CNS 11643:1992

;; This file is part of Mule-UCS.

;;; Commentary:

;; This program was originally based on "Uni2CNS.Z" by Koichi Yasuoka
;; <yasuoka@kudpc.kyoto-u.ac.jp>, and checked and translated to Emacs
;; Lisp by MORIOKA Tomohiko.

;;; Code:

(put 'chinese-cns11643-4 'unicode-assoc
     'cns11643-4-vs-unicode-assoc)

(defvar cns11643-4-vs-unicode-assoc
  `(assoc
    (char-1 . ucs-generic)
    ,(transformate-list-structure
      (identity . c-notated-string-to-number)
      ((?$(J!"(B . "0x4E40") ; <CJK>
       (?$(J!#(B . "0x4E41") ; <CJK>
       (?$(J!$(B . "0x4E5A") ; <CJK>
       (?$(J!&(B . "0x4E02") ; <CJK>
       (?$(J!'(B . "0x4E29") ; <CJK>
       (?$(J!*(B . "0x5202") ; <CJK>
       (?$(J!,(B . "0x5DDC") ; <CJK>
       (?$(J!0(B . "0x5342") ; <CJK>
       (?$(J!1(B . "0x536A") ; <CJK>
       (?$(J!2(B . "0x5B52") ; <CJK>
       (?$(J!4(B . "0x5C22") ; <CJK>
       (?$(J!5(B . "0x5C6E") ; <CJK>
       (?$(J!6(B . "0x5FC4") ; <CJK>
       (?$(J!7(B . "0x624C") ; <CJK>
       (?$(J!8(B . "0x72AD") ; <CJK>
       (?$(J!9(B . "0x4E12") ; <CJK>
       (?$(J!:(B . "0x4E2F") ; <CJK>
       (?$(J!;(B . "0x4E96") ; <CJK>
       (?$(J!<(B . "0x4ED0") ; <CJK>
       (?$(J!=(B . "0x5142") ; <CJK>
       (?$(J!>(B . "0x5183") ; <CJK>
       (?$(J!?(B . "0x4ECC") ; <CJK>
       (?$(J!D(B . "0x5383") ; <CJK>
       (?$(J!E(B . "0x53B8") ; <CJK>
       (?$(J!I(B . "0x5928") ; <CJK>
       (?$(J!K(B . "0x5C23") ; <CJK>
       (?$(J!L(B . "0x5E01") ; <CJK>
       (?$(J!M(B . "0x5F00") ; <CJK>
       (?$(J!P(B . "0x706C") ; <CJK>
       (?$(J!Q(B . "0x722B") ; <CJK>
       (?$(J!R(B . "0x5188") ; <CJK>
       (?$(J!S(B . "0x8279") ; <CJK>
       (?$(J!T(B . "0x8FB6") ; <CJK>
       (?$(J!U(B . "0x4E17") ; <CJK>
       (?$(J!Z(B . "0x4EE2") ; <CJK>
       (?$(J![(B . "0x4EDB") ; <CJK>
       (?$(J!^(B . "0x51AD") ; <CJK>
       (?$(J!`(B . "0x51F7") ; <CJK>
       (?$(J!e(B . "0x531B") ; <CJK>
       (?$(J!f(B . "0x5388") ; <CJK>
       (?$(J!g(B . "0x5387") ; <CJK>
       (?$(J!i(B . "0x53CF") ; <CJK>
       (?$(J!l(B . "0x53E7") ; <CJK>
       (?$(J!m(B . "0x56DC") ; <CJK>
       (?$(J!o(B . "0x56D9") ; <CJK>
       (?$(J!p(B . "0x5725") ; <CJK>
       (?$(J!q(B . "0x5727") ; <CJK>
       (?$(J!r(B . "0x5933") ; <CJK>
       (?$(J!s(B . "0x5C13") ; <CJK>
       (?$(J!v(B . "0x5C75") ; <CJK>
       (?$(J!|(B . "0x66F1") ; <CJK>
       (?$(J"!(B . "0x7F52") ; <CJK>
       (?$(J"'(B . "0x4E51") ; <CJK>
       (?$(J"((B . "0x4E6A") ; <CJK>
       (?$(J"*(B . "0x4F0C") ; <CJK>
       (?$(J"-(B . "0x4EFE") ; <CJK>
       (?$(J".(B . "0x4F1B") ; <CJK>
       (?$(J"4(B . "0x5173") ; <CJK>
       (?$(J"6(B . "0x518E") ; <CJK>
       (?$(J"?(B . "0x52A5") ; <CJK>
       (?$(J"A(B . "0x52A7") ; <CJK>
       (?$(J"B(B . "0x52A4") ; <CJK>
       (?$(J"H(B . "0x53BD") ; <CJK>
       (?$(J"L(B . "0x5402") ; <CJK>
       (?$(J"Q(B . "0x572B") ; <CJK>
       (?$(J"R(B . "0x591B") ; <CJK>
       (?$(J"S(B . "0x5935") ; <CJK>
       (?$(J"[(B . "0x5B90") ; <CJK>
       (?$(J"\(B . "0x5C17") ; <CJK>
       (?$(J"_(B . "0x5C70") ; <CJK>
       (?$(J"`(B . "0x5C7D") ; <CJK>
       (?$(J"c(B . "0x5DE9") ; <CJK>
       (?$(J"k(B . "0x5F19") ; <CJK>
       (?$(J"l(B . "0x5F1C") ; <CJK>
       (?$(J"m(B . "0x5F75") ; <CJK>
       (?$(J"q(B . "0x5FC8") ; <CJK>
       (?$(J#!(B . "0x6C12") ; <CJK>
       (?$(J#'(B . "0x72B3") ; <CJK>
       (?$(J#*(B . "0x7390") ; <CJK>
       (?$(J#+(B . "0x7536") ; <CJK>
       (?$(J#/(B . "0x8281") ; <CJK>
       (?$(J#0(B . "0x8FB8") ; <CJK>
       (?$(J#5(B . "0x4E23") ; <CJK>
       (?$(J#9(B . "0x4F2E") ; <CJK>
       (?$(J#;(B . "0x514F") ; <CJK>
       (?$(J#=(B . "0x51BA") ; <CJK>
       (?$(J#@(B . "0x5222") ; <CJK>
       (?$(J#F(B . "0x52AF") ; <CJK>
       (?$(J#G(B . "0x52B0") ; <CJK>
       (?$(J#H(B . "0x52B1") ; <CJK>
       (?$(J#I(B . "0x52B2") ; <CJK>
       (?$(J#M(B . "0x5364") ; <CJK>
       (?$(J#O(B . "0x53D3") ; <CJK>
       (?$(J#[(B . "0x5448") ; <CJK>
       (?$(J#a(B . "0x5759") ; <CJK>
       (?$(J#b(B . "0x593F") ; <CJK>
       (?$(J#g(B . "0x598B") ; <CJK>
       (?$(J#i(B . "0x5991") ; <CJK>
       (?$(J#j(B . "0x5995") ; <CJK>
       (?$(J#o(B . "0x5B8A") ; <CJK>
       (?$(J#z(B . "0x5C87") ; <CJK>
       (?$(J$#(B . "0x5E0D") ; <CJK>
       (?$(J$((B . "0x5E8E") ; <CJK>
       (?$(J$,(B . "0x5F7A") ; <CJK>
       (?$(J$9(B . "0x6290") ; <CJK>
       (?$(J$<(B . "0x629A") ; <CJK>
       (?$(J$>(B . "0x653C") ; <CJK>
       (?$(J$?(B . "0x653A") ; <CJK>
       (?$(J$A(B . "0x6598") ; <CJK>
       (?$(J$F(B . "0x6765") ; <CJK>
       (?$(J$I(B . "0x6740") ; <CJK>
       (?$(J$h(B . "0x79C2") ; <CJK>
       (?$(J$l(B . "0x8288") ; <CJK>
       (?$(J$p(B . "0x809E") ; <CJK>
       (?$(J$s(B . "0x81EB") ; <CJK>
       (?$(J$u(B . "0x8289") ; <CJK>
       (?$(J$y(B . "0x8296") ; <CJK>
       (?$(J${(B . "0x8287") ; <CJK>
       (?$(J%!(B . "0x8FC0") ; <CJK>
       (?$(J%#(B . "0x8FC3") ; <CJK>
       (?$(J%+(B . "0x9578") ; <CJK>
       (?$(J%.(B . "0x9625") ; <CJK>
       (?$(J%0(B . "0x4E75") ; <CJK>
       (?$(J%1(B . "0x4E74") ; <CJK>
       (?$(J%6(B . "0x4F99") ; <CJK>
       (?$(J%=(B . "0x4FAE") ; <CJK>
       (?$(J%>(B . "0x4F71") ; <CJK>
       (?$(J%?(B . "0x5153") ; <CJK>
       (?$(J%@(B . "0x51BF") ; <CJK>
       (?$(J%C(B . "0x51C0") ; <CJK>
       (?$(J%E(B . "0x51EE") ; <CJK>
       (?$(J%N(B . "0x523D") ; <CJK>
       (?$(J%P(B . "0x52BD") ; <CJK>
       (?$(J%Q(B . "0x530C") ; <CJK>
       (?$(J%W(B . "0x7F37") ; <CJK>
       (?$(J%Y(B . "0x53C0") ; <CJK>
       (?$(J%_(B . "0x546E") ; <CJK>
       (?$(J%`(B . "0x5483") ; <CJK>
       (?$(J%c(B . "0x545E") ; <CJK>
       (?$(J%d(B . "0x545D") ; <CJK>
       (?$(J%e(B . "0x577E") ; <CJK>
       (?$(J%f(B . "0x5779") ; <CJK>
       (?$(J%h(B . "0x577A") ; <CJK>
       (?$(J%i(B . "0x576C") ; <CJK>
       (?$(J%n(B . "0x5787") ; <CJK>
       (?$(J%p(B . "0x591D") ; <CJK>
       (?$(J%r(B . "0x5946") ; <CJK>
       (?$(J%u(B . "0x5943") ; <CJK>
       (?$(J&"(B . "0x5B61") ; <CJK>
       (?$(J&#(B . "0x5B66") ; <CJK>
       (?$(J&)(B . "0x5C29") ; <CJK>
       (?$(J&/(B . "0x5CB2") ; <CJK>
       (?$(J&4(B . "0x5CC0") ; <CJK>
       (?$(J&9(B . "0x5E9F") ; <CJK>
       (?$(J&O(B . "0x601F") ; <CJK>
       (?$(J&P(B . "0x5FE2") ; <CJK>
       (?$(J&a(B . "0x6616") ; <CJK>
       (?$(J&b(B . "0x65F9") ; <CJK>
       (?$(J&e(B . "0x6788") ; <CJK>
       (?$(J&g(B . "0x679B") ; <CJK>
       (?$(J&i(B . "0x676E") ; <CJK>
       (?$(J&j(B . "0x679E") ; <CJK>
       (?$(J&q(B . "0x6B24") ; <CJK>
       (?$(J&v(B . "0x6B7D") ; <CJK>
       (?$(J&{(B . "0x6CE6") ; <CJK>
       (?$(J&}(B . "0x6CCB") ; <CJK>
       (?$(J'&(B . "0x6CB5") ; <CJK>
       (?$(J')(B . "0x7097") ; <CJK>
       (?$(J'+(B . "0x709B") ; <CJK>
       (?$(J'1(B . "0x726B") ; <CJK>
       (?$(J'6(B . "0x72D5") ; <CJK>
       (?$(J'@(B . "0x7543") ; <CJK>
       (?$(J'C(B . "0x759C") ; <CJK>
       (?$(J'R(B . "0x77E4") ; <CJK>
       (?$(J'[(B . "0x7ACE") ; <CJK>
       (?$(J'a(B . "0x8013") ; <CJK>
       (?$(J'd(B . "0x80B7") ; <CJK>
       (?$(J'i(B . "0x80B9") ; <CJK>
       (?$(J'j(B . "0x80BB") ; <CJK>
       (?$(J'l(B . "0x81E4") ; <CJK>
       (?$(J'm(B . "0x81FD") ; <CJK>
       (?$(J'n(B . "0x820F") ; <CJK>
       (?$(J'z(B . "0x82BF") ; <CJK>
       (?$(J'{(B . "0x82CA") ; <CJK>
       (?$(J'~(B . "0x82C1") ; <CJK>
       (?$(J(&(B . "0x8FD0") ; <CJK>
       (?$(J(+(B . "0x90AE") ; <CJK>
       (?$(J(3(B . "0x9638") ; <CJK>
       (?$(J(8(B . "0x4FBC") ; <CJK>
       (?$(J(=(B . "0x4FE9") ; <CJK>
       (?$(J(>(B . "0x4FBD") ; <CJK>
       (?$(J(?(B . "0x4FE2") ; <CJK>
       (?$(J(@(B . "0x5158") ; <CJK>
       (?$(J(I(B . "0x52C6") ; <CJK>
       (?$(J(K(B . "0x52C8") ; <CJK>
       (?$(J(N(B . "0x5328") ; <CJK>
       (?$(J(P(B . "0x5329") ; <CJK>
       (?$(J(^(B . "0x57B4") ; <CJK>
       (?$(J(`(B . "0x57A9") ; <CJK>
       (?$(J(n(B . "0x5B68") ; <CJK>
       (?$(J(}(B . "0x5CD5") ; <CJK>
       (?$(J),(B . "0x5F2B") ; <CJK>
       (?$(J)1(B . "0x5F8D") ; <CJK>
       (?$(J)6(B . "0x6018") ; <CJK>
       (?$(J)>(B . "0x6057") ; <CJK>
       (?$(J)?(B . "0x6048") ; <CJK>
       (?$(J)J(B . "0x6094") ; <CJK>
       (?$(J)K(B . "0x6071") ; <CJK>
       (?$(J)Q(B . "0x6312") ; <CJK>
       (?$(J)Y(B . "0x630A") ; <CJK>
       (?$(J)[(B . "0x6323") ; <CJK>
       (?$(J)g(B . "0x662A") ; <CJK>
       (?$(J)m(B . "0x67E0") ; <CJK>
       (?$(J)n(B . "0x67BE") ; <CJK>
       (?$(J)r(B . "0x6B29") ; <CJK>
       (?$(J*!(B . "0x6D43") ; <CJK>
       (?$(J*%(B . "0x6D77") ; <CJK>
       (?$(J*&(B . "0x70A6") ; <CJK>
       (?$(J*((B . "0x70C0") ; <CJK>
       (?$(J**(B . "0x722F") ; <CJK>
       (?$(J*/(B . "0x7271") ; <CJK>
       (?$(J*<(B . "0x74EA") ; <CJK>
       (?$(J*@(B . "0x7520") ; <CJK>
       (?$(J*J(B . "0x75A9") ; <CJK>
       (?$(J*L(B . "0x7685") ; <CJK>
       (?$(J*R(B . "0x7706") ; <CJK>
       (?$(J*U(B . "0x76F6") ; <CJK>
       (?$(J*Y(B . "0x7700") ; <CJK>
       (?$(J*](B . "0x7702") ; <CJK>
       (?$(J*n(B . "0x79CC") ; <CJK>
       (?$(J+%(B . "0x8009") ; <CJK>
       (?$(J+:(B . "0x82DA") ; <CJK>
       (?$(J+=(B . "0x830A") ; <CJK>
       (?$(J+[(B . "0x9655") ; <CJK>
       (?$(J+](B . "0x9652") ; <CJK>
       (?$(J+^(B . "0x4E35") ; <CJK>
       (?$(J+a(B . "0x5034") ; <CJK>
       (?$(J+b(B . "0x5001") ; <CJK>
       (?$(J+d(B . "0x500A") ; <CJK>
       (?$(J+n(B . "0x5258") ; <CJK>
       (?$(J+x(B . "0x532B") ; <CJK>
       (?$(J,&(B . "0x54EC") ; <CJK>
       (?$(J,((B . "0x5515") ; <CJK>
       (?$(J,)(B . "0x54FE") ; <CJK>
       (?$(J,-(B . "0x54E3") ; <CJK>
       (?$(J,.(B . "0x5516") ; <CJK>
       (?$(J,3(B . "0x57D3") ; <CJK>
       (?$(J,8(B . "0x5959") ; <CJK>
       (?$(J,9(B . "0x5A27") ; <CJK>
       (?$(J,=(B . "0x5A28") ; <CJK>
       (?$(J,>(B . "0x5A10") ; <CJK>
       (?$(J,@(B . "0x5A0E") ; <CJK>
       (?$(J,F(B . "0x5BAF") ; <CJK>
       (?$(J,H(B . "0x5BBA") ; <CJK>
       (?$(J,I(B . "0x5BB1") ; <CJK>
       (?$(J,\(B . "0x5CFC") ; <CJK>
       (?$(J,`(B . "0x5CF2") ; <CJK>
       (?$(J,a(B . "0x5CFE") ; <CJK>
       (?$(J,d(B . "0x5DF8") ; <CJK>
       (?$(J,p(B . "0x5F2C") ; <CJK>
       (?$(J-%(B . "0x6082") ; <CJK>
       (?$(J-,(B . "0x6091") ; <CJK>
       (?$(J--(B . "0x608F") ; <CJK>
       (?$(J-C(B . "0x6547") ; <CJK>
       (?$(J-D(B . "0x654C") ; <CJK>
       (?$(J-F(B . "0x654F") ; <CJK>
       (?$(J-G(B . "0x658A") ; <CJK>
       (?$(J-N(B . "0x67E1") ; <CJK>
       (?$(J-O(B . "0x684A") ; <CJK>
       (?$(J-S(B . "0x6857") ; <CJK>
       (?$(J-U(B . "0x683F") ; <CJK>
       (?$(J-Y(B . "0x67BD") ; <CJK>
       (?$(J-\(B . "0x6885") ; <CJK>
       (?$(J-e(B . "0x6BBA") ; <CJK>
       (?$(J-p(B . "0x6D41") ; <CJK>
       (?$(J-u(B . "0x70C9") ; <CJK>
       (?$(J.*(B . "0x73BA") ; <CJK>
       (?$(J.4(B . "0x75C6") ; <CJK>
       (?$(J.@(B . "0x75B7") ; <CJK>
       (?$(J.A(B . "0x768C") ; <CJK>
       (?$(J.C(B . "0x768D") ; <CJK>
       (?$(J.O(B . "0x7717") ; <CJK>
       (?$(J.Q(B . "0x771C") ; <CJK>
       (?$(J.U(B . "0x7714") ; <CJK>
       (?$(J.Y(B . "0x781E") ; <CJK>
       (?$(J.q(B . "0x7B0C") ; <CJK>
       (?$(J/%(B . "0x7D23") ; <CJK>
       (?$(J//(B . "0x7F98") ; <CJK>
       (?$(J/0(B . "0x7F90") ; <CJK>
       (?$(J/:(B . "0x803A") ; <CJK>
       (?$(J/O(B . "0x8226") ; <CJK>
       (?$(J/Z(B . "0x832E") ; <CJK>
       (?$(J/\(B . "0x8355") ; <CJK>
       (?$(J/](B . "0x831A") ; <CJK>
       (?$(J/_(B . "0x833D") ; <CJK>
       (?$(J/c(B . "0x8330") ; <CJK>
       (?$(J/h(B . "0x8651") ; <CJK>
       (?$(J/u(B . "0x898E") ; <CJK>
       (?$(J/v(B . "0x898D") ; <CJK>
       (?$(J/|(B . "0x8A09") ; <CJK>
       (?$(J/}(B . "0x8A14") ; <CJK>
       (?$(J0/(B . "0x9007") ; <CJK>
       (?$(J0:(B . "0x9579") ; <CJK>
       (?$(J0;(B . "0x9584") ; <CJK>
       (?$(J0?(B . "0x9657") ; <CJK>
       (?$(J0A(B . "0x96BA") ; <CJK>
       (?$(J0B(B . "0x98E4") ; <CJK>
       (?$(J0G(B . "0x5067") ; <CJK>
       (?$(J0^(B . "0x5318") ; <CJK>
       (?$(J0_(B . "0x532C") ; <CJK>
       (?$(J0`(B . "0x5359") ; <CJK>
       (?$(J0d(B . "0x5368") ; <CJK>
       (?$(J0e(B . "0x537E") ; <CJK>
       (?$(J0h(B . "0x53A1") ; <CJK>
       (?$(J0k(B . "0x555B") ; <CJK>
       (?$(J0r(B . "0x5542") ; <CJK>
       (?$(J0t(B . "0x5547") ; <CJK>
       (?$(J0w(B . "0x553D") ; <CJK>
       (?$(J0z(B . "0x5560") ; <CJK>
       (?$(J0{(B . "0x57EB") ; <CJK>
       (?$(J1&(B . "0x595F") ; <CJK>
       (?$(J1,(B . "0x5B6F") ; <CJK>
       (?$(J15(B . "0x5C5A") ; <CJK>
       (?$(J1R(B . "0x5FA2") ; <CJK>
       (?$(J1S(B . "0x5F9D") ; <CJK>
       (?$(J1W(B . "0x5FA3") ; <CJK>
       (?$(J1h(B . "0x60C2") ; <CJK>
       (?$(J1k(B . "0x60A5") ; <CJK>
       (?$(J1n(B . "0x621C") ; <CJK>
       (?$(J1p(B . "0x621D") ; <CJK>
       (?$(J1w(B . "0x6395") ; <CJK>
       (?$(J1x(B . "0x639A") ; <CJK>
       (?$(J2#(B . "0x63A6") ; <CJK>
       (?$(J2+(B . "0x6550") ; <CJK>
       (?$(J2/(B . "0x6552") ; <CJK>
       (?$(J24(B . "0x65C8") ; <CJK>
       (?$(J29(B . "0x6658") ; <CJK>
       (?$(J2>(B . "0x6717") ; <CJK>
       (?$(J2?(B . "0x6888") ; <CJK>
       (?$(J2N(B . "0x6BB8") ; <CJK>
       (?$(J2P(B . "0x6BB9") ; <CJK>
       (?$(J2m(B . "0x6E0B") ; <CJK>
       (?$(J2r(B . "0x7105") ; <CJK>
       (?$(J3"(B . "0x7314") ; <CJK>
       (?$(J3#(B . "0x7304") ; <CJK>
       (?$(J3*(B . "0x7305") ; <CJK>
       (?$(J3,(B . "0x7315") ; <CJK>
       (?$(J3-(B . "0x730D") ; <CJK>
       (?$(J3O(B . "0x772E") ; <CJK>
       (?$(J3V(B . "0x7741") ; <CJK>
       (?$(J3[(B . "0x77EA") ; <CJK>
       (?$(J3](B . "0x7844") ; <CJK>
       (?$(J3z(B . "0x7B29") ; <CJK>
       (?$(J3|(B . "0x7B27") ; <CJK>
       (?$(J4"(B . "0x7C9D") ; <CJK>
       (?$(J4=(B . "0x7FC8") ; <CJK>
       (?$(J4G(B . "0x8126") ; <CJK>
       (?$(J4M(B . "0x811C") ; <CJK>
       (?$(J4P(B . "0x8128") ; <CJK>
       (?$(J4g(B . "0x8370") ; <CJK>
       (?$(J4m(B . "0x8382") ; <CJK>
       (?$(J4o(B . "0x83AC") ; <CJK>
       (?$(J4z(B . "0x86AD") ; <CJK>
       (?$(J5&(B . "0x86CA") ; <CJK>
       (?$(J5'(B . "0x8851") ; <CJK>
       (?$(J5/(B . "0x889D") ; <CJK>
       (?$(J54(B . "0x8990") ; <CJK>
       (?$(J58(B . "0x89D8") ; <CJK>
       (?$(J59(B . "0x89D7") ; <CJK>
       (?$(J5=(B . "0x8A2E") ; <CJK>
       (?$(J5M(B . "0x8C59") ; <CJK>
       (?$(J5c(B . "0x8EDA") ; <CJK>
       (?$(J5f(B . "0x9033") ; <CJK>
       (?$(J5h(B . "0x9018") ; <CJK>
       (?$(J5{(B . "0x91EF") ; <CJK>
       (?$(J6-(B . "0x9AD9") ; <CJK>
       (?$(J6.(B . "0x4EB4") ; <CJK>
       (?$(J60(B . "0x50A0") ; <CJK>
       (?$(J61(B . "0x5090") ; <CJK>
       (?$(J63(B . "0x5086") ; <CJK>
       (?$(J64(B . "0x5084") ; <CJK>
       (?$(J66(B . "0x508A") ; <CJK>
       (?$(J69(B . "0x509F") ; <CJK>
       (?$(J6:(B . "0x50A1") ; <CJK>
       (?$(J6<(B . "0x5093") ; <CJK>
       (?$(J6?(B . "0x51D5") ; <CJK>
       (?$(J6L(B . "0x52E4") ; <CJK>
       (?$(J6\(B . "0x5590") ; <CJK>
       (?$(J6h(B . "0x5710") ; <CJK>
       (?$(J6i(B . "0x5817") ; <CJK>
       (?$(J6m(B . "0x5844") ; <CJK>
       (?$(J6o(B . "0x582B") ; <CJK>
       (?$(J6q(B . "0x5845") ; <CJK>
       (?$(J6v(B . "0x5832") ; <CJK>
       (?$(J6y(B . "0x5965") ; <CJK>
       (?$(J7$(B . "0x5BCF") ; <CJK>
       (?$(J7/(B . "0x5D56") ; <CJK>
       (?$(J75(B . "0x5D54") ; <CJK>
       (?$(J7E(B . "0x5F3D") ; <CJK>
       (?$(J7J(B . "0x5FA4") ; <CJK>
       (?$(J7`(B . "0x63EC") ; <CJK>
       (?$(J7o(B . "0x63FA") ; <CJK>
       (?$(J7q(B . "0x63D4") ; <CJK>
       (?$(J8$(B . "0x6675") ; <CJK>
       (?$(J8)(B . "0x671C") ; <CJK>
       (?$(J82(B . "0x68D9") ; <CJK>
       (?$(J8N(B . "0x6BF1") ; <CJK>
       (?$(J8[(B . "0x6E37") ; <CJK>
       (?$(J8\(B . "0x6E7C") ; <CJK>
       (?$(J8^(B . "0x6E7D") ; <CJK>
       (?$(J8_(B . "0x6E86") ; <CJK>
       (?$(J9%(B . "0x74FA") ; <CJK>
       (?$(J9,(B . "0x7572") ; <CJK>
       (?$(J94(B . "0x75DC") ; <CJK>
       (?$(J9T(B . "0x7867") ; <CJK>
       (?$(J9Z(B . "0x7977") ; <CJK>
       (?$(J9[(B . "0x79BC") ; <CJK>
       (?$(J9e(B . "0x7A9B") ; <CJK>
       (?$(J:&(B . "0x7D2A") ; <CJK>
       (?$(J:'(B . "0x7D65") ; <CJK>
       (?$(J:+(B . "0x7F64") ; <CJK>
       (?$(J:8(B . "0x8020") ; <CJK>
       (?$(J:;(B . "0x8120") ; <CJK>
       (?$(J:>(B . "0x813C") ; <CJK>
       (?$(J:G(B . "0x813F") ; <CJK>
       (?$(J:L(B . "0x81F0") ; <CJK>
       (?$(J:M(B . "0x81F5") ; <CJK>
       (?$(J:g(B . "0x8415") ; <CJK>
       (?$(J:h(B . "0x83BE") ; <CJK>
       (?$(J:o(B . "0x86E5") ; <CJK>
       (?$(J:q(B . "0x86D2") ; <CJK>
       (?$(J:u(B . "0x8688") ; <CJK>
       (?$(J:v(B . "0x86E0") ; <CJK>
       (?$(J:{(B . "0x88B3") ; <CJK>
       (?$(J;,(B . "0x8A53") ; <CJK>
       (?$(J;/(B . "0x8A37") ; <CJK>
       (?$(J;0(B . "0x8A47") ; <CJK>
       (?$(J;1(B . "0x8A5C") ; <CJK>
       (?$(J;U(B . "0x8EF0") ; <CJK>
       (?$(J;f(B . "0x921D") ; <CJK>
       (?$(J;w(B . "0x976B") ; <CJK>
       (?$(J<)(B . "0x50C0") ; <CJK>
       (?$(J<0(B . "0x50E7") ; <CJK>
       (?$(J<<(B . "0x52E5") ; <CJK>
       (?$(J<@(B . "0x53AF") ; <CJK>
       (?$(J<K(B . "0x55D8") ; <CJK>
       (?$(J<R(B . "0x5711") ; <CJK>
       (?$(J<S(B . "0x5867") ; <CJK>
       (?$(J<W(B . "0x5843") ; <CJK>
       (?$(J<n(B . "0x5BDD") ; <CJK>
       (?$(J<t(B . "0x5D70") ; <CJK>
       (?$(J<u(B . "0x5D6A") ; <CJK>
       (?$(J<x(B . "0x5D74") ; <CJK>
       (?$(J<y(B . "0x5D5F") ; <CJK>
       (?$(J<{(B . "0x5D61") ; <CJK>
       (?$(J<|(B . "0x5D73") ; <CJK>
       (?$(J=*(B . "0x5E50") ; <CJK>
       (?$(J=0(B . "0x5F3F") ; <CJK>
       (?$(J=4(B . "0x5FB0") ; <CJK>
       (?$(J=8(B . "0x6135") ; <CJK>
       (?$(J=9(B . "0x612D") ; <CJK>
       (?$(J==(B . "0x6102") ; <CJK>
       (?$(J=C(B . "0x6226") ; <CJK>
       (?$(J=](B . "0x656E") ; <CJK>
       (?$(J=d(B . "0x65D4") ; <CJK>
       (?$(J=i(B . "0x6685") ; <CJK>
       (?$(J=l(B . "0x6972") ; <CJK>
       (?$(J=q(B . "0x693A") ; <CJK>
       (?$(J>6(B . "0x6EAD") ; <CJK>
       (?$(J>?(B . "0x6E95") ; <CJK>
       (?$(J>L(B . "0x7243") ; <CJK>
       (?$(J>O(B . "0x728F") ; <CJK>
       (?$(J>k(B . "0x7575") ; <CJK>
       (?$(J>w(B . "0x75EC") ; <CJK>
       (?$(J?)(B . "0x7757") ; <CJK>
       (?$(J?F(B . "0x797B") ; <CJK>
       (?$(J?J(B . "0x7A21") ; <CJK>
       (?$(J?P(B . "0x7A16") ; <CJK>
       (?$(J?W(B . "0x7AE8") ; <CJK>
       (?$(J?^(B . "0x7B6A") ; <CJK>
       (?$(J?g(B . "0x7B5F") ; <CJK>
       (?$(J?q(B . "0x7D82") ; <CJK>
       (?$(J?s(B . "0x7DD0") ; <CJK>
       (?$(J?|(B . "0x8055") ; <CJK>
       (?$(J@)(B . "0x8168") ; <CJK>
       (?$(J@-(B . "0x8246") ; <CJK>
       (?$(J@.(B . "0x8243") ; <CJK>
       (?$(J@6(B . "0x8481") ; <CJK>
       (?$(J@A(B . "0x847C") ; <CJK>
       (?$(J@D(B . "0x846A") ; <CJK>
       (?$(J@F(B . "0x8488") ; <CJK>
       (?$(J@O(B . "0x865C") ; <CJK>
       (?$(J@R(B . "0x8710") ; <CJK>
       (?$(J@U(B . "0x871F") ; <CJK>
       (?$(J@Y(B . "0x870F") ; <CJK>
       (?$(J@a(B . "0x88D3") ; <CJK>
       (?$(J@x(B . "0x8C87") ; <CJK>
       (?$(J@~(B . "0x8CC6") ; <CJK>
       (?$(JA9(B . "0x90CC") ; <CJK>
       (?$(JA:(B . "0x916D") ; <CJK>
       (?$(JA;(B . "0x9170") ; <CJK>
       (?$(JA@(B . "0x9258") ; <CJK>
       (?$(JAA(B . "0x9242") ; <CJK>
       (?$(JAB(B . "0x9268") ; <CJK>
       (?$(JAC(B . "0x9269") ; <CJK>
       (?$(JAF(B . "0x9243") ; <CJK>
       (?$(JAH(B . "0x9247") ; <CJK>
       (?$(JAS(B . "0x959D") ; <CJK>
       (?$(JAW(B . "0x96CF") ; <CJK>
       (?$(JAc(B . "0x97F4") ; <CJK>
       (?$(JAh(B . "0x9809") ; <CJK>
       (?$(JAq(B . "0x98AB") ; <CJK>
       (?$(JA{(B . "0x98FB") ; <CJK>
       (?$(JA}(B . "0x9AAC") ; <CJK>
       (?$(JA~(B . "0x9AAE") ; <CJK>
       (?$(JB!(B . "0x9AAA") ; <CJK>
       (?$(JB)(B . "0x9B5C") ; <CJK>
       (?$(JB-(B . "0x50D2") ; <CJK>
       (?$(JB5(B . "0x50DF") ; <CJK>
       (?$(JBK(B . "0x5619") ; <CJK>
       (?$(JBW(B . "0x560A") ; <CJK>
       (?$(JBY(B . "0x589A") ; <CJK>
       (?$(JBz(B . "0x5C32") ; <CJK>
       (?$(JC,(B . "0x5D85") ; <CJK>
       (?$(JC0(B . "0x5E56") ; <CJK>
       (?$(JC5(B . "0x5E51") ; <CJK>
       (?$(JC?(B . "0x5FB1") ; <CJK>
       (?$(JCQ(B . "0x618E") ; <CJK>
       (?$(JC](B . "0x645A") ; <CJK>
       (?$(JC^(B . "0x6463") ; <CJK>
       (?$(JCk(B . "0x669B") ; <CJK>
       (?$(JCm(B . "0x66A3") ; <CJK>
       (?$(JCo(B . "0x669E") ; <CJK>
       (?$(JCw(B . "0x69B8") ; <CJK>
       (?$(JCy(B . "0x69BA") ; <CJK>
       (?$(JD'(B . "0x69C7") ; <CJK>
       (?$(JD((B . "0x69D7") ; <CJK>
       (?$(JD-(B . "0x6B70") ; <CJK>
       (?$(JD1(B . "0x6B9D") ; <CJK>
       (?$(JDC(B . "0x6F16") ; <CJK>
       (?$(JDD(B . "0x6F24") ; <CJK>
       (?$(JDR(B . "0x6F45") ; <CJK>
       (?$(JDW(B . "0x7179") ; <CJK>
       (?$(JDX(B . "0x7193") ; <CJK>
       (?$(JD[(B . "0x717A") ; <CJK>
       (?$(JD^(B . "0x7254") ; <CJK>
       (?$(JD{(B . "0x757C") ; <CJK>
       (?$(JD|(B . "0x757B") ; <CJK>
       (?$(JD~(B . "0x7612") ; <CJK>
       (?$(JE4(B . "0x76B6") ; <CJK>
       (?$(JE5(B . "0x76E0") ; <CJK>
       (?$(JE=(B . "0x7773") ; <CJK>
       (?$(JE@(B . "0x7772") ; <CJK>
       (?$(JEB(B . "0x7770") ; <CJK>
       (?$(JES(B . "0x789D") ; <CJK>
       (?$(JE](B . "0x7A27") ; <CJK>
       (?$(JE^(B . "0x7A35") ; <CJK>
       (?$(JEd(B . "0x7BA2") ; <CJK>
       (?$(JEk(B . "0x7B89") ; <CJK>
       (?$(JEp(B . "0x7BA5") ; <CJK>
       (?$(JEt(B . "0x7CB6") ; <CJK>
       (?$(JE{(B . "0x7DA5") ; <CJK>
       (?$(JE|(B . "0x7DC3") ; <CJK>
       (?$(JF&(B . "0x7FAB") ; <CJK>
       (?$(JF,(B . "0x8025") ; <CJK>
       (?$(JF3(B . "0x8059") ; <CJK>
       (?$(JF9(B . "0x8185") ; <CJK>
       (?$(JFF(B . "0x818E") ; <CJK>
       (?$(JFX(B . "0x84BE") ; <CJK>
       (?$(JFl(B . "0x84A6") ; <CJK>
       (?$(JF~(B . "0x872F") ; <CJK>
       (?$(JG5(B . "0x89A0") ; <CJK>
       (?$(JGE(B . "0x8A97") ; <CJK>
       (?$(JGT(B . "0x8C8B") ; <CJK>
       (?$(JGj(B . "0x8F0F") ; <CJK>
       (?$(JGu(B . "0x9275") ; <CJK>
       (?$(JGw(B . "0x929F") ; <CJK>
       (?$(JH"(B . "0x95A6") ; <CJK>
       (?$(JH$(B . "0x969A") ; <CJK>
       (?$(JH5(B . "0x9757") ; <CJK>
       (?$(JHF(B . "0x97F7") ; <CJK>
       (?$(JHW(B . "0x98B0") ; <CJK>
       (?$(JH`(B . "0x99C6") ; <CJK>
       (?$(JHk(B . "0x9B62") ; <CJK>
       (?$(JHy(B . "0x50FA") ; <CJK>
       (?$(JI%(B . "0x5285") ; <CJK>
       (?$(JI.(B . "0x5643") ; <CJK>
       (?$(JI1(B . "0x563C") ; <CJK>
       (?$(JI2(B . "0x5668") ; <CJK>
       (?$(JID(B . "0x5BED") ; <CJK>
       (?$(JII(B . "0x5C35") ; <CJK>
       (?$(JI^(B . "0x5F47") ; <CJK>
       (?$(JIo(B . "0x616D") ; <CJK>
       (?$(JJ'(B . "0x649D") ; <CJK>
       (?$(JJ=(B . "0x69F5") ; <CJK>
       (?$(JJH(B . "0x6A03") ; <CJK>
       (?$(JJK(B . "0x6A65") ; <CJK>
       (?$(JJN(B . "0x6B75") ; <CJK>
       (?$(JJW(B . "0x6F8A") ; <CJK>
       (?$(JJX(B . "0x6F56") ; <CJK>
       (?$(JJd(B . "0x6F98") ; <CJK>
       (?$(JJi(B . "0x6F68") ; <CJK>
       (?$(JJl(B . "0x7234") ; <CJK>
       (?$(JJm(B . "0x7245") ; <CJK>
       (?$(JJu(B . "0x735C") ; <CJK>
       (?$(JJw(B . "0x7356") ; <CJK>
       (?$(JKW(B . "0x78BF") ; <CJK>
       (?$(JKY(B . "0x78BD") ; <CJK>
       (?$(JK](B . "0x78E4") ; <CJK>
       (?$(JKc(B . "0x7A34") ; <CJK>
       (?$(JKk(B . "0x7A36") ; <CJK>
       (?$(JKs(B . "0x7BBA") ; <CJK>
       (?$(JKt(B . "0x7BBC") ; <CJK>
       (?$(JKv(B . "0x7BC8") ; <CJK>
       (?$(JKx(B . "0x7BC3") ; <CJK>
       (?$(JKz(B . "0x7BB6") ; <CJK>
       (?$(JL!(B . "0x7BC2") ; <CJK>
       (?$(JL&(B . "0x7BC5") ; <CJK>
       (?$(JL*(B . "0x7BBD") ; <CJK>
       (?$(JL+(B . "0x7BB0") ; <CJK>
       (?$(JL1(B . "0x7BBB") ; <CJK>
       (?$(JLE(B . "0x7E04") ; <CJK>
       (?$(JLb(B . "0x81F1") ; <CJK>
       (?$(JLj(B . "0x8522") ; <CJK>
       (?$(JLx(B . "0x8532") ; <CJK>
       (?$(JLz(B . "0x8510") ; <CJK>
       (?$(JM%(B . "0x854F") ; <CJK>
       (?$(JM((B . "0x8772") ; <CJK>
       (?$(JM1(B . "0x877C") ; <CJK>
       (?$(JM3(B . "0x8779") ; <CJK>
       (?$(JM>(B . "0x890D") ; <CJK>
       (?$(JMF(B . "0x8908") ; <CJK>
       (?$(JMu(B . "0x8D9E") ; <CJK>
       (?$(JN+(B . "0x8F28") ; <CJK>
       (?$(JN-(B . "0x8F21") ; <CJK>
       (?$(JN2(B . "0x9066") ; <CJK>
       (?$(JN3(B . "0x906C") ; <CJK>
       (?$(JN;(B . "0x90F6") ; <CJK>
       (?$(JND(B . "0x92EC") ; <CJK>
       (?$(JNE(B . "0x92BA") ; <CJK>
       (?$(JNF(B . "0x92E3") ; <CJK>
       (?$(JNG(B . "0x92BD") ; <CJK>
       (?$(JNJ(B . "0x95B4") ; <CJK>
       (?$(JNW(B . "0x97D1") ; <CJK>
       (?$(JNZ(B . "0x9823") ; <CJK>
       (?$(JNc(B . "0x990B") ; <CJK>
       (?$(JNt(B . "0x9AB2") ; <CJK>
       (?$(JNy(B . "0x9ADB") ; <CJK>
       (?$(JO!(B . "0x9AF0") ; <CJK>
       (?$(JO*(B . "0x9B73") ; <CJK>
       (?$(JO,(B . "0x9B6E") ; <CJK>
       (?$(JO0(B . "0x9B65") ; <CJK>
       (?$(JO5(B . "0x9B6A") ; <CJK>
       (?$(JO7(B . "0x9B6D") ; <CJK>
       (?$(JOB(B . "0x9D0B") ; <CJK>
       (?$(JOH(B . "0x9E76") ; <CJK>
       (?$(JOL(B . "0x9EA8") ; <CJK>
       (?$(JOV(B . "0x9F11") ; <CJK>
       (?$(JOZ(B . "0x5119") ; <CJK>
       (?$(JOd(B . "0x5292") ; <CJK>
       (?$(JOq(B . "0x5675") ; <CJK>
       (?$(JO{(B . "0x596F") ; <CJK>
       (?$(JP7(B . "0x61A5") ; <CJK>
       (?$(JP;(B . "0x61A0") ; <CJK>
       (?$(JPI(B . "0x657E") ; <CJK>
       (?$(JPN(B . "0x65B4") ; <CJK>
       (?$(JPO(B . "0x65D8") ; <CJK>
       (?$(JPP(B . "0x66C2") ; <CJK>
       (?$(JPm(B . "0x6BA8") ; <CJK>
       (?$(JPu(B . "0x6F83") ; <CJK>
       (?$(JQ"(B . "0x6FC5") ; <CJK>
       (?$(JQ#(B . "0x71CD") ; <CJK>
       (?$(JQ-(B . "0x729C") ; <CJK>
       (?$(JQ8(B . "0x7499") ; <CJK>
       (?$(JQ9(B . "0x748F") ; <CJK>
       (?$(JQ:(B . "0x7491") ; <CJK>
       (?$(JQM(B . "0x7639") ; <CJK>
       (?$(JQO(B . "0x762E") ; <CJK>
       (?$(JQT(B . "0x769F") ; <CJK>
       (?$(JQU(B . "0x76A0") ; <CJK>
       (?$(JQ_(B . "0x7794") ; <CJK>
       (?$(JQa(B . "0x77AE") ; <CJK>
       (?$(JQn(B . "0x78E6") ; <CJK>
       (?$(JR'(B . "0x7ABC") ; <CJK>
       (?$(JR-(B . "0x7BD6") ; <CJK>
       (?$(JRD(B . "0x7CCF") ; <CJK>
       (?$(JRL(B . "0x7E18") ; <CJK>
       (?$(JR\(B . "0x806D") ; <CJK>
       (?$(JRg(B . "0x8190") ; <CJK>
       (?$(JS$(B . "0x8552") ; <CJK>
       (?$(JS3(B . "0x8550") ; <CJK>
       (?$(JS9(B . "0x87A0") ; <CJK>
       (?$(JS<(B . "0x8786") ; <CJK>
       (?$(JSA(B . "0x8795") ; <CJK>
       (?$(JSD(B . "0x878C") ; <CJK>
       (?$(JSK(B . "0x8860") ; <CJK>
       (?$(JSL(B . "0x8860") ; <CJK>
       (?$(JSP(B . "0x8928") ; <CJK>
       (?$(JSS(B . "0x8920") ; <CJK>
       (?$(JSY(B . "0x89A8") ; <CJK>
       (?$(JT)(B . "0x8E3A") ; <CJK>
       (?$(JTB(B . "0x9194") ; <CJK>
       (?$(JTC(B . "0x9311") ; <CJK>
       (?$(JTE(B . "0x9337") ; <CJK>
       (?$(JTI(B . "0x9343") ; <CJK>
       (?$(JTR(B . "0x96A6") ; <CJK>
       (?$(JT_(B . "0x9795") ; <CJK>
       (?$(JTg(B . "0x9796") ; <CJK>
       (?$(JTp(B . "0x9825") ; <CJK>
       (?$(JT~(B . "0x9926") ; <CJK>
       (?$(JU!(B . "0x9934") ; <CJK>
       (?$(JU1(B . "0x9ABA") ; <CJK>
       (?$(JUC(B . "0x9B81") ; <CJK>
       (?$(JUE(B . "0x9B8A") ; <CJK>
       (?$(JUG(B . "0x9B7F") ; <CJK>
       (?$(JUR(B . "0x9D11") ; <CJK>
       (?$(JU`(B . "0x9ED9") ; <CJK>
       (?$(JUc(B . "0x9F3C") ; <CJK>
       (?$(JUe(B . "0x5123") ; <CJK>
       (?$(JUi(B . "0x512C") ; <CJK>
       (?$(JUm(B . "0x5295") ; <CJK>
       (?$(JUt(B . "0x5688") ; <CJK>
       (?$(JUx(B . "0x568B") ; <CJK>
       (?$(JV2(B . "0x61E1") ; <CJK>
       (?$(JV3(B . "0x61D7") ; <CJK>
       (?$(JV?(B . "0x65A3") ; <CJK>
       (?$(JVA(B . "0x66D3") ; <CJK>
       (?$(JVE(B . "0x6A8B") ; <CJK>
       (?$(JVR(B . "0x6BAC") ; <CJK>
       (?$(JV](B . "0x701E") ; <CJK>
       (?$(JVl(B . "0x7374") ; <CJK>
       (?$(JW!(B . "0x7640") ; <CJK>
       (?$(JW$(B . "0x7641") ; <CJK>
       (?$(JW-(B . "0x76E8") ; <CJK>
       (?$(JW>(B . "0x78F6") ; <CJK>
       (?$(JW@(B . "0x7900") ; <CJK>
       (?$(JWH(B . "0x7A59") ; <CJK>
       (?$(JWI(B . "0x7A55") ; <CJK>
       (?$(JWP(B . "0x7AF4") ; <CJK>
       (?$(JWT(B . "0x7C04") ; <CJK>
       (?$(JWW(B . "0x7C15") ; <CJK>
       (?$(JW_(B . "0x7BF5") ; <CJK>
       (?$(JX'(B . "0x81C1") ; <CJK>
       (?$(JX>(B . "0x857D") ; <CJK>
       (?$(JX@(B . "0x85A5") ; <CJK>
       (?$(JXb(B . "0x893A") ; <CJK>
       (?$(JY-(B . "0x8E51") ; <CJK>
       (?$(JY?(B . "0x9198") ; <CJK>
       (?$(JYF(B . "0x9384") ; <CJK>
       (?$(JYG(B . "0x9381") ; <CJK>
       (?$(JYI(B . "0x936F") ; <CJK>
       (?$(JYp(B . "0x9842") ; <CJK>
       (?$(JZ)(B . "0x9937") ; <CJK>
       (?$(JZ7(B . "0x9AFF") ; <CJK>
       (?$(JZ?(B . "0x9BA9") ; <CJK>
       (?$(JZA(B . "0x9BA7") ; <CJK>
       (?$(JZC(B . "0x9BB3") ; <CJK>
       (?$(JZD(B . "0x9BAC") ; <CJK>
       (?$(JZE(B . "0x9BB0") ; <CJK>
       (?$(JZI(B . "0x9B9C") ; <CJK>
       (?$(JZM(B . "0x9D3C") ; <CJK>
       (?$(JZN(B . "0x9D1C") ; <CJK>
       (?$(JZO(B . "0x9D3A") ; <CJK>
       (?$(JZU(B . "0x9D32") ; <CJK>
       (?$(JZV(B . "0x9D34") ; <CJK>
       (?$(JZ](B . "0x9EC7") ; <CJK>
       (?$(JZd(B . "0x9F3F") ; <CJK>
       (?$(J[!(B . "0x5EEB") ; <CJK>
       (?$(J[+(B . "0x61D5") ; <CJK>
       (?$(J[6(B . "0x6502") ; <CJK>
       (?$(J[^(B . "0x7012") ; <CJK>
       (?$(J[t(B . "0x7585") ; <CJK>
       (?$(J[u(B . "0x7654") ; <CJK>
       (?$(J[y(B . "0x7655") ; <CJK>
       (?$(J[|(B . "0x76A7") ; <CJK>
       (?$(J[}(B . "0x76A8") ; <CJK>
       (?$(J\2(B . "0x790F") ; <CJK>
       (?$(J\Z(B . "0x7CE4") ; <CJK>
       (?$(J\[(B . "0x7CE5") ; <CJK>
       (?$(J\^(B . "0x7E65") ; <CJK>
       (?$(J\_(B . "0x7E4E") ; <CJK>
       (?$(J\h(B . "0x7F82") ; <CJK>
       (?$(J\q(B . "0x802D") ; <CJK>
       (?$(J]((B . "0x85CA") ; <CJK>
       (?$(J],(B . "0x85BC") ; <CJK>
       (?$(J]i(B . "0x8CFF") ; <CJK>
       (?$(J^$(B . "0x91A6") ; <CJK>
       (?$(J^)(B . "0x93B6") ; <CJK>
       (?$(J^1(B . "0x93AB") ; <CJK>
       (?$(J^8(B . "0x9721") ; <CJK>
       (?$(J^C(B . "0x97A7") ; <CJK>
       (?$(J^O(B . "0x983E") ; <CJK>
       (?$(J_"(B . "0x9BBC") ; <CJK>
       (?$(J_&(B . "0x9BB7") ; <CJK>
       (?$(J_*(B . "0x9BBE") ; <CJK>
       (?$(J_4(B . "0x9D62") ; <CJK>
       (?$(J_:(B . "0x9E8F") ; <CJK>
       (?$(J_>(B . "0x9ECB") ; <CJK>
       (?$(J_M(B . "0x56A9") ; <CJK>
       (?$(J_R(B . "0x5913") ; <CJK>
       (?$(J_U(B . "0x5BF4") ; <CJK>
       (?$(J_`(B . "0x61EC") ; <CJK>
       (?$(J_a(B . "0x61EF") ; <CJK>
       (?$(J_q(B . "0x6AD6") ; <CJK>
       (?$(J_~(B . "0x7209") ; <CJK>
       (?$(J`%(B . "0x7379") ; <CJK>
       (?$(J`'(B . "0x74C6") ; <CJK>
       (?$(J`9(B . "0x77C3") ; <CJK>
       (?$(J`B(B . "0x791F") ; <CJK>
       (?$(J`E(B . "0x7A65") ; <CJK>
       (?$(J`K(B . "0x7AC6") ; <CJK>
       (?$(J`L(B . "0x7C3A") ; <CJK>
       (?$(J`N(B . "0x7C36") ; <CJK>
       (?$(J`Z(B . "0x7CEB") ; <CJK>
       (?$(J`j(B . "0x7CED") ; <CJK>
       (?$(J`o(B . "0x7F84") ; <CJK>
       (?$(J`z(B . "0x85E0") ; <CJK>
       (?$(J`{(B . "0x85F3") ; <CJK>
       (?$(Ja&(B . "0x881E") ; <CJK>
       (?$(Ja/(B . "0x89B4") ; <CJK>
       (?$(Ja7(B . "0x89F9") ; <CJK>
       (?$(Ja:(B . "0x8B44") ; <CJK>
       (?$(JaO(B . "0x8E71") ; <CJK>
       (?$(JaT(B . "0x8E79") ; <CJK>
       (?$(JaV(B . "0x8EC4") ; <CJK>
       (?$(Ja_(B . "0x908C") ; <CJK>
       (?$(Jag(B . "0x93C9") ; <CJK>
       (?$(Ja|(B . "0x97B0") ; <CJK>
       (?$(Jb0(B . "0x985A") ; <CJK>
       (?$(Jb8(B . "0x9946") ; <CJK>
       (?$(JbI(B . "0x9AC3") ; <CJK>
       (?$(JbO(B . "0x9B0F") ; <CJK>
       (?$(JbU(B . "0x9BF4") ; <CJK>
       (?$(JbV(B . "0x9BFA") ; <CJK>
       (?$(Jb\(B . "0x9BDD") ; <CJK>
       (?$(Jbf(B . "0x9BED") ; <CJK>
       (?$(Jbh(B . "0x9BEF") ; <CJK>
       (?$(Jbu(B . "0x9E96") ; <CJK>
       (?$(Jb~(B . "0x9EB3") ; <CJK>
       (?$(Jc-(B . "0x9F8F") ; <CJK>
       (?$(Jc1(B . "0x56B1") ; <CJK>
       (?$(Jc4(B . "0x5B41") ; <CJK>
       (?$(Jc9(B . "0x5E71") ; <CJK>
       (?$(JcN(B . "0x6AF6") ; <CJK>
       (?$(JcP(B . "0x6AF2") ; <CJK>
       (?$(Jch(B . "0x7588") ; <CJK>
       (?$(Jd,(B . "0x8267") ; <CJK>
       (?$(Jd7(B . "0x860E") ; <CJK>
       (?$(JdM(B . "0x8B5E") ; <CJK>
       (?$(JdO(B . "0x8D0E") ; <CJK>
       (?$(Jde(B . "0x91B6") ; <CJK>
       (?$(Jdg(B . "0x9401") ; <CJK>
       (?$(Jdk(B . "0x941D") ; <CJK>
       (?$(Jdo(B . "0x942F") ; <CJK>
       (?$(Je'(B . "0x97E0") ; <CJK>
       (?$(Je)(B . "0x97DB") ; <CJK>
       (?$(Je*(B . "0x97E0") ; <CJK>
       (?$(Je,(B . "0x9861") ; <CJK>
       (?$(Je:(B . "0x994A") ; <CJK>
       (?$(JeF(B . "0x9A33") ; <CJK>
       (?$(JeT(B . "0x9C0F") ; <CJK>
       (?$(JeW(B . "0x9C11") ; <CJK>
       (?$(JeY(B . "0x9C03") ; <CJK>
       (?$(JeZ(B . "0x9C01") ; <CJK>
       (?$(Je](B . "0x9C16") ; <CJK>
       (?$(Jei(B . "0x9D93") ; <CJK>
       (?$(Jf0(B . "0x535B") ; <CJK>
       (?$(Jf4(B . "0x56BF") ; <CJK>
       (?$(Jf;(B . "0x5DCE") ; <CJK>
       (?$(JfZ(B . "0x76AC") ; <CJK>
       (?$(Jf^(B . "0x77D2") ; <CJK>
       (?$(Jfo(B . "0x7C52") ; <CJK>
       (?$(Jg;(B . "0x8B73") ; <CJK>
       (?$(JgA(B . "0x8B76") ; <CJK>
       (?$(JgQ(B . "0x8EC7") ; <CJK>
       (?$(Jg\(B . "0x9434") ; <CJK>
       (?$(Jgb(B . "0x943E") ; <CJK>
       (?$(Jgq(B . "0x97BC") ; <CJK>
       (?$(Jh6(B . "0x9B39") ; <CJK>
       (?$(Jh9(B . "0x9C2A") ; <CJK>
       (?$(Jh;(B . "0x9C26") ; <CJK>
       (?$(Jh>(B . "0x9C27") ; <CJK>
       (?$(JhC(B . "0x9DC0") ; <CJK>
       (?$(JhD(B . "0x9DC9") ; <CJK>
       (?$(JhV(B . "0x9EEC") ; <CJK>
       (?$(Jh`(B . "0x9F68") ; <CJK>
       (?$(Ji-(B . "0x8032") ; <CJK>
       (?$(Ji.(B . "0x8031") ; <CJK>
       (?$(JiE(B . "0x89FD") ; <CJK>
       (?$(JiR(B . "0x908E") ; <CJK>
       (?$(Ji^(B . "0x97C2") ; <CJK>
       (?$(Jij(B . "0x9A4B") ; <CJK>
       (?$(Jiq(B . "0x9B1C") ; <CJK>
       (?$(Jit(B . "0x9B1B") ; <CJK>
       (?$(Jj#(B . "0x9C42") ; <CJK>
       (?$(Jj%(B . "0x9DD4") ; <CJK>
       (?$(JjC(B . "0x56D0") ; <CJK>
       (?$(JjD(B . "0x56CF") ; <CJK>
       (?$(JjF(B . "0x5DDA") ; <CJK>
       (?$(JjL(B . "0x66EA") ; <CJK>
       (?$(Jj|(B . "0x8B89") ; <CJK>
       (?$(Jk)(B . "0x9458") ; <CJK>
       (?$(JkF(B . "0x9DE7") ; <CJK>
       (?$(JkJ(B . "0x9DEA") ; <CJK>
       (?$(JkK(B . "0x9DF1") ; <CJK>
       (?$(Jk\(B . "0x9F44") ; <CJK>
       (?$(Jka(B . "0x9F6D") ; <CJK>
       (?$(Jkh(B . "0x5DD9") ; <CJK>
       (?$(Jkt(B . "0x77D6") ; <CJK>
       (?$(Jl#(B . "0x883A") ; <CJK>
       (?$(Jl%(B . "0x8975") ; <CJK>
       (?$(Jl=(B . "0x9A5D") ; <CJK>
       (?$(JlJ(B . "0x9C64") ; <CJK>
       (?$(JlV(B . "0x9E0A") ; <CJK>
       (?$(Jld(B . "0x9F73") ; <CJK>
       (?$(Jlv(B . "0x77E1") ; <CJK>
       (?$(Jm7(B . "0x9B2D") ; <CJK>
       (?$(Jm:(B . "0x9E0C") ; <CJK>
       (?$(JmH(B . "0x9F1F") ; <CJK>
       (?$(JmW(B . "0x6C0E") ; <CJK>
       (?$(Jm[(B . "0x7C70") ; <CJK>
       (?$(Jmb(B . "0x9479") ; <CJK>
       (?$(Jmd(B . "0x974A") ; <CJK>
       (?$(Jmx(B . "0x7E9D") ; <CJK>
       (?$(Jn$(B . "0x9960") ; <CJK>
       (?$(Jn3(B . "0x9F9E") ; <CJK>
       (?$(JnC(B . "0x9EF8") ; <CJK>
       (?$(JnD(B . "0x9F3A") ; <CJK>
       (?$(JnE(B . "0x9F7D") ; <CJK>
       (?$(JnU(B . "0x9F96") ; <CJK>
       ))))

(provide 'u-cns-4)

;;; u-cns-4.el ends here
 
