/******************************************
      W32 Registry Manager
      Written by himi
******************************************/


#include <windows.h>
#include <config.h>

#include <stdio.h>
#include <string.h>
#include "blockinput.h"
#include "mw32reg.h"

#ifdef MEADOW
LPCTSTR meadow_version_string = MEADOW;
LPCTSTR meadow_common_root = REG_COMMON_ROOT;
LPCTSTR meadow_common_env_root = REG_COMMON_ENV_ROOT;
LPCTSTR meadow_version_root = REG_VERSION_ROOT;
LPCTSTR meadow_version_env_root = REG_VERSION_ENV_ROOT;
#endif

LPBYTE w32_get_resource_with_class (LPCTSTR name,
				    LPCTSTR key,
				    HKEY hkey,
				    LPDWORD lpdwtype)
{
  HKEY hrkey;
  LPBYTE lpret;
  DWORD dwType;
  DWORD cbData;

  if (RegOpenKeyEx(hkey, key, 0, KEY_READ, &hrkey)
      != ERROR_SUCCESS) return (LPBYTE) NULL;

  if (RegQueryValueEx(hrkey, name, NULL, &dwType, NULL, &cbData)
      != ERROR_SUCCESS) goto error; 
      
  if (dwType != REG_SZ) goto error;
  lpret = (LPBYTE) xmalloc(cbData);
  if (RegQueryValueEx(hrkey, name, NULL, &dwType, lpret, &cbData) !=
      ERROR_SUCCESS)  goto error;

  if (lpdwtype) *lpdwtype = dwType;

  RegCloseKey(hrkey);
  return lpret;

 error:
  RegCloseKey(hrkey);
  return (LPBYTE) NULL;
  
}
      
LPBYTE w32_get_string_resource (LPCTSTR name, LPCTSTR key)
{
  LPBYTE lpret = NULL;

  if (!name) return NULL;
  lpret = w32_get_resource_with_class(name, key,
				      HKEY_CURRENT_USER, (LPDWORD) 0);
  if (!lpret)
    lpret = w32_get_resource_with_class(name, key,
					HKEY_LOCAL_MACHINE, (LPDWORD) 0);
  return lpret;

}

LPBYTE 
w32_get_env_resource (char *name, LPDWORD lpdwtype)
{
  LPBYTE lpret = NULL;
  TCHAR tmpstr[MAX_PATH];

  sprintf(tmpstr, meadow_version_env_root, meadow_version_string);

  if (!name) return NULL;

  lpret = w32_get_resource_with_class(name, tmpstr,
				      HKEY_CURRENT_USER, lpdwtype);
  if (lpret) return lpret;
  lpret = w32_get_resource_with_class(name, tmpstr,
				      HKEY_LOCAL_MACHINE, lpdwtype);
  if (lpret) return lpret;


  lpret = w32_get_resource_with_class(name, meadow_common_env_root,
				      HKEY_CURRENT_USER, lpdwtype);
  if (lpret) return lpret;
  lpret = w32_get_resource_with_class(name, meadow_common_env_root,
				      HKEY_LOCAL_MACHINE, lpdwtype);

  return lpret;
}

char *
x_get_string_resource (int rdb, char *name, char *class)
{
  char *lpret;
  TCHAR tmpstr[MAX_PATH];

  sprintf(tmpstr, meadow_version_root, meadow_version_string);

  lpret = (char*) w32_get_string_resource(name, tmpstr);
  if (lpret) return lpret;
  lpret = (char*) w32_get_string_resource(name, meadow_common_root);
  if (lpret) return lpret;

  lpret = (char*) w32_get_string_resource(class, tmpstr);
  if (lpret) return lpret;
  lpret = (char*) w32_get_string_resource(class, meadow_common_root);

  return lpret;

}
