/**************************************
  Meadow Font Manager
       Written by himi
**************************************/
#ifndef __MW32_FONT__
#define __MW32_FONT__
#include <windows.h>
#include "ccl.h"
#include "charset.h"
#include "fontset.h"
#include "mw32bdf.h"

#ifndef SHIFTJIS_CHARSET
#define SHIFTJIS_CHARSET 128
#endif

#define FONT_PROPERTY_NUM 32
#define FONT_PROPERTY_MASK 0x1f
#define LOGFONT_FACENAME_MAX 32

#define NORMAL_FONT_PROPERTY 0
#define BOLD_FONT_PROPERTY 1
#define ITALIC_FONT_PROPERTY 2
#define UNDERLINE_FONT_PROPERTY 4
#define PRINTABLE_FONT_PROPERTY 16

/* encoding number */

#define ENCODING_DIMENSION 0
#define ENCODING_BYTE1MSB1 1
#define ENCODING_BYTE2MSB1 2
#define ENCODING_BYTE2LSB1 3
#define ENCODING_SHIFTJIS  4
#define ENCODING_UNICODE   16

typedef struct ccl_id_type
{
  char *data; /* NOT ASCIZ */
  int size;
} ccl_id_type;

#define MWF_GET_LOGFONT(font, property) ((font)->logfont_properties[(property)])
#define MWF_GET_FONT(font, property) ((font)->font_properties[(property)])
#define MWF_GET_CCL_METHOD_ID(font, property) ((font)->ccl_method[(property)])
#define MWF_NUM (font_num)

#define ENCODING_METHOD_P(obj)                                  \
            (!NILP(Fget((obj), Qccl_program)))

typedef struct fs_fonts
{
  unsigned char *name;
  int vmetric;
  int hmetric;
  int font_base;
  int overhang;
  int encoding_type;
  int relative_compose;
  int default_ascent;
  struct ccl_id_type ccl_method;
  /* to modify font_info, Add this. But I can't free this font_info.... */
  struct font_info *fontip;

  /* LOGFONT... is not always Windows LOGFONT.
     This may point to string that shows bdffont.
     In this situation, font_properties[] must be set to
     INVALID_HANDLE_VALUE(-1).  */

  LOGFONT *logfont_properties[FONT_PROPERTY_NUM];
  HFONT   font_properties[FONT_PROPERTY_NUM];
} fs_fonts;

typedef struct logfont_candidates
{
  int type;
  int width;
  int height;
  int base;
  int overhang;
  int charset;
  Lisp_Object family;
  LOGFONT lf;
} logfont_candidates;

extern HFONT get_hfont(fs_fonts *sf, int property);
extern LPLOGFONT get_logfont(fs_fonts *sf, int property);
extern void w32_set_ime_font(HWND hwnd, LPLOGFONT psetlf);
extern void w32_change_fontset(struct frame *f, unsigned char *name);
extern struct font_info *w32_load_font (struct frame *f,
					unsigned char *name,
					int size);
extern fs_fonts *mw32_get_font(const unsigned char *name);

extern struct font_info *font_info_table;
#define W32_FONT_INFO_TABLE font_info_table
#define W32_FONT_INFO_NUM font_info_num

extern Lisp_Object Qccl_program;

#endif  /* __MW32_FONT__ */
