/* $Id: readline.c,v 1.6 1994/10/06 18:19:21 davidsen Exp $ */
#include "../inet.h"
int readline(int fd, char *ptr, int maxlen)
{
    int n;
    int rc;
    char c;
    /* This stuff allows faster reading of a single socket */
#ifdef  ONE_AT_A_TIME
    static int sock_in_use = 0;
    static char sock_buf[MAXLINE+1];
    static char *next_ch;
#endif

#ifdef ONE_AT_A_TIME
    /* test for a new socket being used */
    if (fd != sock_in_use) {
        sock_in_use = fd;
        *sock_buf = 0;
        next_ch = sock_buf;
    }

    /* fill the user buffer */
    n = 0;
    do {
        /* load the buffer if empty */
        if (*next_ch == 0) {
            rc = read(fd, sock_buf, MAXLINE);
            if (rc < 1) return -1;
            sock_buf[rc] = 0;
            next_ch = sock_buf;
        }

        /* copy data from the buffer */
        *ptr++ = c = *next_ch++;
    } while (c != '\n' && ++n < maxlen);
#else    
    for (n = 1; n < maxlen; n++)
    {
        switch (rc = read(fd,&c,1)) {
        case 1:                 /* got a char, save it, break if EOL */
            *ptr++ = c;
            if (c == '\n') break;
            continue;
        case 0:                 /* nothing read, but no error */
            if (n == 1) return(0);
            else break;
            /* not reached */
        default:                /* anything else is a problem */
            return(-1);
            /* not reached */
        }
        /* always break unless an explicit continue */
        break;
    }
#endif
    *ptr = 0;
    return(n);
}
