/*
CLASS:transport_write_state:ssh_write_state
*/
#ifndef GABA_DEFINE
struct transport_write_state
{
  struct ssh_write_state super;
  uint32_t threshold;
  uint32_t ignore;
  struct mac_instance *mac;
  struct crypto_instance *crypto;
  struct compress_instance *deflate;
  uint32_t seqno;
};
extern struct lsh_class transport_write_state_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void
do_transport_write_state_mark(struct lsh_object *o,
  void (*mark)(struct lsh_object *o))
{
  struct transport_write_state *i = (struct transport_write_state *) o;
  mark((struct lsh_object *) i->mac);
  mark((struct lsh_object *) i->crypto);
  mark((struct lsh_object *) i->deflate);
}
struct lsh_class transport_write_state_class =
{
  STATIC_HEADER,
  &(ssh_write_state_class),
  "transport_write_state",
  sizeof(struct transport_write_state),
  do_transport_write_state_mark,
  NULL,
};
#endif /* !GABA_DECLARE */

/*
CLASS:transport_context:
*/
#ifndef GABA_DEFINE
struct transport_context
{
  struct lsh_object super;
  int is_server;
  struct randomness *random;
  struct alist *algorithms;
  struct make_kexinit *kexinit;
};
extern struct lsh_class transport_context_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void
do_transport_context_mark(struct lsh_object *o,
  void (*mark)(struct lsh_object *o))
{
  struct transport_context *i = (struct transport_context *) o;
  mark((struct lsh_object *) i->random);
  mark((struct lsh_object *) i->algorithms);
  mark((struct lsh_object *) i->kexinit);
}
struct lsh_class transport_context_class =
{
  STATIC_HEADER,
  NULL,
  "transport_context",
  sizeof(struct transport_context),
  do_transport_context_mark,
  NULL,
};
#endif /* !GABA_DECLARE */

/*
CLASS:transport_handler:
*/
#ifndef GABA_DEFINE
struct transport_handler
{
  struct lsh_object super;
  void (*(handler))(struct transport_handler *self,struct transport_connection *connection,uint32_t length,const uint8_t *packet);
};
extern struct lsh_class transport_handler_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
struct lsh_class transport_handler_class =
{
  STATIC_HEADER,
  NULL,
  "transport_handler",
  sizeof(struct transport_handler),
  NULL,
  NULL,
};
#endif /* !GABA_DECLARE */

/*
CLASS:transport_connection:resource
*/
#ifndef GABA_DEFINE
struct transport_connection
{
  struct resource super;
  struct transport_context *ctx;
  struct kexinit_state kex;
  struct lsh_string *session_id;
  struct transport_handler *keyexchange_handler;
  struct mac_instance *new_mac;
  struct crypto_instance *new_crypto;
  struct compress_instance *new_inflate;
  struct resource *expire;
  int ssh_input;
  struct transport_read_state *reader;
  int read_active;
  struct lsh_string *read_packet;
  uint32_t retry_length;
  uint32_t retry_seqno;
  int ssh_output;
  struct transport_write_state *writer;
  int write_active;
  uint32_t write_margin;
  unsigned closing;
  void (*(event_handler))(struct transport_connection *self,enum transport_event event);
  int (*(packet_handler))(struct transport_connection *self,uint32_t seqno,uint32_t length,const uint8_t *packet);
  void (*(line_handler))(struct transport_connection *self,uint32_t length,const uint8_t *line);
};
extern struct lsh_class transport_connection_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void
do_transport_connection_mark(struct lsh_object *o,
  void (*mark)(struct lsh_object *o))
{
  struct transport_connection *i = (struct transport_connection *) o;
  mark((struct lsh_object *) i->ctx);
  kexinit_state_mark(&(i->kex),
    mark);
  mark((struct lsh_object *) i->keyexchange_handler);
  mark((struct lsh_object *) i->new_mac);
  mark((struct lsh_object *) i->new_crypto);
  mark((struct lsh_object *) i->new_inflate);
  mark((struct lsh_object *) i->expire);
  mark((struct lsh_object *) i->reader);
  mark((struct lsh_object *) i->writer);
}
static void
do_transport_connection_free(struct lsh_object *o)
{
  struct transport_connection *i = (struct transport_connection *) o;
  kexinit_state_free(&(i->kex));
  lsh_string_free(i->session_id);
  lsh_string_free(i->read_packet);
}
struct lsh_class transport_connection_class =
{
  STATIC_HEADER,
  &(resource_class),
  "transport_connection",
  sizeof(struct transport_connection),
  do_transport_connection_mark,
  do_transport_connection_free,
};
#endif /* !GABA_DECLARE */

