/*
CLASS:client_dh_exchange:keyexchange_algorithm
*/
#ifndef GABA_DEFINE
struct client_dh_exchange
{
  struct keyexchange_algorithm super;
  const struct dh_params *params;
  struct lookup_verifier *db;
};
extern struct lsh_class client_dh_exchange_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void
do_client_dh_exchange_mark(struct lsh_object *o,
  void (*mark)(struct lsh_object *o))
{
  struct client_dh_exchange *i = (struct client_dh_exchange *) o;
  mark((struct lsh_object *) i->params);
  mark((struct lsh_object *) i->db);
}
struct lsh_class client_dh_exchange_class =
{
  STATIC_HEADER,
  &(keyexchange_algorithm_class),
  "client_dh_exchange",
  sizeof(struct client_dh_exchange),
  do_client_dh_exchange_mark,
  NULL,
};
#endif /* !GABA_DECLARE */

/*
CLASS:client_dh_handler:transport_handler
*/
#ifndef GABA_DEFINE
struct client_dh_handler
{
  struct transport_handler super;
  struct dh_state dh;
  struct lookup_verifier *db;
  int hostkey_algorithm;
};
extern struct lsh_class client_dh_handler_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void
do_client_dh_handler_mark(struct lsh_object *o,
  void (*mark)(struct lsh_object *o))
{
  struct client_dh_handler *i = (struct client_dh_handler *) o;
  dh_state_mark(&(i->dh),
    mark);
  mark((struct lsh_object *) i->db);
}
static void
do_client_dh_handler_free(struct lsh_object *o)
{
  struct client_dh_handler *i = (struct client_dh_handler *) o;
  dh_state_free(&(i->dh));
}
struct lsh_class client_dh_handler_class =
{
  STATIC_HEADER,
  &(transport_handler_class),
  "client_dh_handler",
  sizeof(struct client_dh_handler),
  do_client_dh_handler_mark,
  do_client_dh_handler_free,
};
#endif /* !GABA_DECLARE */

