/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors.ui.dialogs;

import org.apache.uima.resource.metadata.Capability;
import org.apache.uima.taeconfigurator.editors.ui.AbstractSection;
import org.apache.uima.taeconfigurator.editors.ui.CapabilitySection;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.AbstractDialogKeyVerify;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class AddSofaDialog
extends AbstractDialogKeyVerify {
    private StyledText sofaNameUI;
    private CapabilitySection capabilitySection;
    private Capability capability;
    private String existingSofa;
    private boolean existingIsInput;
    private String originalSofa;
    public String sofaName;
    public boolean isInput;
    private Button inputButton;
    private Button outputButton;

    public AddSofaDialog(AbstractSection aSection, Capability c) {
        super(aSection, "Add a Sofa", "Use this panel to specify a Sofa Name.");
        this.capabilitySection = (CapabilitySection)aSection;
        this.capability = c;
    }

    public AddSofaDialog(AbstractSection aSection, Capability c, String aExistingSofa, boolean aIsInput) {
        this(aSection, c);
        this.existingSofa = aExistingSofa;
        this.existingIsInput = aIsInput;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite mainArea = (Composite)super.createDialogArea(parent, this.existingSofa);
        this.createWideLabel(mainArea, "Sofa names must be unique within a Capability Set, and are simple names without name spaces (no dots in the name).\n\n As a special case, they may end in .*\n   - Use this form to designate a class of sofa names, where the class\n     is all names that match the part up to the dot.\n\nType the name in the box below, and specify if it is an input Sofa\n(created outside of this component), or an output Sofa (created by this component).");
        Composite twoCol = new Composite(mainArea, 0);
        twoCol.setLayout((Layout)new GridLayout(2, false));
        twoCol.setLayoutData((Object)new GridData(1808));
        this.sofaNameUI = this.newLabeledSingleLineStyledText(twoCol, "Sofa Name", "");
        this.sofaNameUI.setText("someNewSofaName");
        new Label(twoCol, 0).setText("Input / Output:");
        Composite io = new Composite(twoCol, 0);
        io.setLayout((Layout)new GridLayout(2, true));
        io.setLayoutData((Object)new GridData(768));
        this.inputButton = this.newButton(io, 16, "Input", "Click here to specify this Sofa is an input.");
        this.outputButton = this.newButton(io, 16, "Output", "Click here to specify this Sofa as an output.");
        this.inputButton.setSelection(true);
        this.outputButton.setSelection(false);
        this.newErrorMessage(twoCol, 2);
        if (null != this.existingSofa) {
            this.originalSofa = this.existingSofa;
            this.sofaNameUI.setText(this.originalSofa);
            if (this.existingIsInput) {
                this.inputButton.setSelection(true);
                this.outputButton.setSelection(false);
            } else {
                this.outputButton.setSelection(true);
                this.inputButton.setSelection(false);
            }
        }
        return mainArea;
    }

    @Override
    public void copyValuesFromGUI() {
        this.sofaName = this.sofaNameUI.getText();
        this.isInput = this.inputButton.getSelection();
    }

    @Override
    public boolean isValid() {
        String errMsg;
        if (this.sofaName.length() == 0) {
            return false;
        }
        if (!(this.sofaName.equals(this.originalSofa) && this.isInput == this.existingIsInput || null == (errMsg = this.checkDuplSofaName()))) {
            this.setErrorMessage(errMsg);
            return false;
        }
        if ((this.sofaName.contains(".") || this.sofaName.contains("*")) && (this.sofaName.indexOf(46) != this.sofaName.length() - 2 || this.sofaName.indexOf(42) != this.sofaName.length() - 1)) {
            this.setErrorMessage("Sofa Name cannot have the characters '.' or '*' except as the last 2 characters");
            return false;
        }
        return true;
    }

    @Override
    public void enableOK() {
        this.copyValuesFromGUI();
        this.okButton.setEnabled(this.sofaName.length() > 0);
    }

    private String checkDuplSofaName() {
        Capability[] cSets = this.capabilitySection.getCapabilities();
        for (int i = 0; i < cSets.length; ++i) {
            String[] sofaNames;
            Capability ci = cSets[i];
            if (ci == this.capability) continue;
            String[] stringArray = sofaNames = this.isInput ? ci.getOutputSofas() : ci.getInputSofas();
            if (null == sofaNames) continue;
            for (int j = 0; j < sofaNames.length; ++j) {
                if (!this.sofaName.equals(sofaNames[j])) continue;
                return "This name exists as an " + (this.isInput ? "output" : "input") + " in some capability set.  Please choose another name, or switch the input/output specification to the opposite setting.";
            }
        }
        if (!this.sofaName.equals(this.originalSofa) && (this.checkDuplSofaName1(this.sofaName, this.capability.getInputSofas()) || this.checkDuplSofaName1(this.sofaName, this.capability.getOutputSofas()))) {
            return "This name already in use; please choose a different name.";
        }
        return null;
    }

    private boolean checkDuplSofaName1(String name, String[] names) {
        if (null == names) {
            return false;
        }
        for (int i = 0; i < names.length; ++i) {
            if (!name.equals(names[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean verifyKeyChecks(VerifyEvent event) {
        if (event.keyCode == 13 || event.keyCode == 9) {
            return true;
        }
        return Character.isJavaIdentifierPart(event.character) || event.character == '*' || event.character == '.';
    }
}

