/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.UIMAFramework;
import org.apache.uima.resource.metadata.FsIndexDescription;
import org.apache.uima.resource.metadata.FsIndexKeyDescription;
import org.apache.uima.taeconfigurator.editors.ui.AbstractSection;
import org.apache.uima.taeconfigurator.editors.ui.IndexSection;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.AbstractDialogKeyVerifyJavaNames;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.AddIndexKeyDialog;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.TypesWithNameSpaces;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class AddIndexDialog
extends AbstractDialogKeyVerifyJavaNames {
    private static final String TYPE_PRIORITY = "Type Priority";
    private static final String STANDARD = "Standard";
    private static final String REVERSE = "Reverse";
    private StyledText indexNameUI;
    private Text indexTypeUI;
    private CCombo indexKindUI;
    private Table table;
    private Button addButton;
    private Button editButton;
    private Button removeButton;
    private Button upButton;
    private Button downButton;
    private Composite tableContainer;
    private Label keyTable;
    public String indexName;
    public String indexType;
    public String indexKind;
    public FsIndexKeyDescription[] keys;
    private String originalIndexName;
    private IndexSection indexSection;
    private FsIndexDescription existingNDX;

    public AddIndexDialog(AbstractSection aSection) {
        super(aSection, "Add an index", "Add or Edit an index specification");
        this.indexSection = (IndexSection)aSection;
    }

    public AddIndexDialog(AbstractSection aSection, FsIndexDescription aExistingNDX) {
        this(aSection);
        this.existingNDX = aExistingNDX;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite mainArea = (Composite)super.createDialogArea(parent, this.existingNDX);
        this.createWideLabel(mainArea, "The Index name must be globally unique.");
        Composite twoCol = this.new2ColumnComposite(mainArea);
        this.indexNameUI = this.newLabeledSingleLineStyledText(twoCol, "Index Name:", "The globally unique index name");
        this.indexKindUI = this.newLabeledCCombo(twoCol, "Index Kind:", "Specify the kind of index - sorted, set, or bag");
        this.indexKindUI.add("sorted");
        this.indexKindUI.add("bag");
        this.indexKindUI.add("set");
        new Label(twoCol, 0).setText("CAS Type");
        this.indexTypeUI = this.newTypeInput(this.section, twoCol);
        this.keyTable = new Label(twoCol, 0);
        this.setTextAndTip(this.keyTable, "Index Keys:", "For Set and Sorted index kinds, specify the keys; for Sorted indexes specify also the sort direction.");
        this.tableContainer = this.new2ColumnComposite(twoCol);
        this.table = this.newTable(this.tableContainer, 65540);
        this.table.setHeaderVisible(true);
        new TableColumn(this.table, 0).setText("Feature Name");
        new TableColumn(this.table, 0).setText("Sorting Direction");
        this.table.addListener(8, (Listener)this);
        Composite buttonContainer = this.newButtonContainer(this.tableContainer);
        this.addButton = this.newPushButton(buttonContainer, "Add...", "Click here to add an Index key");
        this.editButton = this.newPushButton(buttonContainer, "Edit...", "Click here to edit the selected item. You can also double-click the item to edit it.");
        this.removeButton = this.newPushButton(buttonContainer, "Remove", "Click here to remove the selected item.  You can also use the delete key.");
        this.upButton = this.newPushButton(buttonContainer, "Up", "Click here to move the selected item up by one.");
        this.downButton = this.newPushButton(buttonContainer, "Down", "Click here to move the selected item down by one.");
        this.newErrorMessage(twoCol, 2);
        if (null == this.existingNDX) {
            this.indexNameUI.setText("some.default.Name");
            this.indexKindUI.setText(this.indexKindUI.getItem(0));
        } else {
            this.originalIndexName = this.existingNDX.getLabel();
            this.indexNameUI.setText(this.originalIndexName);
            this.indexKindUI.setText(AbstractSection.handleDefaultIndexKind(this.existingNDX.getKind()));
            this.indexTypeUI.setText(this.existingNDX.getTypeName());
            this.keys = this.existingNDX.getKeys();
            if (null != this.keys) {
                for (int i = 0; i < this.keys.length; ++i) {
                    this.addKey(this.keys[i]);
                }
            }
        }
        this.section.packTable(this.table);
        this.indexKindUI.addListener(24, (Listener)this);
        boolean showKeys = "sorted".equals(this.indexKindUI.getText()) || "set".equals(this.indexKindUI.getText());
        this.tableContainer.setVisible(showKeys);
        this.keyTable.setVisible(showKeys);
        return mainArea;
    }

    @Override
    public TypesWithNameSpaces getTypeSystemInfoList() {
        TypesWithNameSpaces result = super.getTypeSystemInfoList();
        String[] allTypes = this.getAllTypesAsSortedArray();
        for (int i = 0; i < allTypes.length; ++i) {
            result.add(allTypes[i]);
        }
        return result;
    }

    private void addKey(FsIndexKeyDescription key) {
        if (null == key) {
            return;
        }
        TableItem item = new TableItem(this.table, 0);
        this.updateKey(item, key);
    }

    private void updateKey(TableItem item, FsIndexKeyDescription key) {
        if (null == key) {
            return;
        }
        if (key.isTypePriority()) {
            item.setText(0, "");
            item.setText(1, TYPE_PRIORITY);
        } else {
            item.setText(0, key.getFeatureName());
            item.setText(1, key.getComparator() == 0 ? STANDARD : REVERSE);
        }
    }

    @Override
    public void handleEvent(Event event) {
        if (event.widget == this.indexKindUI) {
            boolean showKeys = "sorted".equals(this.indexKindUI.getText()) || "set".equals(this.indexKindUI.getText());
            this.tableContainer.setVisible(showKeys);
            this.keyTable.setVisible(showKeys);
        } else if (event.widget == this.addButton) {
            AddIndexKeyDialog dialog = new AddIndexKeyDialog(this.section, this.indexTypeUI.getText(), this.indexKindUI.getText(), this.alreadyDefined(this.table.getItems()));
            this.addKey(this.indexSection.addOrEditIndexKey(dialog, null));
            this.section.packTable(this.table);
        } else if (event.widget == this.editButton || event.type == 8) {
            TableItem item = this.table.getItem(this.table.getSelectionIndex());
            AddIndexKeyDialog dialog = new AddIndexKeyDialog(this.section, this.indexTypeUI.getText(), this.indexKindUI.getText(), this.alreadyDefined(this.table.getItems()), this.makeKey(item));
            FsIndexKeyDescription key = this.indexSection.addOrEditIndexKey(dialog, null);
            this.updateKey(item, key);
            this.section.packTable(this.table);
        } else if (event.widget == this.removeButton) {
            TableItem item = this.table.getItem(this.table.getSelectionIndex());
            this.table.setSelection(this.table.getSelectionIndex() - 1);
            item.dispose();
            this.section.packTable(this.table);
        } else if (event.widget == this.upButton) {
            AbstractSection.swapTableItems(this.table.getSelection()[0], this.table.getSelectionIndex() - 1);
        } else if (event.widget == this.downButton) {
            int i = this.table.getSelectionIndex();
            TableItem[] items = this.table.getItems();
            AbstractSection.swapTableItems(items[i + 1], i + 1);
        }
        super.handleEvent(event);
    }

    public List alreadyDefined(TableItem[] items) {
        ArrayList<String> result = new ArrayList<String>();
        if (null == items) {
            return result;
        }
        for (int i = 0; i < items.length; ++i) {
            result.add(items[i].getText(0));
        }
        return result;
    }

    @Override
    public void copyValuesFromGUI() {
        this.indexName = this.indexNameUI.getText();
        this.indexKind = this.indexKindUI.getText();
        this.indexType = this.indexTypeUI.getText();
        TableItem[] items = this.table.getItems();
        if (null != items) {
            this.keys = new FsIndexKeyDescription[items.length];
            for (int i = 0; i < items.length; ++i) {
                this.keys[i] = this.makeKey(items[i]);
            }
        } else {
            this.keys = null;
        }
    }

    private FsIndexKeyDescription makeKey(TableItem item) {
        FsIndexKeyDescription key = UIMAFramework.getResourceSpecifierFactory().createFsIndexKeyDescription();
        boolean typePriority = TYPE_PRIORITY.equals(item.getText(1));
        key.setTypePriority(typePriority);
        if (!typePriority) {
            key.setFeatureName(item.getText(0));
            key.setComparator(STANDARD.equals(item.getText(1)) ? 0 : 1);
        }
        return key;
    }

    @Override
    public boolean isValid() {
        if (this.indexName.length() == 0 || this.indexType.length() == 0) {
            return false;
        }
        if (!this.indexName.equals(this.originalIndexName) && this.indexSection.isDuplicateIndexLabel(this.indexName)) {
            this.errorMessageUI.setText("The name on this index duplicates anexisting name.  Please specify a globally unique name.");
            return false;
        }
        return true;
    }

    @Override
    public void enableOK() {
        this.copyValuesFromGUI();
        this.okButton.setEnabled(this.indexName.length() > 0);
        boolean keysUsed = "sorted".equals(this.indexKind) || "set".equals(this.indexKind);
        this.addButton.setEnabled(this.indexName.length() != 0 && this.indexType.length() != 0 && keysUsed);
        boolean selected = this.table.getSelectionCount() == 1;
        this.removeButton.setEnabled(selected);
        this.editButton.setEnabled(selected);
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
        if (selected) {
            this.upButton.setEnabled(this.table.getSelectionIndex() != 0);
            this.downButton.setEnabled(this.table.getSelectionIndex() != this.table.getItemCount() - 1);
        }
    }
}

