/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector;

import jakarta.resource.ResourceException;
import jakarta.resource.spi.ActivationSpec;
import jakarta.resource.spi.InvalidPropertyException;
import jakarta.resource.spi.ResourceAdapter;
import jakarta.resource.spi.ResourceAdapterAssociation;
import jakarta.resource.spi.endpoint.MessageEndpointFactory;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.util.Set;
import org.apache.geronimo.connector.ResourceAdapterWrapper;

public class ActivationSpecWrapper {
    protected final ActivationSpec activationSpec;
    private final ResourceAdapterWrapper resourceAdapterWrapper;
    private final String containerId;
    private final ValidatorFactory validatorFactory;
    private boolean validated = false;

    public ActivationSpecWrapper() {
        this.activationSpec = null;
        this.containerId = null;
        this.resourceAdapterWrapper = null;
        this.validatorFactory = null;
        this.validated = false;
    }

    public ActivationSpecWrapper(String activationSpecClass, String containerId, ResourceAdapterWrapper resourceAdapterWrapper, ClassLoader cl, ValidatorFactory validatorFactory) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        Class<?> clazz = cl.loadClass(activationSpecClass);
        this.activationSpec = (ActivationSpec)clazz.newInstance();
        this.containerId = containerId;
        this.resourceAdapterWrapper = resourceAdapterWrapper;
        this.validatorFactory = validatorFactory;
        this.validated = false;
    }

    public ActivationSpecWrapper(ActivationSpec activationSpec, ResourceAdapterWrapper resourceAdapterWrapper, ValidatorFactory validatorFactory) {
        this.activationSpec = activationSpec;
        this.resourceAdapterWrapper = resourceAdapterWrapper;
        this.containerId = null;
        this.validatorFactory = validatorFactory;
        this.validated = false;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public ResourceAdapterWrapper getResourceAdapterWrapper() {
        return this.resourceAdapterWrapper;
    }

    public void activate(MessageEndpointFactory messageEndpointFactory) throws ResourceException {
        this.checkConstraints(this.activationSpec);
        ResourceAdapter resourceAdapter = this.activationSpec.getResourceAdapter();
        if (resourceAdapter == null) {
            this.resourceAdapterWrapper.registerResourceAdapterAssociation((ResourceAdapterAssociation)this.activationSpec);
        }
        this.resourceAdapterWrapper.endpointActivation(messageEndpointFactory, this.activationSpec);
        this.resourceAdapterWrapper.doRecovery(this.activationSpec, this.containerId);
    }

    public void deactivate(MessageEndpointFactory messageEndpointFactory) {
        ResourceAdapter resourceAdapter = this.activationSpec.getResourceAdapter();
        if (resourceAdapter == null) {
            throw new IllegalStateException("ActivationSpec was never registered with ResourceAdapter");
        }
        this.resourceAdapterWrapper.deregisterRecovery(this.containerId);
        this.resourceAdapterWrapper.endpointDeactivation(messageEndpointFactory, this.activationSpec);
    }

    private void checkConstraints(ActivationSpec spec) throws InvalidPropertyException {
        if (!this.validated) {
            Validator validator;
            Set generalSet;
            try {
                spec.validate();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            if (this.validatorFactory != null && !(generalSet = (validator = this.validatorFactory.getValidator()).validate((Object)spec, new Class[0])).isEmpty()) {
                throw new ConstraintViolationException("Constraint violation for ActitvationSpec", generalSet);
            }
            this.validated = true;
        }
    }
}

