/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.outbound;

import jakarta.resource.ResourceException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAResource;
import org.apache.geronimo.connector.outbound.ConnectionInfo;
import org.apache.geronimo.connector.outbound.ConnectionInterceptor;
import org.apache.geronimo.connector.outbound.ConnectionReturnAction;
import org.apache.geronimo.connector.outbound.ManagedConnectionInfo;
import org.apache.geronimo.connector.outbound.TxUtil;

public class TransactionEnlistingInterceptor
implements ConnectionInterceptor {
    protected static Logger log = Logger.getLogger(TransactionEnlistingInterceptor.class.getName());
    private final ConnectionInterceptor next;
    private final TransactionManager transactionManager;

    public TransactionEnlistingInterceptor(ConnectionInterceptor next, TransactionManager transactionManager) {
        this.next = next;
        this.transactionManager = transactionManager;
    }

    @Override
    public void getConnection(ConnectionInfo connectionInfo) throws ResourceException {
        this.next.getConnection(connectionInfo);
        try {
            ManagedConnectionInfo mci = connectionInfo.getManagedConnectionInfo();
            Transaction transaction = TxUtil.getTransactionIfActive(this.transactionManager);
            if (transaction != null) {
                XAResource xares = mci.getXAResource();
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Enlisting connection " + connectionInfo + " with XAResource " + xares + " in transaction: " + transaction);
                }
                transaction.enlistResource(xares);
            } else if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "not enlisting connection " + connectionInfo + " with XAResource " + mci.getXAResource() + " no transaction");
            }
        }
        catch (SystemException e) {
            this.returnConnection(connectionInfo, ConnectionReturnAction.DESTROY);
            throw new ResourceException("Could not get transaction", (Throwable)e);
        }
        catch (RollbackException e) {
            this.next.returnConnection(connectionInfo, ConnectionReturnAction.RETURN_HANDLE);
            throw new ResourceException("Could not enlist resource in rolled back transaction", (Throwable)e);
        }
        catch (Throwable t) {
            this.returnConnection(connectionInfo, ConnectionReturnAction.DESTROY);
            throw new ResourceException("Unknown throwable when trying to enlist connection in tx", t);
        }
    }

    @Override
    public void returnConnection(ConnectionInfo connectionInfo, ConnectionReturnAction connectionReturnAction) {
        try {
            ManagedConnectionInfo mci = connectionInfo.getManagedConnectionInfo();
            Transaction transaction = TxUtil.getTransactionIfActive(this.transactionManager);
            if (transaction != null) {
                XAResource xares = mci.getXAResource();
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Delisting connection " + connectionInfo + " with XAResource " + xares + " in transaction: " + transaction, new Exception("stack trace"));
                }
                transaction.delistResource(xares, 0x2000000);
            } else if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "not delisting connection " + connectionInfo + " with XAResource " + mci.getXAResource() + " no transaction");
            }
        }
        catch (SystemException e) {
            log.log(Level.INFO, "Could not delist resource: " + connectionInfo + " with XAResource: " + connectionInfo.getManagedConnectionInfo().getXAResource(), e);
            connectionReturnAction = ConnectionReturnAction.DESTROY;
        }
        catch (IllegalStateException e) {
            connectionReturnAction = ConnectionReturnAction.DESTROY;
        }
        this.next.returnConnection(connectionInfo, connectionReturnAction);
    }

    @Override
    public void destroy() {
        this.next.destroy();
    }

    @Override
    public void info(StringBuilder s) {
        s.append(this.getClass().getName()).append("[transactionManager=").append(this.transactionManager).append("]\n");
        this.next.info(s);
    }
}

