/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.rate.limit;

import io.smallrye.faulttolerance.core.rate.limit.TimeWindow;
import io.smallrye.faulttolerance.core.stopwatch.RunningStopwatch;
import io.smallrye.faulttolerance.core.stopwatch.Stopwatch;

final class FixedWindow
implements TimeWindow {
    private final RunningStopwatch stopwatch;
    private final int maxInvocations;
    private final long timeWindowInMillis;
    private final long minSpacingInMillis;
    private long currentPermits;
    private long nextRefresh;
    private long lastInvocation;

    FixedWindow(Stopwatch stopwatch, int maxInvocations, long timeWindowInMillis, long minSpacingInMillis) {
        this.stopwatch = stopwatch.start();
        this.maxInvocations = maxInvocations;
        this.timeWindowInMillis = timeWindowInMillis;
        this.minSpacingInMillis = minSpacingInMillis;
        this.currentPermits = maxInvocations;
        this.nextRefresh = timeWindowInMillis;
        this.lastInvocation = -minSpacingInMillis;
    }

    @Override
    public synchronized long record() {
        long timeFromPrevious;
        long result;
        long now = this.stopwatch.elapsedTimeInMillis();
        if (now >= this.nextRefresh) {
            this.currentPermits = this.maxInvocations;
            this.nextRefresh += this.timeWindowInMillis * (1L + (now - this.nextRefresh) / this.timeWindowInMillis);
        }
        long l = result = this.currentPermits > 0L ? 0L : this.nextRefresh - now;
        if (result == 0L && this.minSpacingInMillis != 0L && (timeFromPrevious = now - this.lastInvocation) < this.minSpacingInMillis) {
            result = this.minSpacingInMillis - timeFromPrevious;
        }
        --this.currentPermits;
        this.lastInvocation = now;
        return result;
    }
}

