/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jsonb.cdi;

import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.BeforeShutdown;
import jakarta.enterprise.inject.spi.Extension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.johnzon.jsonb.JohnzonJsonb;

public class JohnzonCdiExtension
implements Extension {
    private final Collection<JohnzonJsonb> jsonbs = new ArrayList<JohnzonJsonb>();
    private final ReentrantLock lock = new ReentrantLock();
    private volatile boolean canWrite = false;

    public boolean isCanWrite() {
        return this.canWrite;
    }

    public void track(JohnzonJsonb jsonb) {
        if (!this.canWrite) {
            throw new IllegalStateException("CDI context already shutdown");
        }
        this.lock.lock();
        try {
            this.jsonbs.add(jsonb);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void untrack(JohnzonJsonb jsonb) {
        JohnzonCdiExtension johnzonCdiExtension = this;
        synchronized (johnzonCdiExtension) {
            this.lock.lock();
            try {
                if (!this.jsonbs.remove(jsonb)) {
                    return;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        jsonb.close();
    }

    void started(@Observes BeforeBeanDiscovery beforeBeanDiscovery) {
        this.canWrite = true;
    }

    void cleanUp(@Observes BeforeShutdown beforeShutdown) {
        this.canWrite = false;
        new ArrayList<JohnzonJsonb>(this.jsonbs).forEach(this::untrack);
        this.jsonbs.clear();
    }
}

