/*
 * Decompiled with CFR 0.152.
 */
package jakarta.activation;

import jakarta.activation.CommandObject;
import jakarta.activation.DataHandler;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;

public class CommandInfo {
    private final String commandName;
    private final String commandClass;

    public CommandInfo(String commandName, String commandClass) {
        this.commandName = commandName;
        this.commandClass = commandClass;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public String getCommandClass() {
        return this.commandClass;
    }

    public Object getCommandObject(DataHandler dh, ClassLoader loader) throws IOException, ClassNotFoundException {
        Object bean = Beans.instantiate(loader, this.commandClass);
        if (bean instanceof CommandObject) {
            ((CommandObject)bean).setCommandContext(this.commandName, dh);
        } else if (bean instanceof Externalizable && dh != null) {
            ((Externalizable)bean).readExternal(new ObjectInputStream(dh.getInputStream()));
        }
        return bean;
    }

    private static final class Beans {
        private static final Method instantiateMethod;

        private Beans() {
        }

        static Object instantiate(ClassLoader loader, String cn) throws IOException, ClassNotFoundException {
            block11: {
                if (instantiateMethod != null) {
                    try {
                        return instantiateMethod.invoke(null, loader, cn);
                    }
                    catch (InvocationTargetException e) {
                        if (e.getCause() instanceof ClassNotFoundException) {
                            throw (ClassNotFoundException)e.getCause();
                        }
                        break block11;
                    }
                    catch (IllegalAccessException e) {
                        break block11;
                    }
                }
                SecurityManager security = System.getSecurityManager();
                if (security != null) {
                    int i;
                    int b;
                    String cname = cn.replace('/', '.');
                    if (cname.startsWith("[") && (b = cname.lastIndexOf(91) + 2) > 1 && b < cname.length()) {
                        cname = cname.substring(b);
                    }
                    if ((i = cname.lastIndexOf(46)) != -1) {
                        security.checkPackageAccess(cname.substring(0, i));
                    }
                }
                if (loader == null) {
                    loader = (ClassLoader)AccessController.doPrivileged(() -> {
                        ClassLoader cl = null;
                        try {
                            cl = ClassLoader.getSystemClassLoader();
                        }
                        catch (SecurityException securityException) {
                            // empty catch block
                        }
                        return cl;
                    });
                }
                Class<?> beanClass = Class.forName(cn, true, loader);
                try {
                    return beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception ex) {
                    throw new ClassNotFoundException(beanClass + ": " + ex, ex);
                }
            }
            return null;
        }

        static {
            Method m;
            try {
                Class<?> c = Class.forName("java.beans.Beans");
                m = c.getDeclaredMethod("instantiate", ClassLoader.class, String.class);
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                m = null;
            }
            instantiateMethod = m;
        }
    }
}

