/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.gryo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.tinkerpop.gremlin.structure.io.IoRegistry;
import org.apache.tinkerpop.gremlin.structure.io.Mapper;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoIo;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoVersion;
import org.apache.tinkerpop.gremlin.structure.io.gryo.TypeRegistration;
import org.apache.tinkerpop.gremlin.structure.io.gryo.UtilSerializers;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.SerializerShim;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.shaded.ShadedSerializerAdapter;
import org.apache.tinkerpop.shaded.kryo.ClassResolver;
import org.apache.tinkerpop.shaded.kryo.Kryo;
import org.apache.tinkerpop.shaded.kryo.ReferenceResolver;
import org.apache.tinkerpop.shaded.kryo.Serializer;
import org.apache.tinkerpop.shaded.kryo.StreamFactory;
import org.apache.tinkerpop.shaded.kryo.util.DefaultStreamFactory;
import org.apache.tinkerpop.shaded.kryo.util.MapReferenceResolver;
import org.javatuples.Pair;

public final class GryoMapper
implements Mapper<Kryo> {
    public static final byte[] GIO = "gio".getBytes();
    public static final byte[] HEADER = Arrays.copyOf(GIO, 16);
    private final List<TypeRegistration<?>> typeRegistrations;
    private final boolean registrationRequired;
    private final boolean referenceTracking;
    private final Supplier<ClassResolver> classResolver;
    private final GryoVersion version;

    private GryoMapper(Builder builder) {
        this.typeRegistrations = builder.typeRegistrations;
        this.version = builder.version;
        this.validate();
        this.registrationRequired = builder.registrationRequired;
        this.referenceTracking = builder.referenceTracking;
        this.classResolver = null == builder.classResolver ? this.version.getClassResolverMaker() : builder.classResolver;
    }

    @Override
    public Kryo createMapper() {
        Kryo kryo = new Kryo(this.classResolver.get(), (ReferenceResolver)new MapReferenceResolver(), (StreamFactory)new DefaultStreamFactory());
        kryo.addDefaultSerializer(Map.Entry.class, (Serializer)new UtilSerializers.EntrySerializer());
        kryo.setRegistrationRequired(this.registrationRequired);
        kryo.setReferences(this.referenceTracking);
        for (TypeRegistration<?> tr : this.typeRegistrations) {
            tr.registerWith(kryo);
        }
        return kryo;
    }

    public GryoVersion getVersion() {
        return this.version;
    }

    public List<Class> getRegisteredClasses() {
        return this.typeRegistrations.stream().map(TypeRegistration::getTargetClass).collect(Collectors.toList());
    }

    public List<TypeRegistration<?>> getTypeRegistrations() {
        return this.typeRegistrations;
    }

    public static Builder build() {
        return new Builder();
    }

    private void validate() {
        HashSet duplicates = new HashSet();
        HashSet ids = new HashSet();
        this.typeRegistrations.forEach(t -> {
            if (!ids.contains(t.getId())) {
                ids.add(t.getId());
            } else {
                duplicates.add(t.getId());
            }
        });
        if (duplicates.size() > 0) {
            throw new IllegalStateException("There are duplicate kryo identifiers in use: " + duplicates);
        }
    }

    private static class GryoTypeReg<T>
    implements TypeRegistration<T> {
        private final Class<T> clazz;
        private final Serializer<T> shadedSerializer;
        private final SerializerShim<T> serializerShim;
        private final Function<Kryo, Serializer> functionOfShadedKryo;
        private final int id;

        private GryoTypeReg(Class<T> clazz, Serializer<T> shadedSerializer, SerializerShim<T> serializerShim, Function<Kryo, Serializer> functionOfShadedKryo, int id) {
            this.clazz = clazz;
            this.shadedSerializer = shadedSerializer;
            this.serializerShim = serializerShim;
            this.functionOfShadedKryo = functionOfShadedKryo;
            this.id = id;
            int serializerCount = 0;
            if (null != this.shadedSerializer) {
                ++serializerCount;
            }
            if (null != this.serializerShim) {
                ++serializerCount;
            }
            if (null != this.functionOfShadedKryo) {
                ++serializerCount;
            }
            if (1 < serializerCount) {
                String msg = String.format("GryoTypeReg accepts at most one kind of serializer, but multiple serializers were supplied for class %s (id %s).  Shaded serializer: %s.  Shim serializer: %s.  Shaded serializer function: %s.", this.clazz.getCanonicalName(), id, this.shadedSerializer, this.serializerShim, this.functionOfShadedKryo);
                throw new IllegalArgumentException(msg);
            }
        }

        private static <T> GryoTypeReg<T> of(Class<T> clazz, int id) {
            return new GryoTypeReg<T>(clazz, null, null, null, id);
        }

        private static <T> GryoTypeReg<T> of(Class<T> clazz, int id, Serializer<T> shadedSerializer) {
            return new GryoTypeReg<T>(clazz, shadedSerializer, null, null, id);
        }

        private static <T> GryoTypeReg<T> of(Class<T> clazz, int id, SerializerShim<T> serializerShim) {
            return new GryoTypeReg<T>(clazz, null, serializerShim, null, id);
        }

        private static <T> GryoTypeReg<T> of(Class clazz, int id, Function<Kryo, Serializer> fct) {
            return new GryoTypeReg<T>(clazz, null, null, fct, id);
        }

        @Override
        public Serializer<T> getShadedSerializer() {
            return this.shadedSerializer;
        }

        @Override
        public SerializerShim<T> getSerializerShim() {
            return this.serializerShim;
        }

        @Override
        public Function<Kryo, Serializer> getFunctionOfShadedKryo() {
            return this.functionOfShadedKryo;
        }

        @Override
        public Class<T> getTargetClass() {
            return this.clazz;
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public Kryo registerWith(Kryo kryo) {
            if (null != this.functionOfShadedKryo) {
                kryo.register(this.clazz, this.functionOfShadedKryo.apply(kryo), this.id);
            } else if (null != this.shadedSerializer) {
                kryo.register(this.clazz, this.shadedSerializer, this.id);
            } else if (null != this.serializerShim) {
                kryo.register(this.clazz, new ShadedSerializerAdapter<T>(this.serializerShim), this.id);
            } else {
                kryo.register(this.clazz, kryo.getDefaultSerializer(this.clazz), this.id);
            }
            return kryo;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("targetClass", this.clazz).append("id", this.id).append("shadedSerializer", this.shadedSerializer).append("serializerShim", this.serializerShim).append("functionOfShadedKryo", this.functionOfShadedKryo).toString();
        }
    }

    public static class Builder
    implements Mapper.Builder<Builder> {
        private GryoVersion version = GryoVersion.V3_0;
        private List<TypeRegistration<?>> typeRegistrations = this.version.cloneRegistrations();
        private final List<IoRegistry> registries = new ArrayList<IoRegistry>();
        private final AtomicInteger currentSerializationId = new AtomicInteger(65536);
        private boolean registrationRequired = true;
        private boolean referenceTracking = true;
        private Supplier<ClassResolver> classResolver;

        private Builder() {
        }

        @Override
        public Builder addRegistry(IoRegistry registry) {
            if (null == registry) {
                throw new IllegalArgumentException("The registry cannot be null");
            }
            this.registries.add(registry);
            return this;
        }

        public Builder version(GryoVersion version) {
            this.version = version;
            this.typeRegistrations = version.cloneRegistrations();
            return this;
        }

        public Builder classResolver(Supplier<ClassResolver> classResolverSupplier) {
            if (null == classResolverSupplier) {
                throw new IllegalArgumentException("The classResolverSupplier cannot be null");
            }
            this.classResolver = classResolverSupplier;
            return this;
        }

        public Builder addCustom(Class ... custom) {
            if (custom != null && custom.length > 0) {
                for (Class c : custom) {
                    this.addOrOverrideRegistration(c, id -> GryoTypeReg.of(c, id));
                }
            }
            return this;
        }

        public Builder addCustom(Class clazz, Serializer serializer) {
            this.addOrOverrideRegistration(clazz, id -> GryoTypeReg.of(clazz, (int)id, serializer));
            return this;
        }

        public Builder addCustom(Class clazz, SerializerShim serializer) {
            this.addOrOverrideRegistration(clazz, id -> GryoTypeReg.of(clazz, (int)id, serializer));
            return this;
        }

        public Builder addCustom(Class clazz, Function<Kryo, Serializer> functionOfKryo) {
            this.addOrOverrideRegistration(clazz, id -> GryoTypeReg.of(clazz, (int)id, functionOfKryo));
            return this;
        }

        public Builder registrationRequired(boolean registrationRequired) {
            this.registrationRequired = registrationRequired;
            return this;
        }

        public Builder referenceTracking(boolean referenceTracking) {
            this.referenceTracking = referenceTracking;
            return this;
        }

        public GryoMapper create() {
            this.registries.forEach(registry -> {
                List<Pair<Class, Object>> serializers = registry.find(GryoIo.class);
                serializers.forEach(p -> {
                    if (null == p.getValue1()) {
                        this.addCustom((Class)p.getValue0());
                    } else if (p.getValue1() instanceof SerializerShim) {
                        this.addCustom((Class)p.getValue0(), new ShadedSerializerAdapter((SerializerShim)p.getValue1()));
                    } else if (p.getValue1() instanceof Serializer) {
                        this.addCustom((Class)p.getValue0(), (Serializer)p.getValue1());
                    } else if (p.getValue1() instanceof Function) {
                        this.addCustom((Class)p.getValue0(), (Function)p.getValue1());
                    } else {
                        throw new IllegalStateException(String.format("Unexpected value provided by %s for serializable class %s - expected a parameter in [null, %s implementation or Function<%s, %s>], but received %s", registry.getClass().getSimpleName(), ((Class)p.getValue0()).getClass().getCanonicalName(), Serializer.class.getName(), Kryo.class.getSimpleName(), Serializer.class.getSimpleName(), p.getValue1()));
                    }
                });
            });
            return new GryoMapper(this);
        }

        private <T> void addOrOverrideRegistration(Class<?> clazz, Function<Integer, TypeRegistration<T>> newRegistrationBuilder) {
            Iterator<TypeRegistration<?>> iter = this.typeRegistrations.iterator();
            Integer registrationId = null;
            while (iter.hasNext()) {
                TypeRegistration<?> existingRegistration = iter.next();
                if (!existingRegistration.getTargetClass().equals(clazz)) continue;
                registrationId = existingRegistration.getId();
                iter.remove();
                break;
            }
            if (null == registrationId) {
                registrationId = this.currentSerializationId.getAndIncrement();
            }
            this.typeRegistrations.add(newRegistrationBuilder.apply(registrationId));
        }
    }
}

