/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.binary.types;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.MutablePath;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.DataType;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.SimpleTypeSerializer;

public class PathSerializer
extends SimpleTypeSerializer<Path> {
    public PathSerializer() {
        super(DataType.PATH);
    }

    @Override
    protected Path readValue(Buffer buffer, GraphBinaryReader context) throws IOException {
        MutablePath path = (MutablePath)MutablePath.make();
        List labels = (List)context.read(buffer);
        List objects = (List)context.read(buffer);
        if (labels.size() != objects.size()) {
            throw new IllegalStateException("Format for Path object requires that the labels and objects fields be of the same length");
        }
        for (int ix = 0; ix < labels.size(); ++ix) {
            path.extend(objects.get(ix), (Set)labels.get(ix));
        }
        return path;
    }

    @Override
    protected void writeValue(Path value, Buffer buffer, GraphBinaryWriter context) throws IOException {
        context.write(value.labels(), buffer);
        context.write(value.objects(), buffer);
    }
}

