/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.Configuring;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.FlatMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.VertexStepContract;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.Parameters;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public class VertexStep<E extends Element>
extends FlatMapStep<Vertex, E>
implements Configuring,
VertexStepContract<E> {
    protected Parameters parameters = new Parameters();
    private final String[] edgeLabels;
    private Direction direction;
    private final Class<E> returnClass;

    public VertexStep(Traversal.Admin traversal, Class<E> returnClass, Direction direction, String ... edgeLabels) {
        super(traversal);
        this.direction = direction;
        this.edgeLabels = edgeLabels;
        this.returnClass = returnClass;
    }

    @Override
    public Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public void configure(Object ... keyValues) {
        this.parameters.set(null, keyValues);
    }

    @Override
    protected Iterator<E> flatMap(Traverser.Admin<Vertex> traverser) {
        return Vertex.class.isAssignableFrom(this.returnClass) ? ((Vertex)traverser.get()).vertices(this.direction, this.edgeLabels) : ((Vertex)traverser.get()).edges(this.direction, this.edgeLabels);
    }

    @Override
    public Direction getDirection() {
        return this.direction;
    }

    @Override
    public String[] getEdgeLabels() {
        return this.edgeLabels;
    }

    @Override
    public Class<E> getReturnClass() {
        return this.returnClass;
    }

    @Override
    public void reverseDirection() {
        this.direction = this.direction.opposite();
    }

    @Override
    public boolean returnsVertex() {
        return this.returnClass.equals(Vertex.class);
    }

    @Override
    public boolean returnsEdge() {
        return this.returnClass.equals(Edge.class);
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, new Object[]{this.direction, Arrays.asList(this.edgeLabels), this.returnClass.getSimpleName().toLowerCase()});
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(new Object[]{super.hashCode(), this.direction, this.returnClass});
        if (this.edgeLabels != null && this.edgeLabels.length > 0) {
            List sortedEdgeLabels = Arrays.stream(this.edgeLabels).sorted(Comparator.nullsLast(Comparator.naturalOrder())).collect(Collectors.toList());
            for (String edgeLabel : sortedEdgeLabels) {
                result = 31 * result + Objects.hashCode(edgeLabel);
            }
        }
        return result;
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return Collections.singleton(TraverserRequirement.OBJECT);
    }

    @Override
    public void close() throws Exception {
        this.closeIterator();
    }
}

