/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.util;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.tinkerpop.gremlin.process.traversal.util.ImmutableMetrics;
import org.apache.tinkerpop.gremlin.process.traversal.util.Metrics;

public class MutableMetrics
extends ImmutableMetrics
implements Cloneable {
    private long tempTime = -1L;
    private volatile boolean finalized = false;

    protected MutableMetrics() {
    }

    public MutableMetrics(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public MutableMetrics(Metrics other) {
        this.id = other.getId();
        this.name = other.getName();
        this.annotations.putAll(other.getAnnotations());
        this.durationNs = other.getDuration(TimeUnit.NANOSECONDS);
        other.getCounts().forEach((key, count) -> this.counts.put(key, new AtomicLong((long)count)));
        other.getNested().forEach(nested -> this.addNested(new MutableMetrics((Metrics)nested)));
    }

    public synchronized void addNested(MutableMetrics metrics) {
        if (this.finalized) {
            throw new IllegalStateException("Metrics have been finalized and cannot be modified");
        }
        this.nested.put(metrics.getId(), metrics);
    }

    public void start() {
        if (this.finalized) {
            throw new IllegalStateException("Metrics have been finalized and cannot be modified");
        }
        if (-1L != this.tempTime) {
            throw new IllegalStateException("Internal Error: Concurrent Metrics start. Stop timer before starting timer.");
        }
        this.tempTime = System.nanoTime();
    }

    public void stop() {
        if (this.finalized) {
            throw new IllegalStateException("Metrics have been finalized and cannot be modified");
        }
        if (-1L == this.tempTime) {
            throw new IllegalStateException("Internal Error: Metrics has not been started. Start timer before stopping timer");
        }
        this.durationNs += System.nanoTime() - this.tempTime;
        this.tempTime = -1L;
    }

    public synchronized void incrementCount(String key, long incr) {
        if (this.finalized) {
            throw new IllegalStateException("Metrics have been finalized and cannot be modified");
        }
        AtomicLong count = (AtomicLong)this.counts.get(key);
        if (count == null) {
            count = new AtomicLong();
            this.counts.put(key, count);
        }
        count.addAndGet(incr);
    }

    public void setDuration(long dur, TimeUnit unit) {
        if (this.finalized) {
            throw new IllegalStateException("Metrics have been finalized and cannot be modified");
        }
        this.durationNs = TimeUnit.NANOSECONDS.convert(dur, unit);
    }

    public void setCount(String key, long val) {
        if (this.finalized) {
            throw new IllegalStateException("Metrics have been finalized and cannot be modified");
        }
        this.counts.put(key, new AtomicLong(val));
    }

    public synchronized void aggregate(MutableMetrics other) {
        if (this.finalized) {
            throw new IllegalStateException("Metrics have been finalized and cannot be modified");
        }
        this.durationNs += other.durationNs;
        for (Map.Entry otherCount : other.counts.entrySet()) {
            AtomicLong thisCount = (AtomicLong)this.counts.get(otherCount.getKey());
            if (thisCount == null) {
                thisCount = new AtomicLong(((AtomicLong)otherCount.getValue()).get());
                this.counts.put((String)otherCount.getKey(), thisCount);
                continue;
            }
            thisCount.addAndGet(((AtomicLong)otherCount.getValue()).get());
        }
        for (Map.Entry p : other.annotations.entrySet()) {
            if (this.annotations.containsKey(p.getKey())) {
                Object existingVal = this.annotations.get(p.getKey());
                if (existingVal instanceof String) {
                    List<String> existingValues = Arrays.asList(existingVal.toString().split(","));
                    if (existingValues.contains(p.getValue())) continue;
                    this.annotations.put((String)p.getKey(), existingVal.toString() + ',' + p.getValue());
                    continue;
                }
                Number existingNum = (Number)existingVal;
                Number otherNum = (Number)p.getValue();
                Number newVal = existingNum instanceof Double || existingNum instanceof Float ? (Number)(existingNum.doubleValue() + otherNum.doubleValue()) : (Number)(existingNum.longValue() + otherNum.longValue());
                this.annotations.put((String)p.getKey(), newVal);
                continue;
            }
            this.annotations.put((String)p.getKey(), p.getValue());
        }
        this.annotations.putAll(other.annotations);
        other.nested.values().forEach(nested -> {
            MutableMetrics thisNested = (MutableMetrics)this.nested.get(nested.getId());
            if (thisNested == null) {
                thisNested = new MutableMetrics(nested.getId(), nested.getName());
                this.nested.put(thisNested.getId(), thisNested);
            }
            thisNested.aggregate((MutableMetrics)nested);
        });
    }

    public void setAnnotation(String key, Object value) {
        if (this.finalized) {
            throw new IllegalStateException("Metrics have been finalized and cannot be modified");
        }
        if (!(value instanceof String) && !(value instanceof Number)) {
            throw new IllegalArgumentException("Metrics annotations only support String and Number values.");
        }
        this.annotations.put(key, value);
    }

    @Override
    public MutableMetrics getNested(String metricsId) {
        return (MutableMetrics)this.nested.get(metricsId);
    }

    public boolean isFinalized() {
        return this.finalized;
    }

    public synchronized ImmutableMetrics getImmutableClone() {
        this.finalized = true;
        ImmutableMetrics clone = new ImmutableMetrics();
        this.copyMembers(clone);
        this.nested.values().forEach(nested -> clone.nested.put(nested.id, ((MutableMetrics)nested).getImmutableClone()));
        return clone;
    }

    protected void copyMembers(ImmutableMetrics clone) {
        clone.id = this.id;
        clone.name = this.name;
        clone.durationNs = this.durationNs;
        for (Map.Entry c : this.counts.entrySet()) {
            clone.counts.put((String)c.getKey(), new AtomicLong(((AtomicLong)c.getValue()).get()));
        }
        for (Map.Entry a : this.annotations.entrySet()) {
            clone.annotations.put((String)a.getKey(), a.getValue());
        }
    }

    public MutableMetrics clone() {
        MutableMetrics clone = new MutableMetrics();
        this.copyMembers(clone);
        this.nested.values().forEach(nested -> clone.nested.put(nested.id, ((MutableMetrics)nested).clone()));
        return clone;
    }

    public void finish(long bulk) {
        this.stop();
        this.incrementCount("traverserCount", 1L);
        this.incrementCount("elementCount", bulk);
    }
}

