/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml.print;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.function.Consumer;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.base.JRBasePrintImage;
import net.sf.jasperreports.engine.type.HorizontalImageAlignEnum;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.type.VerticalImageAlignEnum;
import net.sf.jasperreports.engine.xml.print.BoxLoader;
import net.sf.jasperreports.engine.xml.print.HyperlinkLoader;
import net.sf.jasperreports.engine.xml.print.ReportElementLoader;
import net.sf.jasperreports.engine.xml.print.XmlLoader;
import net.sf.jasperreports.renderers.AbstractRenderer;
import net.sf.jasperreports.renderers.ResourceRenderer;
import net.sf.jasperreports.renderers.SimpleDataRenderer;
import net.sf.jasperreports.util.Base64Util;

public class ImageLoader {
    public static final String EXCEPTION_MESSAGE_KEY_DECODING_ERROR = "xml.print.image.decoding.error";
    private static final ImageLoader INSTANCE = new ImageLoader();

    public static ImageLoader instance() {
        return INSTANCE;
    }

    public void loadImage(XmlLoader xmlLoader, JasperPrint jasperPrint, Consumer<? super JRPrintImage> consumer) {
        JRBasePrintImage image = new JRBasePrintImage(jasperPrint.getDefaultStyleProvider());
        xmlLoader.setEnumAttribute("scaleImage", ScaleImageEnum::getByName, image::setScaleImage);
        xmlLoader.setEnumAttribute("rotation", RotationEnum::getByName, image::setRotation);
        xmlLoader.setEnumAttribute("hAlign", HorizontalImageAlignEnum::getByName, image::setHorizontalImageAlign);
        xmlLoader.setEnumAttribute("vAlign", VerticalImageAlignEnum::getByName, image::setVerticalImageAlign);
        xmlLoader.setEnumAttribute("onErrorType", OnErrorTypeEnum::getByName, image::setOnErrorType);
        xmlLoader.setAttribute("hyperlinkType", image::setLinkType);
        xmlLoader.setAttribute("hyperlinkTarget", image::setLinkTarget);
        xmlLoader.setAttribute("anchorName", image::setAnchorName);
        xmlLoader.setAttribute("hyperlinkReference", image::setHyperlinkReference);
        xmlLoader.setAttribute("hyperlinkAnchor", image::setHyperlinkAnchor);
        xmlLoader.setIntAttribute("hyperlinkPage", image::setHyperlinkPage);
        xmlLoader.setAttribute("hyperlinkTooltip", image::setHyperlinkTooltip);
        xmlLoader.setIntAttribute("bookmarkLevel", image::setBookmarkLevel);
        Boolean lazyAttribute = xmlLoader.getBooleanAttribute("isLazy");
        boolean lazy = lazyAttribute != null ? lazyAttribute : false;
        xmlLoader.loadElements(element -> {
            switch (element) {
                case "reportElement": {
                    ReportElementLoader.instance().loadReportElement(xmlLoader, jasperPrint, image);
                    break;
                }
                case "box": {
                    BoxLoader.instance().loadBox(xmlLoader, image.getLineBox());
                    break;
                }
                case "graphicElement": {
                    ReportElementLoader.instance().loadGraphicElement(xmlLoader, image);
                    break;
                }
                case "imageSource": {
                    this.setImageSource(xmlLoader, image, lazy);
                    break;
                }
                case "hyperlinkParameter": {
                    HyperlinkLoader.instance().loadHyperlinkParameter(xmlLoader, image::addHyperlinkParameter);
                    break;
                }
                default: {
                    xmlLoader.unexpectedElement((String)element);
                }
            }
        });
        consumer.accept(image);
    }

    protected void setImageSource(XmlLoader xmlLoader, JRBasePrintImage image, boolean lazy) {
        Boolean embeddedAttribute = xmlLoader.getBooleanAttribute("isEmbedded");
        boolean embedded = embeddedAttribute != null ? embeddedAttribute : false;
        String imageSource = xmlLoader.loadText(true);
        AbstractRenderer renderable = null;
        if (lazy) {
            renderable = ResourceRenderer.getInstance(imageSource, true);
        } else if (embedded) {
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(imageSource.getBytes("UTF-8"));
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                Base64Util.decode(bais, baos);
                renderable = SimpleDataRenderer.getInstance(baos.toByteArray());
            }
            catch (Exception e) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_DECODING_ERROR, null, e);
            }
        } else {
            renderable = ResourceRenderer.getInstance(imageSource, false);
        }
        image.setRenderer(renderable);
    }
}

