/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.dsl.package$expressions$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Predicate;
import org.apache.spark.sql.catalyst.expressions.aggregate.CovPopulation;
import org.apache.spark.sql.catalyst.expressions.aggregate.DeclarativeAggregate;
import org.apache.spark.sql.catalyst.expressions.aggregate.RegrSlope$;
import org.apache.spark.sql.catalyst.expressions.aggregate.VariancePop;
import org.apache.spark.sql.catalyst.trees.BinaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.DoubleType$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(y, x) - Returns the slope of the linear regression line for non-null pairs in a group, where `y` is the dependent variable and `x` is the independent variable.", examples="\n    Examples:\n      > SELECT _FUNC_(y, x) FROM VALUES (1,1), (2,2), (3,3) AS tab(y, x);\n       1.0\n      > SELECT _FUNC_(y, x) FROM VALUES (1, null) AS tab(y, x);\n       NULL\n      > SELECT _FUNC_(y, x) FROM VALUES (null, 1) AS tab(y, x);\n       NULL\n  ", group="agg_funcs", since="3.4.0")
@ScalaSignature(bytes="\u0006\u0001\t%a\u0001B\u0013'\u0001VB\u0001\u0002\u0015\u0001\u0003\u0016\u0004%\t!\u0015\u0005\t%\u0002\u0011\t\u0012)A\u0005\t\"A1\u000b\u0001BK\u0002\u0013\u0005\u0011\u000b\u0003\u0005U\u0001\tE\t\u0015!\u0003E\u0011\u0015)\u0006\u0001\"\u0001W\u0011\u001dQ\u0006A1A\u0005\nmCaa\u0018\u0001!\u0002\u0013a\u0006b\u00021\u0001\u0005\u0004%I!\u0019\u0005\u0007K\u0002\u0001\u000b\u0011\u00022\t\u000b\u0019\u0004A\u0011I4\t\u000b-\u0004A\u0011\t7\t\u000bM\u0004A\u0011\t;\t\u0015\u0005%\u0001\u0001#b\u0001\n\u0003\nY\u0001\u0003\u0006\u0002\u0016\u0001A)\u0019!C!\u0003/A!\"a\u0007\u0001\u0011\u000b\u0007I\u0011IA\f\u0011)\ti\u0002\u0001EC\u0002\u0013\u0005\u0013q\u0003\u0005\n\u0003?\u0001\u0001R1A\u0005BEC!\"!\t\u0001\u0011\u000b\u0007I\u0011IA\u0006\u0011\u001d\t\u0019\u0003\u0001C!\u0003KAq!a\u000e\u0001\t#\nI\u0004C\u0005\u0002D\u0001\t\t\u0011\"\u0001\u0002F!I\u00111\n\u0001\u0012\u0002\u0013\u0005\u0011Q\n\u0005\n\u0003G\u0002\u0011\u0013!C\u0001\u0003\u001bB\u0011\"!\u001a\u0001\u0003\u0003%\t%a\u001a\t\u0013\u0005]\u0004!!A\u0005\u0002\u0005e\u0004\"CAA\u0001\u0005\u0005I\u0011AAB\u0011%\ty\tAA\u0001\n\u0003\n\t\nC\u0005\u0002 \u0002\t\t\u0011\"\u0001\u0002\"\"I\u0011Q\u0015\u0001\u0002\u0002\u0013\u0005\u0013qU\u0004\n\u0003\u00174\u0013\u0011!E\u0001\u0003\u001b4\u0001\"\n\u0014\u0002\u0002#\u0005\u0011q\u001a\u0005\u0007+~!\t!!8\t\u0013\u0005}w$!A\u0005F\u0005\u0005\b\"CAr?\u0005\u0005I\u0011QAs\u0011%\tYoHA\u0001\n\u0003\u000bi\u000fC\u0005\u0002\u0000~\t\t\u0011\"\u0003\u0003\u0002\tI!+Z4s'2|\u0007/\u001a\u0006\u0003O!\n\u0011\"Y4he\u0016<\u0017\r^3\u000b\u0005%R\u0013aC3yaJ,7o]5p]NT!a\u000b\u0017\u0002\u0011\r\fG/\u00197zgRT!!\f\u0018\u0002\u0007M\fHN\u0003\u00020a\u0005)1\u000f]1sW*\u0011\u0011GM\u0001\u0007CB\f7\r[3\u000b\u0003M\n1a\u001c:h\u0007\u0001\u0019b\u0001\u0001\u001c;}\u001dk\u0005CA\u001c9\u001b\u00051\u0013BA\u001d'\u0005Q!Um\u00197be\u0006$\u0018N^3BO\u001e\u0014XmZ1uKB\u00111\bP\u0007\u0002Q%\u0011Q\b\u000b\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u0019qH\u0011#\u000e\u0003\u0001S!!\u0011\u0016\u0002\u000bQ\u0014X-Z:\n\u0005\r\u0003%A\u0003\"j]\u0006\u0014\u0018\u0010T5lKB\u00111(R\u0005\u0003\r\"\u0012!\"\u0012=qe\u0016\u001c8/[8o!\tA5*D\u0001J\u0015\u0005Q\u0015!B:dC2\f\u0017B\u0001'J\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001\u0013(\n\u0005=K%\u0001D*fe&\fG.\u001b>bE2,\u0017\u0001\u00027fMR,\u0012\u0001R\u0001\u0006Y\u00164G\u000fI\u0001\u0006e&<\u0007\u000e^\u0001\u0007e&<\u0007\u000e\u001e\u0011\u0002\rqJg.\u001b;?)\r9\u0006,\u0017\t\u0003o\u0001AQ\u0001U\u0003A\u0002\u0011CQaU\u0003A\u0002\u0011\u000b\u0001bY8wCJ\u0004v\u000e]\u000b\u00029B\u0011q'X\u0005\u0003=\u001a\u0012QbQ8w!>\u0004X\u000f\\1uS>t\u0017!C2pm\u0006\u0014\bk\u001c9!\u0003\u00191\u0018M\u001d)paV\t!\r\u0005\u00028G&\u0011AM\n\u0002\f-\u0006\u0014\u0018.\u00198dKB{\u0007/A\u0004wCJ\u0004v\u000e\u001d\u0011\u0002\u00119,H\u000e\\1cY\u0016,\u0012\u0001\u001b\t\u0003\u0011&L!A[%\u0003\u000f\t{w\u000e\\3b]\u0006AA-\u0019;b)f\u0004X-F\u0001n!\tq\u0017/D\u0001p\u0015\t\u0001H&A\u0003usB,7/\u0003\u0002s_\nAA)\u0019;b)f\u0004X-\u0001\u0006j]B,H\u000fV=qKN,\u0012!\u001e\t\u0005mz\f\u0019A\u0004\u0002xy:\u0011\u0001p_\u0007\u0002s*\u0011!\u0010N\u0001\u0007yI|w\u000e\u001e \n\u0003)K!!`%\u0002\u000fA\f7m[1hK&\u0019q0!\u0001\u0003\u0007M+\u0017O\u0003\u0002~\u0013B\u0019a.!\u0002\n\u0007\u0005\u001dqN\u0001\u0006E_V\u0014G.\u001a+za\u0016\f1#Y4h\u0005V4g-\u001a:BiR\u0014\u0018NY;uKN,\"!!\u0004\u0011\tYt\u0018q\u0002\t\u0004w\u0005E\u0011bAA\nQ\t\u0011\u0012\t\u001e;sS\n,H/\u001a*fM\u0016\u0014XM\\2f\u00035Ig.\u001b;jC24\u0016\r\\;fgV\u0011\u0011\u0011\u0004\t\u0004mz$\u0015!E;qI\u0006$X-\u0012=qe\u0016\u001c8/[8og\u0006\u0001R.\u001a:hK\u0016C\bO]3tg&|gn]\u0001\u0013KZ\fG.^1uK\u0016C\bO]3tg&|g.\u0001\rj]B,H/Q4h\u0005V4g-\u001a:BiR\u0014\u0018NY;uKN\f!\u0002\u001d:fiRLh*Y7f+\t\t9\u0003\u0005\u0003\u0002*\u0005Eb\u0002BA\u0016\u0003[\u0001\"\u0001_%\n\u0007\u0005=\u0012*\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003g\t)D\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003_I\u0015aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\u00159\u00161HA \u0011\u0019\ti\u0004\u0006a\u0001\t\u00069a.Z<MK\u001a$\bBBA!)\u0001\u0007A)\u0001\u0005oK^\u0014\u0016n\u001a5u\u0003\u0011\u0019w\u000e]=\u0015\u000b]\u000b9%!\u0013\t\u000fA+\u0002\u0013!a\u0001\t\"91+\u0006I\u0001\u0002\u0004!\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u001fR3\u0001RA)W\t\t\u0019\u0006\u0005\u0003\u0002V\u0005}SBAA,\u0015\u0011\tI&a\u0017\u0002\u0013Ut7\r[3dW\u0016$'bAA/\u0013\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0005\u0014q\u000b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005%\u0004\u0003BA6\u0003kj!!!\u001c\u000b\t\u0005=\u0014\u0011O\u0001\u0005Y\u0006twM\u0003\u0002\u0002t\u0005!!.\u0019<b\u0013\u0011\t\u0019$!\u001c\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005m\u0004c\u0001%\u0002~%\u0019\u0011qP%\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\u0015\u00151\u0012\t\u0004\u0011\u0006\u001d\u0015bAAE\u0013\n\u0019\u0011I\\=\t\u0013\u00055%$!AA\u0002\u0005m\u0014a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\u0014B1\u0011QSAN\u0003\u000bk!!a&\u000b\u0007\u0005e\u0015*\u0001\u0006d_2dWm\u0019;j_:LA!!(\u0002\u0018\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\rA\u00171\u0015\u0005\n\u0003\u001bc\u0012\u0011!a\u0001\u0003\u000b\u000ba!Z9vC2\u001cHc\u00015\u0002*\"I\u0011QR\u000f\u0002\u0002\u0003\u0007\u0011Q\u0011\u0015\u0014\u0001\u00055\u00161WA[\u0003s\u000bY,a0\u0002B\u0006\u0015\u0017q\u0019\t\u0004w\u0005=\u0016bAAYQ\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA\\\u0003\u00055sLR+O\u0007~C\u0013\u0010\f\u0011yS\u0001j\u0003EU3ukJt7\u000f\t;iK\u0002\u001aHn\u001c9fA=4\u0007\u0005\u001e5fA1Lg.Z1sAI,wM]3tg&|g\u000e\t7j]\u0016\u0004cm\u001c:!]>tWF\\;mY\u0002\u0002\u0018-\u001b:tA%t\u0007%\u0019\u0011he>,\b\u000f\f\u0011xQ\u0016\u0014X\r\t1zA\u0002J7\u000f\t;iK\u0002\"W\r]3oI\u0016tG\u000f\t<be&\f'\r\\3!C:$\u0007\u0005\u0019=aA%\u001c\b\u0005\u001e5fA%tG-\u001a9f]\u0012,g\u000e\u001e\u0011wCJL\u0017M\u00197f]\u0005AQ\r_1na2,7/\t\u0002\u0002>\u0006\tiP\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015zY\u0001B\u0018\u0006\t$S\u001f6\u0003c+\u0011'V\u000bN\u0003\u0003&\r\u00172S1\u0002\u0003F\r\u00173S1\u0002\u0003f\r\u00174S\u0001\n5\u000b\t;bE\"JH\u0006\t=*w)\u0001\u0003\u0005\t\u0011!A\u0001\nd\u0006\r\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)s2\u0002\u00030\u000b\u0011G%>k\u0005EV!M+\u0016\u001b\u0006\u0005K\u0019-A9,H\u000e\\\u0015!\u0003N\u0003C/\u00192)s2\u0002\u00030K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!\u001dVcEJ\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015zY\u0001B\u0018\u0006\t$S\u001f6\u0003c+\u0011'V\u000bN\u0003\u0003F\\;mY2\u0002\u0013'\u000b\u0011B'\u0002\"\u0018M\u0019\u0015zY\u0001B\u0018f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011O+2c%\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005\r\u0017!C1hO~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\t\tI-A\u00034]Qr\u0003'A\u0005SK\u001e\u00148\u000b\\8qKB\u0011qgH\n\u0005?\u0005EW\nE\u0004\u0002T\u0006eG\tR,\u000e\u0005\u0005U'bAAl\u0013\u00069!/\u001e8uS6,\u0017\u0002BAn\u0003+\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83)\t\ti-\u0001\u0005u_N#(/\u001b8h)\t\tI'A\u0003baBd\u0017\u0010F\u0003X\u0003O\fI\u000fC\u0003QE\u0001\u0007A\tC\u0003TE\u0001\u0007A)A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005=\u00181 \t\u0006\u0011\u0006E\u0018Q_\u0005\u0004\u0003gL%AB(qi&|g\u000eE\u0003I\u0003o$E)C\u0002\u0002z&\u0013a\u0001V;qY\u0016\u0014\u0004\u0002CA\u007fG\u0005\u0005\t\u0019A,\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GC\u0001B\u0002!\u0011\tYG!\u0002\n\t\t\u001d\u0011Q\u000e\u0002\u0007\u001f\nTWm\u0019;")
public class RegrSlope
extends DeclarativeAggregate
implements ImplicitCastInputTypes,
BinaryLike<Expression> {
    private Seq<AttributeReference> aggBufferAttributes;
    private Seq<Expression> initialValues;
    private Seq<Expression> updateExpressions;
    private Seq<Expression> mergeExpressions;
    private Expression evaluateExpression;
    private Seq<AttributeReference> inputAggBufferAttributes;
    private final Expression left;
    private final Expression right;
    private final CovPopulation covarPop;
    private final VariancePop varPop;
    private transient Seq<Expression> children;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple2<Expression, Expression>> unapply(RegrSlope regrSlope) {
        return RegrSlope$.MODULE$.unapply(regrSlope);
    }

    public static Function1<Tuple2<Expression, Expression>, RegrSlope> tupled() {
        return RegrSlope$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, RegrSlope>> curried() {
        return RegrSlope$.MODULE$.curried();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return BinaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return BinaryLike.withNewChildrenInternal$(this, newChildren);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private Seq<Expression> children$lzycompute() {
        RegrSlope regrSlope = this;
        synchronized (regrSlope) {
            if (!this.bitmap$trans$0) {
                this.children = BinaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    private CovPopulation covarPop() {
        return this.covarPop;
    }

    private VariancePop varPop() {
        return this.varPop;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public DataType dataType() {
        return DoubleType$.MODULE$;
    }

    public Seq<DoubleType> inputTypes() {
        return (Seq)new .colon.colon((Object)DoubleType$.MODULE$, (List)new .colon.colon((Object)DoubleType$.MODULE$, (List)Nil$.MODULE$));
    }

    private Seq<AttributeReference> aggBufferAttributes$lzycompute() {
        RegrSlope regrSlope = this;
        synchronized (regrSlope) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.aggBufferAttributes = (Seq)this.covarPop().aggBufferAttributes().$plus$plus(this.varPop().aggBufferAttributes(), Seq$.MODULE$.canBuildFrom());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.aggBufferAttributes;
    }

    @Override
    public Seq<AttributeReference> aggBufferAttributes() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.aggBufferAttributes$lzycompute();
        }
        return this.aggBufferAttributes;
    }

    private Seq<Expression> initialValues$lzycompute() {
        RegrSlope regrSlope = this;
        synchronized (regrSlope) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.initialValues = (Seq)this.covarPop().initialValues().$plus$plus(this.varPop().initialValues(), Seq$.MODULE$.canBuildFrom());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.initialValues;
    }

    @Override
    public Seq<Expression> initialValues() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.initialValues$lzycompute();
        }
        return this.initialValues;
    }

    private Seq<Expression> updateExpressions$lzycompute() {
        RegrSlope regrSlope = this;
        synchronized (regrSlope) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                Predicate isNull = package$expressions$.MODULE$.DslExpression((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.left()).isNull())).$bar$bar((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.right()).isNull()));
                this.updateExpressions = (Seq)this.covarPop().updateExpressions().$plus$plus((GenTraversableOnce)((TraversableLike)this.varPop().updateExpressions().zip(this.varPop().aggBufferAttributes(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        Expression newValue = (Expression)tuple2._1();
                        AttributeReference oldValue = (AttributeReference)tuple2._2();
                        return new If((Expression)((Object)isNull), oldValue, newValue);
                    }
                    throw new MatchError((Object)tuple2);
                }, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.updateExpressions;
    }

    @Override
    public Seq<Expression> updateExpressions() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.updateExpressions$lzycompute();
        }
        return this.updateExpressions;
    }

    private Seq<Expression> mergeExpressions$lzycompute() {
        RegrSlope regrSlope = this;
        synchronized (regrSlope) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.mergeExpressions = (Seq)this.covarPop().mergeExpressions().$plus$plus(this.varPop().mergeExpressions(), Seq$.MODULE$.canBuildFrom());
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.mergeExpressions;
    }

    @Override
    public Seq<Expression> mergeExpressions() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.mergeExpressions$lzycompute();
        }
        return this.mergeExpressions;
    }

    private Expression evaluateExpression$lzycompute() {
        RegrSlope regrSlope = this;
        synchronized (regrSlope) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.evaluateExpression = new If((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.varPop().m2()).$eq$eq$eq(package$expressions$.MODULE$.doubleToLiteral(0.0))), Literal$.MODULE$.create(null, (DataType)DoubleType$.MODULE$), package$expressions$.MODULE$.DslExpression(this.covarPop().ck()).$div(this.varPop().m2()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.evaluateExpression;
    }

    @Override
    public Expression evaluateExpression() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.evaluateExpression$lzycompute();
        }
        return this.evaluateExpression;
    }

    private Seq<AttributeReference> inputAggBufferAttributes$lzycompute() {
        RegrSlope regrSlope = this;
        synchronized (regrSlope) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.inputAggBufferAttributes = (Seq)this.covarPop().inputAggBufferAttributes().$plus$plus(this.varPop().inputAggBufferAttributes(), Seq$.MODULE$.canBuildFrom());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.inputAggBufferAttributes;
    }

    @Override
    public Seq<AttributeReference> inputAggBufferAttributes() {
        if ((byte)(this.bitmap$0 & 0x20) == 0) {
            return this.inputAggBufferAttributes$lzycompute();
        }
        return this.inputAggBufferAttributes;
    }

    @Override
    public String prettyName() {
        return "regr_slope";
    }

    @Override
    public RegrSlope withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public RegrSlope copy(Expression left, Expression right) {
        return new RegrSlope(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "RegrSlope";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RegrSlope;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RegrSlope)) return false;
        boolean bl = true;
        if (!bl) return false;
        RegrSlope regrSlope = (RegrSlope)x$1;
        Expression expression = this.left();
        Expression expression2 = regrSlope.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = regrSlope.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!regrSlope.canEqual(this)) return false;
        return true;
    }

    public RegrSlope(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
        BinaryLike.$init$(this);
        this.covarPop = new CovPopulation(right, left);
        this.varPop = new VariancePop(right);
    }
}

