/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.time.ZoneId;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.hadoop.ParquetOutputCommitter;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import org.apache.parquet.hadoop.codec.CodecConfig;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.hadoop.util.ContextUtil;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.apache.spark.SparkException;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.JoinedRow;
import org.apache.spark.sql.catalyst.util.RebaseDateTime;
import org.apache.spark.sql.connector.expressions.aggregate.AggregateFunc;
import org.apache.spark.sql.connector.expressions.aggregate.Aggregation;
import org.apache.spark.sql.connector.expressions.aggregate.Count;
import org.apache.spark.sql.connector.expressions.aggregate.CountStar;
import org.apache.spark.sql.connector.expressions.aggregate.Max;
import org.apache.spark.sql.connector.expressions.aggregate.Min;
import org.apache.spark.sql.execution.datasources.AggregatePushDownUtils$;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.parquet.NoopUpdater$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOptions;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOutputWriter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetRowConverter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetUtils;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport$;
import org.apache.spark.sql.execution.datasources.v2.V2ColumnUtils$;
import org.apache.spark.sql.internal.LegacyBehaviorPolicy$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.UserDefinedType;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;

public final class ParquetUtils$
implements Logging {
    public static ParquetUtils$ MODULE$;
    private final String FIELD_ID_METADATA_KEY;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new ParquetUtils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> parameters, Seq<FileStatus> files) {
        Seq seq;
        ParquetOptions parquetOptions = new ParquetOptions(parameters, sparkSession.sessionState().conf());
        boolean shouldMergeSchemas = parquetOptions.mergeSchema();
        boolean mergeRespectSummaries = sparkSession.sessionState().conf().isParquetSchemaRespectSummaries();
        ParquetUtils.FileTypes filesByType = this.splitFiles(files);
        if (shouldMergeSchemas) {
            Seq<FileStatus> needMerged = mergeRespectSummaries ? (Seq<FileStatus>)Nil$.MODULE$ : filesByType.data();
            seq = (Seq)((TraversableLike)needMerged.$plus$plus(filesByType.metadata(), Seq$.MODULE$.canBuildFrom())).$plus$plus(filesByType.commonMetadata(), Seq$.MODULE$.canBuildFrom());
        } else {
            seq = Option$.MODULE$.option2Iterable(filesByType.commonMetadata().headOption().orElse((Function0 & Serializable & scala.Serializable)() -> filesByType.metadata().headOption()).orElse((Function0 & Serializable & scala.Serializable)() -> filesByType.data().headOption())).toSeq();
        }
        Seq filesToTouch = seq;
        return ParquetFileFormat$.MODULE$.mergeSchemasInParallel(parameters, (Seq<FileStatus>)filesToTouch, sparkSession);
    }

    private ParquetUtils.FileTypes splitFiles(Seq<FileStatus> allFiles) {
        FileStatus[] leaves = (FileStatus[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allFiles.toArray(ClassTag$.MODULE$.apply(FileStatus.class)))).sortBy((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getPath().toString(), (Ordering)Ordering.String$.MODULE$);
        return new ParquetUtils.FileTypes((Seq<FileStatus>)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])leaves)).filterNot((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)ParquetUtils$.MODULE$.isSummaryFile(f.getPath())))), (Seq<FileStatus>)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])leaves)).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ParquetUtils$.$anonfun$splitFiles$3(x$2)))), (Seq<FileStatus>)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])leaves)).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ParquetUtils$.$anonfun$splitFiles$4(x$3)))));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isSummaryFile(Path file) {
        String string = file.getName();
        String string2 = "_common_metadata";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = file.getName();
        String string4 = "_metadata";
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public String FIELD_ID_METADATA_KEY() {
        return this.FIELD_ID_METADATA_KEY;
    }

    public boolean hasFieldIds(StructType schema) {
        if (schema.isEmpty()) {
            return false;
        }
        return this.recursiveCheck$1((DataType)schema);
    }

    public boolean hasFieldId(StructField field) {
        return field.metadata().contains(this.FIELD_ID_METADATA_KEY());
    }

    public int getFieldId(StructField field) {
        int n;
        Predef$.MODULE$.require(this.hasFieldId(field), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("The key `").append(MODULE$.FIELD_ID_METADATA_KEY()).append("` doesn't exist in the metadata of ").append(field).toString());
        try {
            n = Math.toIntExact(field.metadata().getLong(this.FIELD_ID_METADATA_KEY()));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ArithmeticException ? true : throwable2 instanceof ClassCastException) {
                throw new IllegalArgumentException(new StringBuilder(35).append("The key `").append(this.FIELD_ID_METADATA_KEY()).append("` must be a 32-bit integer").toString());
            }
            throw throwable;
        }
        return n;
    }

    public boolean isBatchReadSupportedForSchema(SQLConf sqlConf, StructType schema) {
        return sqlConf.parquetVectorizedReaderEnabled() && schema.forall((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)ParquetUtils$.MODULE$.isBatchReadSupported(sqlConf, f.dataType())));
    }

    public boolean isBatchReadSupported(SQLConf sqlConf, DataType dt) {
        while (true) {
            DataType dataType;
            if ((dataType = dt) instanceof AtomicType) {
                return true;
            }
            if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                if (sqlConf.parquetVectorizedReaderNestedColumnEnabled()) {
                    dt = arrayType.elementType();
                    continue;
                }
                return false;
            }
            if (dataType instanceof MapType) {
                MapType mapType = (MapType)dataType;
                if (sqlConf.parquetVectorizedReaderNestedColumnEnabled() && this.isBatchReadSupported(sqlConf, mapType.keyType())) {
                    dt = mapType.valueType();
                    continue;
                }
                return false;
            }
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                return sqlConf.parquetVectorizedReaderNestedColumnEnabled() && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structType.fields())).forall((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)ParquetUtils$.MODULE$.isBatchReadSupported(sqlConf, f.dataType())));
            }
            if (!(dataType instanceof UserDefinedType)) break;
            UserDefinedType userDefinedType = (UserDefinedType)dataType;
            dt = userDefinedType.sqlType();
        }
        return false;
    }

    public InternalRow createAggInternalRowFromFooter(ParquetMetadata footer, String filePath, StructType dataSchema, StructType partitionSchema, Aggregation aggregation, StructType aggSchema, InternalRow partitionValues, RebaseDateTime.RebaseSpec datetimeRebaseSpec) {
        Tuple2<PrimitiveType[], Object[]> tuple2 = this.getPushedDownAggResult(footer, filePath, dataSchema, partitionSchema, aggregation);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        PrimitiveType[] primitiveTypes = (PrimitiveType[])tuple2._1();
        Object[] values = (Object[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)primitiveTypes, (Object)values);
        PrimitiveType[] primitiveTypes2 = (PrimitiveType[])tuple22._1();
        Object[] values2 = (Object[])tuple22._2();
        Types.MessageTypeBuilder builder = Types.buildMessage();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])primitiveTypes2)).foreach((Function1 & Serializable & scala.Serializable)t -> (Types.GroupBuilder)builder.addField((Type)t));
        MessageType parquetSchema = builder.named("root");
        StructType schemaWithoutGroupBy = AggregatePushDownUtils$.MODULE$.getSchemaWithoutGroupingExpression(aggSchema, aggregation);
        ParquetToSparkSchemaConverter schemaConverter = new ParquetToSparkSchemaConverter(ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$1(), ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$2(), ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$3(), ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$4(), ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$5());
        ParquetRowConverter converter = new ParquetRowConverter(schemaConverter, (GroupType)parquetSchema, schemaWithoutGroupBy, (Option<ZoneId>)None$.MODULE$, datetimeRebaseSpec, new RebaseDateTime.RebaseSpec(LegacyBehaviorPolicy$.MODULE$.CORRECTED(), RebaseDateTime.RebaseSpec$.MODULE$.apply$default$2()), NoopUpdater$.MODULE$);
        PrimitiveType.PrimitiveTypeName[] primitiveTypeNames = (PrimitiveType.PrimitiveTypeName[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])primitiveTypes2)).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getPrimitiveTypeName(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(PrimitiveType.PrimitiveTypeName.class)));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])primitiveTypeNames)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ParquetUtils$.$anonfun$createAggInternalRowFromFooter$3(values2, converter, primitiveTypeNames, x0$1);
            return BoxedUnit.UNIT;
        });
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])aggregation.groupByExpressions())).nonEmpty()) {
            InternalRow reorderedPartitionValues = AggregatePushDownUtils$.MODULE$.reOrderPartitionCol(partitionSchema, aggregation, partitionValues);
            return new JoinedRow(reorderedPartitionValues, converter.currentRecord());
        }
        return converter.currentRecord();
    }

    public Tuple2<PrimitiveType[], Object[]> getPushedDownAggResult(ParquetMetadata footer, String filePath, StructType dataSchema, StructType partitionSchema, Aggregation aggregation) {
        FileMetaData footerFileMetaData = footer.getFileMetaData();
        List fields = footerFileMetaData.getSchema().getFields();
        List blocks = footer.getBlocks();
        ArrayBuilder primitiveTypeBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(PrimitiveType.class));
        ArrayBuilder valuesBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Any());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])aggregation.aggregateExpressions())).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            ObjectRef value = ObjectRef.create((Object)None$.MODULE$);
            LongRef rowCount = LongRef.create((long)0L);
            BooleanRef isCount = BooleanRef.create((boolean)false);
            IntRef index = IntRef.create((int)0);
            ObjectRef schemaName = ObjectRef.create((Object)"");
            blocks.forEach(block -> {
                Count count;
                Min min;
                Max max;
                List blockMetaData = block.getColumns();
                AggregateFunc aggregateFunc = agg;
                if (aggregateFunc instanceof Max && V2ColumnUtils$.MODULE$.extractV2Column((max = (Max)aggregateFunc).column()).isDefined()) {
                    String colName = (String)V2ColumnUtils$.MODULE$.extractV2Column(max.column()).get();
                    index$1.elem = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dataSchema.fieldNames())).toList().indexOf((Object)colName);
                    schemaName$1.elem = new StringBuilder(5).append("max(").append(colName).append(")").toString();
                    Object currentMax = MODULE$.getCurrentBlockMaxOrMin(filePath, blockMetaData, index$1.elem, true);
                    Object object = value$1.elem;
                    None$ none$ = None$.MODULE$;
                    if (!(object == null ? none$ != null : !object.equals(none$)) || ((Comparable)currentMax).compareTo(value$1.elem) > 0) {
                        value$1.elem = currentMax;
                        return;
                    }
                    return;
                }
                if (aggregateFunc instanceof Min && V2ColumnUtils$.MODULE$.extractV2Column((min = (Min)aggregateFunc).column()).isDefined()) {
                    String colName = (String)V2ColumnUtils$.MODULE$.extractV2Column(min.column()).get();
                    index$1.elem = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dataSchema.fieldNames())).toList().indexOf((Object)colName);
                    schemaName$1.elem = new StringBuilder(5).append("min(").append(colName).append(")").toString();
                    Object currentMin = MODULE$.getCurrentBlockMaxOrMin(filePath, blockMetaData, index$1.elem, false);
                    Object object = value$1.elem;
                    None$ none$ = None$.MODULE$;
                    if (!(object == null ? none$ != null : !object.equals(none$)) || ((Comparable)currentMin).compareTo(value$1.elem) < 0) {
                        value$1.elem = currentMin;
                        return;
                    }
                    return;
                }
                if (aggregateFunc instanceof Count && V2ColumnUtils$.MODULE$.extractV2Column((count = (Count)aggregateFunc).column()).isDefined()) {
                    String colName = (String)V2ColumnUtils$.MODULE$.extractV2Column(count.column()).get();
                    schemaName$1.elem = new StringBuilder(7).append("count(").append(colName).append(")").toString();
                    rowCount$1.elem += block.getRowCount();
                    boolean isPartitionCol = false;
                    if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields())).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSet().contains((Object)colName)) {
                        isPartitionCol = true;
                    }
                    isCount$1.elem = true;
                    if (!isPartitionCol) {
                        index$1.elem = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dataSchema.fieldNames())).toList().indexOf((Object)colName);
                        rowCount$1.elem -= MODULE$.getNumNulls(filePath, blockMetaData, index$1.elem);
                        return;
                    }
                    return;
                }
                if (aggregateFunc instanceof CountStar) {
                    schemaName$1.elem = "count(*)";
                    rowCount$1.elem += block.getRowCount();
                    isCount$1.elem = true;
                    return;
                }
            });
            if (isCount.elem) {
                valuesBuilder.$plus$eq((Object)BoxesRunTime.boxToLong((long)rowCount.elem));
                return (ArrayBuilder)primitiveTypeBuilder.$plus$eq(Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).named((String)schemaName.elem));
            }
            valuesBuilder.$plus$eq(value.elem);
            Type field = (Type)fields.get(index.elem);
            return (ArrayBuilder)primitiveTypeBuilder.$plus$eq(((Types.BasePrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)field.asPrimitiveType().getPrimitiveTypeName()).as(field.getLogicalTypeAnnotation())).length(field.asPrimitiveType().getTypeLength()).named((String)schemaName.elem));
        });
        return new Tuple2(primitiveTypeBuilder.result(), valuesBuilder.result());
    }

    private Object getCurrentBlockMaxOrMin(String filePath, List<ColumnChunkMetaData> columnChunkMetaData, int i, boolean isMax) {
        Statistics statistics = columnChunkMetaData.get(i).getStatistics();
        if (!statistics.hasNonNullValue()) {
            throw new UnsupportedOperationException(new StringBuilder(75).append("No min/max found for Parquet file ").append(filePath).append(". ").append("Set SQLConf ").append(SQLConf$.MODULE$.PARQUET_AGGREGATE_PUSHDOWN_ENABLED().key()).append(" to false and execute again").toString());
        }
        if (isMax) {
            return statistics.genericGetMax();
        }
        return statistics.genericGetMin();
    }

    private long getNumNulls(String filePath, List<ColumnChunkMetaData> columnChunkMetaData, int i) {
        Statistics statistics = columnChunkMetaData.get(i).getStatistics();
        if (!statistics.isNumNullsSet()) {
            throw new UnsupportedOperationException(new StringBuilder(82).append("Number of nulls not set for Parquet file").append(" ").append(filePath).append(". Set SQLConf ").append(SQLConf$.MODULE$.PARQUET_AGGREGATE_PUSHDOWN_ENABLED().key()).append(" to false and execute").append(" again").toString());
        }
        return statistics.getNumNulls();
    }

    public OutputWriterFactory prepareWrite(SQLConf sqlConf, Job job, StructType dataSchema, ParquetOptions parquetOptions) {
        Configuration conf = ContextUtil.getConfiguration((JobContext)job);
        Class committerClass = conf.getClass(SQLConf$.MODULE$.PARQUET_OUTPUT_COMMITTER_CLASS().key(), ParquetOutputCommitter.class, OutputCommitter.class);
        if (conf.get(SQLConf$.MODULE$.PARQUET_OUTPUT_COMMITTER_CLASS().key()) == null) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Using default output committer for Parquet: ").append(ParquetOutputCommitter.class.getCanonicalName()).toString());
        } else {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Using user defined output committer for Parquet: ").append(committerClass.getCanonicalName()).toString());
        }
        conf.setClass(SQLConf$.MODULE$.OUTPUT_COMMITTER_CLASS().key(), committerClass, OutputCommitter.class);
        job.setOutputFormatClass(ParquetOutputFormat.class);
        ParquetOutputFormat.setWriteSupportClass((Job)job, ParquetWriteSupport.class);
        ParquetWriteSupport$.MODULE$.setSchema(dataSchema, conf);
        conf.set(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key(), Boolean.toString(sqlConf.writeLegacyParquetFormat()));
        conf.set(SQLConf$.MODULE$.PARQUET_OUTPUT_TIMESTAMP_TYPE().key(), sqlConf.parquetOutputTimestampType().toString());
        conf.set(SQLConf$.MODULE$.PARQUET_FIELD_ID_WRITE_ENABLED().key(), Boolean.toString(sqlConf.parquetFieldIdWriteEnabled()));
        conf.set(SQLConf$.MODULE$.LEGACY_PARQUET_NANOS_AS_LONG().key(), Boolean.toString(sqlConf.legacyParquetNanosAsLong()));
        conf.set("parquet.compression", parquetOptions.compressionCodecClassName());
        if (conf.get("parquet.summary.metadata.level") == null && conf.get("parquet.enable.summary-metadata") == null) {
            conf.setEnum("parquet.summary.metadata.level", (Enum)ParquetOutputFormat.JobSummaryLevel.NONE);
        }
        ParquetOutputFormat.JobSummaryLevel jobSummaryLevel = ParquetOutputFormat.getJobSummaryLevel((Configuration)conf);
        ParquetOutputFormat.JobSummaryLevel jobSummaryLevel2 = ParquetOutputFormat.JobSummaryLevel.NONE;
        if ((jobSummaryLevel == null ? jobSummaryLevel2 != null : !jobSummaryLevel.equals(jobSummaryLevel2)) && !ParquetOutputCommitter.class.isAssignableFrom(committerClass)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(134).append("Committer ").append(committerClass).append(" is not a ParquetOutputCommitter and cannot").append(" create job summaries. ").append("Set Parquet option ").append("parquet.summary.metadata.level").append(" to NONE.").toString());
        }
        return new OutputWriterFactory(){

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new ParquetOutputWriter(path, context);
            }

            public String getFileExtension(TaskAttemptContext context) {
                return new StringBuilder(8).append(CodecConfig.from((TaskAttemptContext)context).getCodec().getExtension()).append(".parquet").toString();
            }
        };
    }

    public static final /* synthetic */ boolean $anonfun$splitFiles$3(FileStatus x$2) {
        String string = x$2.getPath().getName();
        String string2 = "_metadata";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$splitFiles$4(FileStatus x$3) {
        String string = x$3.getPath().getName();
        String string2 = "_common_metadata";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$hasFieldIds$1(ParquetUtils$ $this, StructField field) {
        return MODULE$.hasFieldId(field) || $this.recursiveCheck$1(field.dataType());
    }

    private final boolean recursiveCheck$1(DataType schema) {
        block3: {
            while (true) {
                DataType dataType;
                if ((dataType = schema) instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    return structType.exists((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)ParquetUtils$.$anonfun$hasFieldIds$1(this, field)));
                }
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    schema = arrayType.elementType();
                    continue;
                }
                if (!(dataType instanceof MapType)) break block3;
                MapType mapType = (MapType)dataType;
                if (this.recursiveCheck$1(mapType.keyType())) break;
                schema = mapType.valueType();
            }
            return true;
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$createAggInternalRowFromFooter$3(Object[] values$1, ParquetRowConverter converter$1, PrimitiveType.PrimitiveTypeName[] primitiveTypeNames$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            PrimitiveType.PrimitiveTypeName primitiveTypeName = (PrimitiveType.PrimitiveTypeName)tuple2._1();
            int i = tuple2._2$mcI$sp();
            if (PrimitiveType.PrimitiveTypeName.BOOLEAN.equals(primitiveTypeName)) {
                boolean v = BoxesRunTime.unboxToBoolean((Object)values$1[i]);
                converter$1.getConverter(i).asPrimitiveConverter().addBoolean(v);
                return;
            }
        }
        if (tuple2 != null) {
            PrimitiveType.PrimitiveTypeName primitiveTypeName = (PrimitiveType.PrimitiveTypeName)tuple2._1();
            int i = tuple2._2$mcI$sp();
            if (PrimitiveType.PrimitiveTypeName.INT32.equals(primitiveTypeName)) {
                Integer v = (Integer)values$1[i];
                converter$1.getConverter(i).asPrimitiveConverter().addInt(Predef$.MODULE$.Integer2int(v));
                return;
            }
        }
        if (tuple2 != null) {
            PrimitiveType.PrimitiveTypeName primitiveTypeName = (PrimitiveType.PrimitiveTypeName)tuple2._1();
            int i = tuple2._2$mcI$sp();
            if (PrimitiveType.PrimitiveTypeName.INT64.equals(primitiveTypeName)) {
                long v = BoxesRunTime.unboxToLong((Object)values$1[i]);
                converter$1.getConverter(i).asPrimitiveConverter().addLong(v);
                return;
            }
        }
        if (tuple2 != null) {
            PrimitiveType.PrimitiveTypeName primitiveTypeName = (PrimitiveType.PrimitiveTypeName)tuple2._1();
            int i = tuple2._2$mcI$sp();
            if (PrimitiveType.PrimitiveTypeName.FLOAT.equals(primitiveTypeName)) {
                float v = BoxesRunTime.unboxToFloat((Object)values$1[i]);
                converter$1.getConverter(i).asPrimitiveConverter().addFloat(v);
                return;
            }
        }
        if (tuple2 != null) {
            PrimitiveType.PrimitiveTypeName primitiveTypeName = (PrimitiveType.PrimitiveTypeName)tuple2._1();
            int i = tuple2._2$mcI$sp();
            if (PrimitiveType.PrimitiveTypeName.DOUBLE.equals(primitiveTypeName)) {
                double v = BoxesRunTime.unboxToDouble((Object)values$1[i]);
                converter$1.getConverter(i).asPrimitiveConverter().addDouble(v);
                return;
            }
        }
        if (tuple2 != null) {
            PrimitiveType.PrimitiveTypeName primitiveTypeName = (PrimitiveType.PrimitiveTypeName)tuple2._1();
            int i = tuple2._2$mcI$sp();
            if (PrimitiveType.PrimitiveTypeName.BINARY.equals(primitiveTypeName)) {
                Binary v = (Binary)values$1[i];
                converter$1.getConverter(i).asPrimitiveConverter().addBinary(v);
                return;
            }
        }
        if (tuple2 != null) {
            PrimitiveType.PrimitiveTypeName primitiveTypeName = (PrimitiveType.PrimitiveTypeName)tuple2._1();
            int i = tuple2._2$mcI$sp();
            if (PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY.equals(primitiveTypeName)) {
                Binary v = (Binary)values$1[i];
                converter$1.getConverter(i).asPrimitiveConverter().addBinary(v);
                return;
            }
        }
        if (tuple2 != null) {
            int i = tuple2._2$mcI$sp();
            throw new SparkException(new StringBuilder(30).append("Unexpected parquet type name: ").append(primitiveTypeNames$1[i]).toString());
        }
        throw new MatchError((Object)tuple2);
    }

    private ParquetUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.FIELD_ID_METADATA_KEY = "parquet.field.id";
    }
}

