/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver;

import java.io.Serializable;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hive.service.cli.CLIServiceUtils;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.operation.GetColumnsOperation;
import org.apache.hive.service.cli.session.HiveSession;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.hive.thriftserver.HiveThriftServer2$;
import org.apache.spark.sql.hive.thriftserver.SparkOperation;
import org.apache.spark.sql.internal.NonClosableMutableURLClassLoader;
import org.apache.spark.sql.types.AnsiIntervalType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.VarcharType;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005f!B\n\u0015\u0001Y\u0001\u0003\u0002\u0003\u001c\u0001\u0005\u000b\u0007I\u0011\u0001\u001d\t\u0011u\u0002!\u0011!Q\u0001\neB\u0001B\u0010\u0001\u0003\u0002\u0003\u0006Ia\u0010\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\r\"A1\u000b\u0001B\u0001B\u0003%a\t\u0003\u0005U\u0001\t\u0005\t\u0015!\u0003G\u0011!)\u0006A!A!\u0002\u00131\u0005\"\u0002,\u0001\t\u00039\u0006bB0\u0001\u0005\u0004%\t\u0001\u0019\u0005\u0007Q\u0002\u0001\u000b\u0011B1\t\u000b%\u0004A\u0011\t6\t\u000b=\u0004A\u0011\u00029\t\r}\u0004A\u0011BA\u0001\u0011\u001d\t)\u0001\u0001C\u0005\u0003\u000fAq!a\u0003\u0001\t\u0013\ti\u0001C\u0004\u0002\"\u0001!I!a\t\t\u000f\u0005%\u0003\u0001\"\u0003\u0002L!a\u0011\u0011\u0013\u0001\u0011\u0002\u0003\u0005\t\u0011\"\u0001\u0002\u0014\nA2\u000b]1sW\u001e+GoQ8mk6t7o\u00149fe\u0006$\u0018n\u001c8\u000b\u0005U1\u0012\u0001\u0004;ie&4Go]3sm\u0016\u0014(BA\f\u0019\u0003\u0011A\u0017N^3\u000b\u0005eQ\u0012aA:rY*\u00111\u0004H\u0001\u0006gB\f'o\u001b\u0006\u0003;y\ta!\u00199bG\",'\"A\u0010\u0002\u0007=\u0014xm\u0005\u0003\u0001C1\u0002\u0004C\u0001\u0012+\u001b\u0005\u0019#B\u0001\u0013&\u0003%y\u0007/\u001a:bi&|gN\u0003\u0002'O\u0005\u00191\r\\5\u000b\u0005!J\u0013aB:feZL7-\u001a\u0006\u0003/qI!aK\u0012\u0003'\u001d+GoQ8mk6t7o\u00149fe\u0006$\u0018n\u001c8\u0011\u00055rS\"\u0001\u000b\n\u0005=\"\"AD*qCJ\\w\n]3sCRLwN\u001c\t\u0003cQj\u0011A\r\u0006\u0003gi\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003kI\u0012q\u0001T8hO&tw-\u0001\u0006tc2\u001cuN\u001c;fqR\u001c\u0001!F\u0001:!\tQ4(D\u0001\u0019\u0013\ta\u0004D\u0001\u0006T#2\u001buN\u001c;fqR\f1b]9m\u0007>tG/\u001a=uA\u0005i\u0001/\u0019:f]R\u001cVm]:j_:\u0004\"\u0001Q\"\u000e\u0003\u0005S!AQ\u0013\u0002\u000fM,7o]5p]&\u0011A)\u0011\u0002\f\u0011&4XmU3tg&|g.A\u0006dCR\fGn\\4OC6,\u0007CA$Q\u001d\tAe\n\u0005\u0002J\u00196\t!J\u0003\u0002Lo\u00051AH]8pizR\u0011!T\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001f2\u000ba\u0001\u0015:fI\u00164\u0017BA)S\u0005\u0019\u0019FO]5oO*\u0011q\nT\u0001\u000bg\u000eDW-\\1OC6,\u0017!\u0003;bE2,g*Y7f\u0003)\u0019w\u000e\\;n]:\u000bW.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000faK&l\u0017/^=B\u0011Q\u0006\u0001\u0005\u0006m!\u0001\r!\u000f\u0005\u0006}!\u0001\ra\u0010\u0005\u0006\u000b\"\u0001\rA\u0012\u0005\u0006'\"\u0001\rA\u0012\u0005\u0006)\"\u0001\rA\u0012\u0005\u0006+\"\u0001\rAR\u0001\bG\u0006$\u0018\r\\8h+\u0005\t\u0007C\u00012g\u001b\u0005\u0019'BA0e\u0015\t)\u0007$\u0001\u0005dCR\fG._:u\u0013\t97M\u0001\bTKN\u001c\u0018n\u001c8DCR\fGn\\4\u0002\u0011\r\fG/\u00197pO\u0002\n1B];o\u0013:$XM\u001d8bYR\t1\u000e\u0005\u0002m[6\tA*\u0003\u0002o\u0019\n!QK\\5u\u000359W\r^\"pYVlgnU5{KR\u0011\u0011o\u001e\t\u0004YJ$\u0018BA:M\u0005\u0019y\u0005\u000f^5p]B\u0011A.^\u0005\u0003m2\u00131!\u00138u\u0011\u0015AH\u00021\u0001z\u0003\r!\u0018\u0010\u001d\t\u0003uvl\u0011a\u001f\u0006\u0003yb\tQ\u0001^=qKNL!A`>\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f\u0001cZ3u\t\u0016\u001c\u0017.\\1m\t&<\u0017\u000e^:\u0015\u0007E\f\u0019\u0001C\u0003y\u001b\u0001\u0007\u00110A\bhKRtU/\u001c)sK\u000e\u0014\u0016\rZ5y)\r\t\u0018\u0011\u0002\u0005\u0006q:\u0001\r!_\u0001\u000ei>T\u0015M^1T#2#\u0016\u0010]3\u0015\t\u0005=\u0011q\u0004\t\u0005\u0003#\tY\"\u0004\u0002\u0002\u0014)!\u0011QCA\f\u0003\u0011a\u0017M\\4\u000b\u0005\u0005e\u0011\u0001\u00026bm\u0006LA!!\b\u0002\u0014\t9\u0011J\u001c;fO\u0016\u0014\b\"\u0002=\u0010\u0001\u0004I\u0018aC1eIR{'k\\<TKR$\u0012b[A\u0013\u0003s\ti$a\u0010\t\u000f\u0005\u001d\u0002\u00031\u0001\u0002*\u0005i1m\u001c7v[:\u0004\u0016\r\u001e;fe:\u0004B!a\u000b\u000265\u0011\u0011Q\u0006\u0006\u0005\u0003_\t\t$A\u0003sK\u001e,\u0007P\u0003\u0003\u00024\u0005]\u0011\u0001B;uS2LA!a\u000e\u0002.\t9\u0001+\u0019;uKJt\u0007BBA\u001e!\u0001\u0007a)\u0001\u0004eE:\u000bW.\u001a\u0005\u0006)B\u0001\rA\u0012\u0005\b\u0003\u0003\u0002\u0002\u0019AA\"\u0003\u0019\u00198\r[3nCB\u0019!0!\u0012\n\u0007\u0005\u001d3P\u0001\u0006TiJ,8\r\u001e+za\u0016\f1bZ3u!JLgo\u00142kgR!\u0011QJA?!\u0019\ty%!\u0017\u0002`9!\u0011\u0011KA+\u001d\rI\u00151K\u0005\u0002\u001b&\u0019\u0011q\u000b'\u0002\u000fA\f7m[1hK&!\u00111LA/\u0005\r\u0019V-\u001d\u0006\u0004\u0003/b\u0005\u0003BA1\u0003sj!!a\u0019\u000b\t\u0005\u0015\u0014qM\u0001\u0007a2,x-\u001b8\u000b\t\u0005%\u00141N\u0001\u000eCV$\bn\u001c:ju\u0006$\u0018n\u001c8\u000b\t\u00055\u0014qN\u0001\tg\u0016\u001cWO]5us*!\u0011\u0011OA:\u0003\t\tHNC\u0002\u0018\u0003kR1!a\u001e\u001d\u0003\u0019A\u0017\rZ8pa&!\u00111PA2\u0005MA\u0015N^3Qe&4\u0018\u000e\\3hK>\u0013'.Z2u\u0011\u001d\ty(\u0005a\u0001\u0003\u0003\u000bq\u0001\u001a23)\u0006\u00147\u000f\u0005\u0004H\u0003\u00073\u0015qQ\u0005\u0004\u0003\u000b\u0013&aA'baB1\u0011qJA-\u0003\u0013\u0003B!a#\u0002\u000e6\tA-C\u0002\u0002\u0010\u0012\u0014q\u0002V1cY\u0016LE-\u001a8uS\u001aLWM]\u0001\u0011aJ|G/Z2uK\u0012$#o\\<TKR$B!!&\u0002\u001eB!\u0011qSAM\u001b\u0005)\u0013bAANK\t1!k\\<TKRD\u0001\"a(\u0013\u0003\u0003\u0005\r\u0001W\u0001\u0004q\u0012\n\u0004")
public class SparkGetColumnsOperation
extends GetColumnsOperation
implements SparkOperation {
    private final SQLContext sqlContext;
    private final HiveSession parentSession;
    private final String catalogName;
    private final String schemaName;
    private final String tableName;
    private final String columnName;
    private final SessionCatalog catalog;
    private String statementId;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public /* synthetic */ void org$apache$spark$sql$hive$thriftserver$SparkOperation$$super$run() {
        super.run();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$hive$thriftserver$SparkOperation$$super$close() {
        super.close();
    }

    @Override
    public /* synthetic */ OperationState org$apache$spark$sql$hive$thriftserver$SparkOperation$$super$setState(OperationState newState) {
        return super.setState(newState);
    }

    @Override
    public void cleanup() {
        SparkOperation.cleanup$(this);
    }

    @Override
    public void run() {
        SparkOperation.run$(this);
    }

    @Override
    public void close() {
        SparkOperation.close$(this);
    }

    @Override
    public <T> T withLocalProperties(Function0<T> f) {
        return (T)SparkOperation.withLocalProperties$(this, f);
    }

    @Override
    public String tableTypeString(CatalogTableType tableType) {
        return SparkOperation.tableTypeString$(this, tableType);
    }

    @Override
    public PartialFunction<Throwable, BoxedUnit> onError() {
        return SparkOperation.onError$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public String statementId() {
        return this.statementId;
    }

    @Override
    public void statementId_$eq(String x$1) {
        this.statementId = x$1;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public /* synthetic */ RowSet protected$rowSet(SparkGetColumnsOperation x$1) {
        return x$1.rowSet;
    }

    @Override
    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    public SessionCatalog catalog() {
        return this.catalog;
    }

    @Override
    public void runInternal() {
        Object object;
        String cmdStr = new StringBuilder(45).append("catalog : ").append(this.catalogName).append(", schemaPattern : ").append(this.schemaName).append(", tablePattern : ").append(this.tableName).toString();
        String logMsg = new StringBuilder(33).append("Listing columns '").append(cmdStr).append(", columnName : ").append(this.columnName).append("'").toString();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(6).append(logMsg).append(" with ").append(this.statementId()).toString());
        this.setState(OperationState.RUNNING);
        NonClosableMutableURLClassLoader executionHiveClassLoader = this.sqlContext().sharedState().jarClassLoader();
        Thread.currentThread().setContextClassLoader((ClassLoader)executionHiveClassLoader);
        HiveThriftServer2$.MODULE$.eventManager().onStatementStart(this.statementId(), this.parentSession.getSessionHandle().getSessionId().toString(), logMsg, this.statementId(), this.parentSession.getUsername());
        String schemaPattern = this.convertSchemaPattern(this.schemaName);
        String tablePattern = this.convertIdentifierPattern(this.tableName, true);
        ObjectRef columnPattern = ObjectRef.create(null);
        if (this.columnName != null) {
            columnPattern.elem = Pattern.compile(this.convertIdentifierPattern(this.columnName, false));
        }
        Map db2Tabs = ((TraversableOnce)this.catalog().listDatabases(schemaPattern).map((Function1 & Serializable & scala.Serializable)dbName -> new Tuple2(dbName, (Object)this.catalog().listTables(dbName, tablePattern, false)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        if (this.isAuthV2Enabled()) {
            List privObjs = (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.getPrivObjs((Map<String, Seq<TableIdentifier>>)db2Tabs)).asJava();
            this.authorizeMetaGets(HiveOperationType.GET_COLUMNS, privObjs, cmdStr);
        }
        try {
            db2Tabs.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                SparkGetColumnsOperation.$anonfun$runInternal$3(this, columnPattern, x0$1);
                return BoxedUnit.UNIT;
            });
            String globalTempViewDb = this.catalog().globalTempViewManager().database();
            Pattern databasePattern = Pattern.compile(CLIServiceUtils.patternToRegex(this.schemaName));
            if (databasePattern.matcher(globalTempViewDb).matches()) {
                this.catalog().globalTempViewManager().listViewNames(tablePattern).foreach((Function1 & Serializable & scala.Serializable)globalTempView -> {
                    SparkGetColumnsOperation.$anonfun$runInternal$5(this, columnPattern, globalTempViewDb, globalTempView);
                    return BoxedUnit.UNIT;
                });
            }
            this.catalog().listLocalTempViews(tablePattern).foreach((Function1 & Serializable & scala.Serializable)localTempView -> {
                SparkGetColumnsOperation.$anonfun$runInternal$8(this, columnPattern, localTempView);
                return BoxedUnit.UNIT;
            });
            object = this.setState(OperationState.FINISHED);
        }
        catch (Throwable x$3) {
            PartialFunction<Throwable, BoxedUnit> catchExpr$1 = this.onError();
            if (catchExpr$1.isDefinedAt((Object)x$3)) {
                object = catchExpr$1.apply((Object)x$3);
            }
            throw x$3;
        }
        HiveThriftServer2$.MODULE$.eventManager().onStatementFinish(this.statementId());
    }

    private Option<Object> getColumnSize(DataType typ) {
        DataType dataType = typ;
        if (BooleanType$.MODULE$.equals(dataType) ? true : (dataType instanceof NumericType ? true : (DateType$.MODULE$.equals(dataType) ? true : (TimestampType$.MODULE$.equals(dataType) ? true : (TimestampNTZType$.MODULE$.equals(dataType) ? true : (CalendarIntervalType$.MODULE$.equals(dataType) ? true : (NullType$.MODULE$.equals(dataType) ? true : dataType instanceof AnsiIntervalType))))))) {
            return new Some((Object)BoxesRunTime.boxToInteger((int)dataType.defaultSize()));
        }
        if (dataType instanceof CharType) {
            CharType charType = (CharType)dataType;
            int n = charType.length();
            return new Some((Object)BoxesRunTime.boxToInteger((int)n));
        }
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            Option[] sizeArr = (Option[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).map((Function1 & Serializable & scala.Serializable)f -> this.getColumnSize(f.dataType()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Option.class)));
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sizeArr)).contains((Object)None$.MODULE$)) {
                return None$.MODULE$;
            }
            return new Some(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sizeArr)).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)SparkGetColumnsOperation.$anonfun$getColumnSize$2(x$4)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        }
        return None$.MODULE$;
    }

    private Option<Object> getDecimalDigits(DataType typ) {
        DataType dataType = typ;
        if (BooleanType$.MODULE$.equals(dataType) ? true : dataType instanceof IntegerType) {
            return new Some((Object)BoxesRunTime.boxToInteger((int)0));
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return new Some((Object)BoxesRunTime.boxToInteger((int)7));
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return new Some((Object)BoxesRunTime.boxToInteger((int)15));
        }
        if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            return new Some((Object)BoxesRunTime.boxToInteger((int)decimalType.scale()));
        }
        if (TimestampType$.MODULE$.equals(dataType) ? true : TimestampNTZType$.MODULE$.equals(dataType)) {
            return new Some((Object)BoxesRunTime.boxToInteger((int)6));
        }
        return None$.MODULE$;
    }

    private Option<Object> getNumPrecRadix(DataType typ) {
        DataType dataType = typ;
        if (dataType instanceof NumericType) {
            return new Some((Object)BoxesRunTime.boxToInteger((int)10));
        }
        return None$.MODULE$;
    }

    private Integer toJavaSQLType(DataType typ) {
        DataType dataType = typ;
        if (NullType$.MODULE$.equals(dataType)) {
            return Predef$.MODULE$.int2Integer(0);
        }
        if (BooleanType$.MODULE$.equals(dataType)) {
            return Predef$.MODULE$.int2Integer(16);
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return Predef$.MODULE$.int2Integer(-6);
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            return Predef$.MODULE$.int2Integer(5);
        }
        if (IntegerType$.MODULE$.equals(dataType)) {
            return Predef$.MODULE$.int2Integer(4);
        }
        if (LongType$.MODULE$.equals(dataType)) {
            return Predef$.MODULE$.int2Integer(-5);
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return Predef$.MODULE$.int2Integer(6);
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return Predef$.MODULE$.int2Integer(8);
        }
        if (dataType instanceof DecimalType) {
            return Predef$.MODULE$.int2Integer(3);
        }
        if (StringType$.MODULE$.equals(dataType)) {
            return Predef$.MODULE$.int2Integer(12);
        }
        if (dataType instanceof VarcharType) {
            return Predef$.MODULE$.int2Integer(12);
        }
        if (dataType instanceof CharType) {
            return Predef$.MODULE$.int2Integer(1);
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return Predef$.MODULE$.int2Integer(-2);
        }
        if (DateType$.MODULE$.equals(dataType)) {
            return Predef$.MODULE$.int2Integer(91);
        }
        if (TimestampType$.MODULE$.equals(dataType) ? true : TimestampNTZType$.MODULE$.equals(dataType)) {
            return Predef$.MODULE$.int2Integer(93);
        }
        if (dataType instanceof ArrayType) {
            return Predef$.MODULE$.int2Integer(2003);
        }
        if (dataType instanceof MapType) {
            return Predef$.MODULE$.int2Integer(2000);
        }
        if (dataType instanceof StructType) {
            return Predef$.MODULE$.int2Integer(2002);
        }
        if (dataType instanceof CalendarIntervalType ? true : dataType instanceof AnsiIntervalType) {
            return Predef$.MODULE$.int2Integer(1111);
        }
        throw new IllegalArgumentException(new StringBuilder(24).append("Unrecognized type name: ").append(typ.sql()).toString());
    }

    private void addToRowSet(Pattern columnPattern, String dbName, String tableName, StructType schema) {
        ((IterableLike)schema.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                StructField column = (StructField)tuple2._1();
                int pos = tuple2._2$mcI$sp();
                if (columnPattern != null && !columnPattern.matcher(column.name()).matches()) {
                    return BoxedUnit.UNIT;
                }
                Object[] rowData = new Object[]{null, dbName, tableName, column.name(), this.toJavaSQLType(column.dataType()), column.dataType().sql(), this.getColumnSize(column.dataType()).map((Function1 & Serializable & scala.Serializable)x$5 -> SparkGetColumnsOperation.$anonfun$addToRowSet$2(BoxesRunTime.unboxToInt((Object)x$5))).orNull(Predef$.MODULE$.$conforms()), null, this.getDecimalDigits(column.dataType()).map((Function1 & Serializable & scala.Serializable)x$6 -> SparkGetColumnsOperation.$anonfun$addToRowSet$3(BoxesRunTime.unboxToInt((Object)x$6))).orNull(Predef$.MODULE$.$conforms()), this.getNumPrecRadix(column.dataType()).map((Function1 & Serializable & scala.Serializable)x$7 -> SparkGetColumnsOperation.$anonfun$addToRowSet$4(BoxesRunTime.unboxToInt((Object)x$7))).orNull(Predef$.MODULE$.$conforms()), column.nullable() ? BoxesRunTime.boxToInteger((int)1) : BoxesRunTime.boxToInteger((int)0), column.getComment().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), null, null, null, null, BoxesRunTime.boxToInteger((int)pos), "YES", null, null, null, null, "NO"};
                return this.protected$rowSet(this).addRow(rowData);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private Seq<HivePrivilegeObject> getPrivObjs(Map<String, Seq<TableIdentifier>> db2Tabs) {
        return (Seq)db2Tabs.foldLeft((Object)Nil$.MODULE$, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Seq i = (Seq)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    String dbName = (String)tuple22._1();
                    Seq tables = (Seq)tuple22._2();
                    return (Seq)i.$plus$plus((GenTraversableOnce)tables.map((Function1 & Serializable & scala.Serializable)tableId -> new HivePrivilegeObject(HivePrivilegeObject.HivePrivilegeObjectType.TABLE_OR_VIEW, dbName, tableId.table()), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public static final /* synthetic */ void $anonfun$runInternal$3(SparkGetColumnsOperation $this, ObjectRef columnPattern$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String dbName = (String)tuple2._1();
            Seq tables = (Seq)tuple2._2();
            $this.catalog().getTablesByName(tables).foreach((Function1 & Serializable & scala.Serializable)catalogTable -> {
                $this.addToRowSet((Pattern)columnPattern$1.elem, dbName, catalogTable.identifier().table(), catalogTable.schema());
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$runInternal$5(SparkGetColumnsOperation $this, ObjectRef columnPattern$1, String globalTempViewDb$1, String globalTempView) {
        $this.catalog().getRawGlobalTempView(globalTempView).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.tableMeta().schema()).foreach((Function1 & Serializable & scala.Serializable)schema -> {
            $this.addToRowSet((Pattern)columnPattern$1.elem, globalTempViewDb$1, globalTempView, schema);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$runInternal$8(SparkGetColumnsOperation $this, ObjectRef columnPattern$1, TableIdentifier localTempView) {
        $this.catalog().getRawTempView(localTempView.table()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.tableMeta().schema()).foreach((Function1 & Serializable & scala.Serializable)schema -> {
            $this.addToRowSet((Pattern)columnPattern$1.elem, null, localTempView.table(), schema);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ int $anonfun$getColumnSize$2(Option x$4) {
        return BoxesRunTime.unboxToInt((Object)x$4.get());
    }

    public static final /* synthetic */ Object $anonfun$addToRowSet$2(int x$5) {
        return BoxesRunTime.boxToInteger((int)x$5);
    }

    public static final /* synthetic */ Object $anonfun$addToRowSet$3(int x$6) {
        return BoxesRunTime.boxToInteger((int)x$6);
    }

    public static final /* synthetic */ Object $anonfun$addToRowSet$4(int x$7) {
        return BoxesRunTime.boxToInteger((int)x$7);
    }

    public SparkGetColumnsOperation(SQLContext sqlContext, HiveSession parentSession, String catalogName, String schemaName, String tableName, String columnName) {
        this.sqlContext = sqlContext;
        this.parentSession = parentSession;
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.columnName = columnName;
        super(parentSession, catalogName, schemaName, tableName, columnName);
        Logging.$init$((Logging)this);
        SparkOperation.$init$(this);
        this.catalog = sqlContext.sessionState().catalog();
    }
}

