/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple;

import org.apache.datasketches.QuickSelect;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.theta.HashIterator;
import org.apache.datasketches.tuple.CompactSketch;
import org.apache.datasketches.tuple.QuickSelectSketch;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.SketchIterator;
import org.apache.datasketches.tuple.Summary;
import org.apache.datasketches.tuple.SummarySetOperations;
import org.apache.datasketches.tuple.Util;

public class Union<S extends Summary> {
    private final SummarySetOperations<S> summarySetOps_;
    private QuickSelectSketch<S> qsk_;
    private long unionThetaLong_;
    private boolean empty_;

    public Union(SummarySetOperations<S> summarySetOps) {
        this(4096, summarySetOps);
    }

    public Union(int nomEntries, SummarySetOperations<S> summarySetOps) {
        this.summarySetOps_ = summarySetOps;
        this.qsk_ = new QuickSelectSketch(nomEntries, null);
        this.unionThetaLong_ = this.qsk_.getThetaLong();
        this.empty_ = true;
    }

    public CompactSketch<S> union(Sketch<S> tupleSketchA, Sketch<S> tupleSketchB) {
        this.reset();
        this.union(tupleSketchA);
        this.union(tupleSketchB);
        CompactSketch<S> csk = this.getResult(true);
        return csk;
    }

    public CompactSketch<S> union(Sketch<S> tupleSketch, org.apache.datasketches.theta.Sketch thetaSketch, S summary) {
        this.reset();
        this.union(tupleSketch);
        this.union(thetaSketch, summary);
        CompactSketch<S> csk = this.getResult(true);
        return csk;
    }

    public void union(Sketch<S> tupleSketch) {
        if (tupleSketch == null || tupleSketch.isEmpty()) {
            return;
        }
        this.empty_ = false;
        this.unionThetaLong_ = Math.min(tupleSketch.thetaLong_, this.unionThetaLong_);
        SketchIterator<S> it = tupleSketch.iterator();
        while (it.next()) {
            this.qsk_.merge(it.getHash(), it.getSummary(), this.summarySetOps_);
        }
        this.unionThetaLong_ = Math.min(this.unionThetaLong_, this.qsk_.thetaLong_);
    }

    public void union(org.apache.datasketches.theta.Sketch thetaSketch, S summary) {
        if (summary == null) {
            throw new SketchesArgumentException("Summary cannot be null.");
        }
        if (thetaSketch == null || thetaSketch.isEmpty()) {
            return;
        }
        this.empty_ = false;
        long thetaIn = thetaSketch.getThetaLong();
        this.unionThetaLong_ = Math.min(thetaIn, this.unionThetaLong_);
        HashIterator it = thetaSketch.iterator();
        while (it.next()) {
            this.qsk_.merge(it.get(), summary, this.summarySetOps_);
        }
        this.unionThetaLong_ = Math.min(this.unionThetaLong_, this.qsk_.thetaLong_);
    }

    public CompactSketch<S> getResult() {
        return this.getResult(false);
    }

    public CompactSketch<S> getResult(boolean reset) {
        CompactSketch result;
        if (this.empty_) {
            result = this.qsk_.compact();
        } else if (this.unionThetaLong_ >= this.qsk_.thetaLong_ && this.qsk_.getRetainedEntries() <= this.qsk_.getNominalEntries()) {
            result = this.qsk_.compact();
        } else {
            long tmpThetaLong = Math.min(this.unionThetaLong_, this.qsk_.thetaLong_);
            int numHashesIn = 0;
            SketchIterator<S> it = this.qsk_.iterator();
            while (it.next()) {
                if (it.getHash() >= tmpThetaLong) continue;
                ++numHashesIn;
            }
            if (numHashesIn == 0) {
                result = new CompactSketch(null, null, tmpThetaLong, this.empty_);
            } else {
                long thetaLongOut;
                int numHashesOut;
                if (numHashesIn > this.qsk_.getNominalEntries()) {
                    long[] tmpHashArr = new long[numHashesIn];
                    it = this.qsk_.iterator();
                    int i = 0;
                    while (it.next()) {
                        long hash = it.getHash();
                        if (hash >= tmpThetaLong) continue;
                        tmpHashArr[i++] = hash;
                    }
                    numHashesOut = this.qsk_.getNominalEntries();
                    thetaLongOut = QuickSelect.select(tmpHashArr, 0, numHashesIn - 1, numHashesOut);
                } else {
                    numHashesOut = numHashesIn;
                    thetaLongOut = tmpThetaLong;
                }
                long[] hashArr = new long[numHashesOut];
                Summary[] summaries = Util.newSummaryArray((Summary[])this.qsk_.getSummaryTable(), (int)numHashesOut);
                it = this.qsk_.iterator();
                int i = 0;
                while (it.next()) {
                    long hash = it.getHash();
                    if (hash >= thetaLongOut) continue;
                    hashArr[i] = hash;
                    summaries[i] = it.getSummary().copy();
                    ++i;
                }
                result = new CompactSketch(hashArr, summaries, thetaLongOut, this.empty_);
            }
        }
        if (reset) {
            this.reset();
        }
        return result;
    }

    public void reset() {
        this.qsk_.reset();
        this.unionThetaLong_ = this.qsk_.getThetaLong();
        this.empty_ = true;
    }
}

