/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import javax.jcr.Credentials;
import javax.jcr.GuestCredentials;
import javax.jcr.RepositoryException;
import javax.jcr.SimpleCredentials;
import javax.security.auth.Subject;
import javax.security.auth.login.AccountLockedException;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.oak.api.AuthInfo;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.security.user.CredentialsImpl;
import org.apache.jackrabbit.oak.security.user.PasswordHistoryException;
import org.apache.jackrabbit.oak.security.user.Utils;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.authentication.Authentication;
import org.apache.jackrabbit.oak.spi.security.authentication.ImpersonationCredentials;
import org.apache.jackrabbit.oak.spi.security.authentication.PreAuthenticatedLogin;
import org.apache.jackrabbit.oak.spi.security.user.UserConfiguration;
import org.apache.jackrabbit.oak.spi.security.user.UserConstants;
import org.apache.jackrabbit.oak.spi.security.user.util.PasswordUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UserAuthentication
implements Authentication,
UserConstants {
    private static final Logger log = LoggerFactory.getLogger(UserAuthentication.class);
    public static final String PARAM_PASSWORD_EXPIRY_FOR_ADMIN = "passwordExpiryForAdmin";
    private final UserConfiguration config;
    private final Root root;
    private final String loginId;
    private String userId;
    private Principal principal;

    UserAuthentication(@NotNull UserConfiguration config, @NotNull Root root, @Nullable String loginId) {
        this.config = config;
        this.root = root;
        this.loginId = loginId;
    }

    @Override
    public boolean authenticate(@Nullable Credentials credentials) throws LoginException {
        if (credentials == null || this.loginId == null) {
            return false;
        }
        boolean success = false;
        try {
            User user = UserAuthentication.getValidUser(this.config.getUserManager(this.root, NamePathMapper.DEFAULT), this.loginId);
            if (user == null) {
                boolean bl = false;
                return bl;
            }
            if (credentials instanceof SimpleCredentials) {
                SimpleCredentials creds = (SimpleCredentials)credentials;
                Credentials userCreds = user.getCredentials();
                if (this.loginId.equals(creds.getUserID()) && userCreds instanceof CredentialsImpl) {
                    success = PasswordUtil.isSame(((CredentialsImpl)userCreds).getPasswordHash(), creds.getPassword());
                }
                UserAuthentication.checkSuccess(success, "UserId/Password mismatch.");
                if (this.isPasswordExpired(user) && !this.changePassword(user, creds)) {
                    throw new CredentialExpiredException("User password has expired");
                }
            } else if (credentials instanceof ImpersonationCredentials) {
                ImpersonationCredentials ipCreds = (ImpersonationCredentials)credentials;
                AuthInfo info = ipCreds.getImpersonatorInfo();
                success = UserAuthentication.equalUserId(ipCreds, this.loginId) && UserAuthentication.impersonate(info, user);
                UserAuthentication.checkSuccess(success, "Impersonation not allowed.");
            } else {
                success = credentials instanceof GuestCredentials || credentials == PreAuthenticatedLogin.PRE_AUTHENTICATED;
            }
            this.userId = user.getID();
            this.principal = user.getPrincipal();
        }
        catch (RepositoryException e) {
            throw new LoginException(e.getMessage());
        }
        finally {
            UserAuthentication.removeNewPwAttribute(credentials);
        }
        return success;
    }

    @Override
    @Nullable
    public String getUserId() {
        if (this.userId == null) {
            throw new IllegalStateException("UserId can only be retrieved after successful authentication.");
        }
        return this.userId;
    }

    @Override
    @Nullable
    public Principal getUserPrincipal() {
        if (this.principal == null) {
            throw new IllegalStateException("Principal can only be retrieved after successful authentication.");
        }
        return this.principal;
    }

    @Nullable
    private static User getValidUser(@NotNull UserManager userManager, @NotNull String loginId) throws RepositoryException, AccountNotFoundException, AccountLockedException {
        Authorizable authorizable = userManager.getAuthorizable(loginId);
        if (authorizable == null) {
            try {
                PasswordUtil.isSame(PasswordUtil.buildPasswordHash("oak"), "oak");
            }
            catch (UnsupportedEncodingException | NoSuchAlgorithmException exception) {
                // empty catch block
            }
            return null;
        }
        if (authorizable.isGroup()) {
            throw new AccountNotFoundException("Not a user " + loginId);
        }
        User user = (User)authorizable;
        if (user.isDisabled()) {
            throw new AccountLockedException("User with ID " + loginId + " has been disabled: " + user.getDisabledReason());
        }
        return user;
    }

    private static void checkSuccess(boolean success, @NotNull String msg) throws LoginException {
        if (!success) {
            throw new FailedLoginException(msg);
        }
    }

    private static boolean equalUserId(@NotNull ImpersonationCredentials creds, @NotNull String userId) {
        Credentials base = creds.getBaseCredentials();
        return base instanceof SimpleCredentials && userId.equals(((SimpleCredentials)base).getUserID());
    }

    private boolean changePassword(@NotNull User user, @NotNull SimpleCredentials credentials) {
        try {
            Object newPasswordObject = credentials.getAttribute("user.newpassword");
            if (newPasswordObject != null) {
                if (newPasswordObject instanceof String) {
                    user.changePassword((String)newPasswordObject);
                    this.root.commit();
                    log.debug("User {}: changed user password", (Object)this.loginId);
                    return true;
                }
                log.warn("Aborted password change for user {}: provided new password is of incompatible type {}", (Object)this.loginId, (Object)newPasswordObject.getClass().getName());
            }
        }
        catch (PasswordHistoryException e) {
            credentials.setAttribute(((Object)((Object)e)).getClass().getSimpleName(), (Object)e.getMessage());
            log.error("Failed to change password for user {}: {}", (Object)this.loginId, (Object)e.getMessage());
        }
        catch (RepositoryException | CommitFailedException e) {
            this.root.refresh();
            log.error("Failed to change password for user {}: {}", (Object)this.loginId, (Object)e.getMessage());
        }
        return false;
    }

    private static void removeNewPwAttribute(@NotNull Credentials credentials) {
        if (credentials instanceof SimpleCredentials) {
            ((SimpleCredentials)credentials).removeAttribute("user.newpassword");
        }
    }

    private static boolean impersonate(@NotNull AuthInfo info, @NotNull User user) {
        try {
            if (user.getID().equals(info.getUserID())) {
                log.debug("User {} wants to impersonate himself -> success.", (Object)info.getUserID());
                return true;
            }
            log.debug("User {} wants to impersonate {}", (Object)info.getUserID(), (Object)user.getID());
            Subject subject = new Subject(true, info.getPrincipals(), Collections.emptySet(), Collections.emptySet());
            return user.getImpersonation().allows(subject);
        }
        catch (RepositoryException e) {
            log.debug("Error while validating impersonation: {}", (Object)e.getMessage());
            return false;
        }
    }

    @Nullable
    private Long getPasswordLastModified(@NotNull User user) throws RepositoryException {
        Tree userTree = Utils.getTree(user, this.root);
        PropertyState property = userTree.getChild("rep:pwd").getProperty("rep:passwordLastModified");
        return property != null ? property.getValue(Type.LONG) : null;
    }

    private boolean isPasswordExpired(@NotNull User user) throws RepositoryException {
        ConfigurationParameters params = this.config.getParameters();
        if (!Utils.canHavePasswordExpired(user, params)) {
            return false;
        }
        boolean expired = false;
        int maxAge = params.getConfigValue("passwordMaxAge", 0);
        boolean forceInitialPwChange = params.getConfigValue("initialPasswordChange", false);
        if (maxAge > 0) {
            long expiryTime;
            Long passwordLastModified = this.getPasswordLastModified(user);
            expired = passwordLastModified == null ? true : (expiryTime = passwordLastModified + TimeUnit.MILLISECONDS.convert(maxAge, TimeUnit.DAYS)) < System.currentTimeMillis();
        } else if (forceInitialPwChange) {
            Long passwordLastModified = this.getPasswordLastModified(user);
            expired = null == passwordLastModified;
        }
        return expired;
    }
}

