/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.oauth_client.impl;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.apache.sling.auth.oauth_client.ClientConnection;
import org.apache.sling.auth.oauth_client.impl.OidcConnectionImpl;
import org.apache.sling.auth.oauth_client.impl.ResolvedConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ResolvedOidcConnection
extends ResolvedConnection {
    private final URI jwkSetURL;
    private final String issuer;

    private ResolvedOidcConnection(@NotNull String name, @NotNull String authorizationEndpoint, @NotNull String tokenEndpoint, @NotNull String clientId, @Nullable String clientSecret, @NotNull List<String> scopes, @NotNull List<String> additionalAuthorizationParameters, @Nullable URI jwkSetURL, @NotNull String issuer) {
        super(name, authorizationEndpoint, tokenEndpoint, clientId, clientSecret, scopes, additionalAuthorizationParameters);
        this.jwkSetURL = jwkSetURL;
        this.issuer = issuer;
    }

    @Nullable
    URI jwkSetURL() {
        return this.jwkSetURL;
    }

    @NotNull
    String issuer() {
        return this.issuer;
    }

    @NotNull
    static ResolvedConnection resolve(@NotNull ClientConnection connection) {
        if (connection instanceof OidcConnectionImpl) {
            OidcConnectionImpl impl = (OidcConnectionImpl)connection;
            return new ResolvedOidcConnection(connection.name(), impl.authorizationEndpoint(), impl.tokenEndpoint(), impl.clientId(), impl.clientSecret(), Arrays.asList(impl.scopes()), Arrays.asList(impl.additionalAuthorizationParameters()), impl.jwkSetURL(), impl.issuer());
        }
        throw new IllegalArgumentException(String.format("Unable to resolve %s (name=%s) of type %s", ClientConnection.class.getSimpleName(), connection.name(), connection.getClass().getName()));
    }
}

