/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.impl.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.PropertyType;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.ItemDefinition;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.vault.fs.api.Artifact;
import org.apache.jackrabbit.vault.fs.api.ArtifactType;
import org.apache.jackrabbit.vault.fs.api.IdConflictPolicy;
import org.apache.jackrabbit.vault.fs.api.ImportInfo;
import org.apache.jackrabbit.vault.fs.api.ImportMode;
import org.apache.jackrabbit.vault.fs.api.ItemFilterSet;
import org.apache.jackrabbit.vault.fs.api.NodeNameList;
import org.apache.jackrabbit.vault.fs.api.SerializationType;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.impl.ArtifactSetImpl;
import org.apache.jackrabbit.vault.fs.impl.PropertyValueArtifact;
import org.apache.jackrabbit.vault.fs.impl.io.DocViewAdapter;
import org.apache.jackrabbit.vault.fs.impl.io.DocViewSAXHandler;
import org.apache.jackrabbit.vault.fs.impl.io.ImportInfoImpl;
import org.apache.jackrabbit.vault.fs.impl.io.JackrabbitACLImporter;
import org.apache.jackrabbit.vault.fs.impl.io.JcrSysViewTransformer;
import org.apache.jackrabbit.vault.fs.impl.io.NodeStash;
import org.apache.jackrabbit.vault.fs.io.AccessControlHandling;
import org.apache.jackrabbit.vault.fs.io.DocViewParserHandler;
import org.apache.jackrabbit.vault.fs.spi.ACLManagement;
import org.apache.jackrabbit.vault.fs.spi.ServiceProviderFactory;
import org.apache.jackrabbit.vault.fs.spi.UserManagement;
import org.apache.jackrabbit.vault.fs.spi.impl.jcr20.JackrabbitUserManagement;
import org.apache.jackrabbit.vault.fs.spi.impl.jcr20.JcrNamespaceHelper;
import org.apache.jackrabbit.vault.util.DocViewNode2;
import org.apache.jackrabbit.vault.util.DocViewProperty2;
import org.apache.jackrabbit.vault.util.EffectiveNodeType;
import org.apache.jackrabbit.vault.util.MimeTypes;
import org.apache.jackrabbit.vault.util.PathUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class DocViewImporter
implements DocViewParserHandler {
    public static final String ATTRIBUTE_TYPE_CDATA = "CDATA";
    private static final Name NAME_REP_CUG_POLICY = NameFactoryImpl.getInstance().create("internal", "cugPolicy");
    private static final Name NAME_REP_MEMBERS = NameFactoryImpl.getInstance().create("internal", "members");
    private static final String NAMESPACE_OAK = "http://jackrabbit.apache.org/oak/ns/1.0";
    private static final Name NAME_OAK_COUNTER = NameFactoryImpl.getInstance().create("http://jackrabbit.apache.org/oak/ns/1.0", "counter");
    static final Logger log = LoggerFactory.getLogger(DocViewImporter.class);
    static final Set<Name> PROTECTED_PROPERTIES_CONSIDERED_FOR_NEW_NODES;
    static final Set<Name> PROTECTED_PROPERTIES_CONSIDERED_FOR_UPDATED_NODES;
    private final Session session;
    private ImportInfoImpl importInfo = new ImportInfoImpl();
    private final ItemFilterSet filter;
    private final WorkspaceFilter wspFilter;
    private Map<String, Map<String, BlobInfo>> binaries = new HashMap<String, Map<String, BlobInfo>>();
    private Set<String> hints = new HashSet<String>();
    private Set<String> preserveProperties = new HashSet<String>();
    private final ACLManagement aclManagement;
    private final UserManagement userManagement;
    private final AccessControlHandling aclHandling;
    @Nullable
    private final AccessControlHandling cugHandling;
    private final JcrNamespaceHelper nsHelper;
    private final IdConflictPolicy idConflictPolicy;
    private StackElement stack;
    private DocViewSAXHandler.Namespace nsStack = null;
    private int rootDepth;
    private final NamePathResolver npResolver;
    private final boolean isSnsSupported;

    public DocViewImporter(Node parentNode, String rootNodeName, ArtifactSetImpl artifacts, WorkspaceFilter wspFilter, IdConflictPolicy idConflictPolicy) throws RepositoryException {
        this(parentNode, rootNodeName, artifacts, wspFilter, idConflictPolicy, AccessControlHandling.IGNORE, null);
    }

    public DocViewImporter(Node parentNode, String rootNodeName, ArtifactSetImpl artifacts, WorkspaceFilter wspFilter, IdConflictPolicy idConflictPolicy, AccessControlHandling aclHandling, AccessControlHandling cugHandling) throws RepositoryException {
        this.filter = artifacts.getCoverage();
        this.wspFilter = wspFilter;
        this.rootDepth = parentNode.getDepth() + 1;
        this.session = parentNode.getSession();
        this.aclManagement = ServiceProviderFactory.getProvider().getACLManagement();
        this.userManagement = ServiceProviderFactory.getProvider().getUserManagement();
        this.nsHelper = new JcrNamespaceHelper(this.session, null);
        this.idConflictPolicy = idConflictPolicy;
        this.aclHandling = aclHandling;
        this.cugHandling = cugHandling;
        this.isSnsSupported = this.session.getRepository().getDescriptorValue("node.type.management.same.name.siblings.supported").getBoolean();
        String rootPath = parentNode.getPath();
        if (!rootPath.equals("/")) {
            rootPath = rootPath + "/";
        }
        for (Artifact a : artifacts.values(ArtifactType.BINARY)) {
            this.registerBinary(a, rootPath);
        }
        for (Artifact a : artifacts.values(ArtifactType.FILE)) {
            if (a.getSerializationType() == SerializationType.XML_DOCVIEW) continue;
            this.registerBinary(a, rootPath);
        }
        for (Artifact a : artifacts.values(ArtifactType.HINT)) {
            this.hints.add(rootPath + a.getRelativePath());
        }
        this.stack = new StackElement(parentNode, parentNode.isNew());
        this.npResolver = new DefaultNamePathResolver(parentNode.getSession());
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        String oldPrefix;
        log.trace("-> prefixMapping for {}:{}", (Object)prefix, (Object)uri);
        DocViewSAXHandler.Namespace ns = new DocViewSAXHandler.Namespace(prefix, uri);
        ns.next = this.nsStack;
        this.nsStack = ns;
        try {
            oldPrefix = this.session.getNamespacePrefix(uri);
        }
        catch (NamespaceException e) {
            try {
                oldPrefix = this.nsHelper.registerNamespace(prefix, uri);
            }
            catch (RepositoryException e1) {
                throw new IllegalStateException(e1);
            }
        }
        catch (RepositoryException e) {
            throw new IllegalStateException(e);
        }
        if (!oldPrefix.equals(prefix)) {
            try {
                this.session.setNamespacePrefix(prefix, uri);
            }
            catch (RepositoryException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public void endPrefixMapping(String prefix) {
        log.trace("<- prefixMapping for {}", (Object)prefix);
        DocViewSAXHandler.Namespace ns = this.nsStack;
        DocViewSAXHandler.Namespace prev = null;
        while (ns != null && !ns.prefix.equals(prefix)) {
            prev = ns;
            ns = ns.next;
        }
        if (ns == null) {
            throw new IllegalStateException("Illegal state: prefix " + prefix + " never mapped.");
        }
        if (prev == null) {
            this.nsStack = ns.next;
        } else {
            prev.next = ns.next;
        }
        ns = ns.next;
        while (ns != null && !ns.prefix.equals(prefix)) {
            ns = ns.next;
        }
        if (ns != null) {
            try {
                this.session.setNamespacePrefix(prefix, ns.uri);
            }
            catch (RepositoryException e) {
                throw new IllegalStateException(e);
            }
            log.trace("   remapped: {}:{}", (Object)prefix, (Object)ns.uri);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void startDocViewNode(@NotNull String nodePath, @NotNull DocViewNode2 docViewNode, @NotNull Optional<DocViewNode2> parentDocViewNode, int line, int column) throws IOException, RepositoryException {
        this.stack.addName(docViewNode.getSnsAwareName());
        Node node = this.stack.getNode();
        if (node == null) {
            this.stack = this.stack.push();
            DocViewAdapter xform = this.stack.getAdapter();
            if (xform != null) {
                xform.startNode(docViewNode);
                return;
            }
            log.trace("Skipping ignored node {}", (Object)docViewNode);
            return;
        }
        if (docViewNode.getProperties().isEmpty()) {
            log.trace("Skipping empty node {}", (Object)nodePath);
            this.stack = this.stack.push();
            return;
        }
        if (docViewNode.getIndex() > 1 && !this.isSnsSupported) {
            log.warn("Skipping unsupported SNS node with index > 1. Some content will be missing after import: {}", (Object)nodePath);
            this.stack = this.stack.push();
            return;
        }
        try {
            if (docViewNode.getPrimaryType().filter(this.aclManagement::isACLNodeType).isPresent()) {
                AccessControlHandling acHandling = this.getAcHandling(docViewNode.getName());
                if (acHandling != AccessControlHandling.CLEAR && acHandling != AccessControlHandling.IGNORE) {
                    log.trace("Access control policy element detected. starting special transformation {}/{}", (Object)node.getPath(), (Object)docViewNode.getName());
                    if (this.aclManagement.ensureAccessControllable(node, this.npResolver.getJCRName(docViewNode.getName()))) {
                        log.debug("Adding access control policy element to non access-controllable parent - adding mixin: {}", (Object)node.getPath());
                    }
                    this.stack = this.stack.push();
                    if (!NameConstants.REP_REPO_POLICY.equals(docViewNode.getName())) {
                        this.stack.adapter = new JackrabbitACLImporter(node, acHandling);
                        this.stack.adapter.startNode(docViewNode);
                        return;
                    }
                    if (node.getDepth() == 0) {
                        this.stack.adapter = new JackrabbitACLImporter(this.session, acHandling);
                        this.stack.adapter.startNode(docViewNode);
                        return;
                    }
                    log.debug("ignoring invalid location for repository level ACL: {}", (Object)node.getPath());
                    return;
                }
                this.stack = this.stack.push();
                return;
            }
            if (this.userManagement != null) {
                if (docViewNode.getPrimaryType().filter(this.userManagement::isAuthorizableNodeType).isPresent()) {
                    this.handleAuthorizable(node, docViewNode);
                    return;
                }
            }
            this.stack = this.stack.push(this.addNode(docViewNode));
            return;
        }
        catch (IOException | RepositoryException e) {
            if (e instanceof ConstraintViolationException && this.wspFilter.getImportMode(nodePath) != ImportMode.REPLACE) {
                log.warn("Error during processing of {}: {}, skip node due to import mode {}", new Object[]{nodePath, e.toString(), this.wspFilter.getImportMode(nodePath)});
                this.importInfo.onNop(nodePath);
            } else {
                log.error("Error during processing of {}: {}", (Object)nodePath, (Object)e.toString());
                this.importInfo.onError(nodePath, e);
            }
            this.stack = this.stack.push();
        }
    }

    @Override
    public void endDocViewNode(@NotNull String nodePath, @NotNull DocViewNode2 docViewNode, @NotNull Optional<DocViewNode2> parentDocViewNode, int line, int column) throws IOException, RepositoryException {
        NodeNameList childNames = this.stack.getChildNames();
        Node node = this.stack.getNode();
        int numChildren = 0;
        if (node == null) {
            DocViewAdapter adapter = this.stack.getAdapter();
            if (adapter != null) {
                adapter.endNode();
            }
            if (this.stack.adapter != null) {
                List<String> createdPaths = this.stack.adapter.close();
                for (String createdPath : createdPaths) {
                    this.importInfo.onCreated(createdPath);
                }
                this.stack.adapter = null;
                log.trace("Sysview transformation complete.");
            }
        } else {
            NodeIterator iter = node.getNodes();
            while (iter.hasNext()) {
                ++numChildren;
                Node child = iter.nextNode();
                String path = child.getPath();
                String label = Text.getName(path);
                AccessControlHandling acHandling = this.getAcHandling(this.npResolver.getQName(child.getName()));
                if (!childNames.contains(label) && !this.hints.contains(path) && this.isIncluded(child, child.getDepth() - this.rootDepth)) {
                    if (this.aclManagement.isACLNode(child)) {
                        if (acHandling != AccessControlHandling.OVERWRITE && acHandling != AccessControlHandling.CLEAR) continue;
                        this.importInfo.onDeleted(path);
                        this.aclManagement.clearACL(node);
                        continue;
                    }
                    if (this.wspFilter.getImportMode(path) != ImportMode.REPLACE) continue;
                    boolean shouldRemoveChild = true;
                    if (child.getDefinition().isProtected()) {
                        log.warn("Refuse to delete protected child node: {}", (Object)path);
                        shouldRemoveChild = false;
                    } else if (child.getDefinition().isMandatory() && !child.getDefinition().getName().equals("*")) {
                        EffectiveNodeType ent = EffectiveNodeType.ofNode(child.getParent());
                        Optional<NodeDefinition> childNodeDefinition = ent.getApplicableChildNodeDefinition(child.getName(), child.getPrimaryNodeType());
                        if (!childNodeDefinition.isPresent()) {
                            throw new IllegalStateException("Could not find applicable child node definition for mandatory child node " + child.getPath());
                        }
                        if (!this.hasSiblingWithPrimaryTypesAndName(child, childNodeDefinition.get().getRequiredPrimaryTypes(), childNodeDefinition.get().getName())) {
                            log.warn("Refuse to delete mandatory non-residual child node: {} with no other matching siblings", (Object)path);
                            shouldRemoveChild = false;
                        }
                    }
                    if (!shouldRemoveChild) continue;
                    this.importInfo.onDeleted(path);
                    child.remove();
                    continue;
                }
                if (acHandling != AccessControlHandling.CLEAR || !this.aclManagement.isACLNode(child) || !this.isIncluded(child, child.getDepth() - this.rootDepth)) continue;
                this.importInfo.onDeleted(path);
                this.aclManagement.clearACL(node);
            }
            if (this.isIncluded(node, node.getDepth() - this.rootDepth)) {
                this.stack.restoreOrder();
            }
        }
        this.stack = this.stack.pop();
        if (node != null && (numChildren == 0 && !childNames.isEmpty() || this.stack.isRoot())) {
            this.importInfo.addNameList(node.getPath(), childNames);
        }
    }

    private boolean hasSiblingWithPrimaryTypesAndName(Node node, NodeType[] requiredPrimaryNodeTypes, String requiredName) throws RepositoryException {
        NodeIterator iter = node.getParent().getNodes();
        while (iter.hasNext()) {
            Node sibling = iter.nextNode();
            if (sibling.isSame(node)) continue;
            boolean allTypesMatch = true;
            for (NodeType requiredPrimaryNodeType : requiredPrimaryNodeTypes) {
                allTypesMatch &= sibling.isNodeType(requiredPrimaryNodeType.getName());
            }
            if (!allTypesMatch || !requiredName.equals("*") && !requiredName.equals(node.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void endDocument() throws RepositoryException, IOException {
        if (!this.stack.isRoot()) {
            throw new IllegalStateException("stack mismatch");
        }
        for (String parentPath : this.binaries.keySet()) {
            Node fNode;
            BlobInfo info;
            Node node;
            Map<String, BlobInfo> blobs = this.binaries.get(parentPath);
            log.trace("processing binaries at {}", (Object)parentPath);
            if (this.session.nodeExists(parentPath)) {
                node = this.session.getNode(parentPath);
                for (String propName : blobs.keySet()) {
                    info = blobs.get(propName);
                    if (node.hasNode(propName)) {
                        this.handleBinNode(node.getNode(propName), info, true);
                        continue;
                    }
                    if (info.isFile()) {
                        fNode = node.addNode(propName, "nt:file");
                        this.importInfo.onCreated(fNode.getPath());
                        this.handleBinNode(fNode, info, false);
                        continue;
                    }
                    if (info.isMulti) {
                        node.setProperty(propName, info.getValues(this.session));
                    } else {
                        node.setProperty(propName, info.getValue(this.session));
                    }
                    this.importInfo.onModified(node.getPath());
                }
                continue;
            }
            log.warn("binaries parent path does not exist: {}", (Object)parentPath);
            node = null;
            for (String propName : blobs.keySet()) {
                info = blobs.get(propName);
                if (!info.isFile()) continue;
                if (node == null) {
                    node = this.createNodeDeep(parentPath);
                }
                fNode = node.addNode(propName, "nt:file");
                this.importInfo.onCreated(fNode.getPath());
                this.handleBinNode(fNode, info, false);
            }
        }
    }

    private void registerBinary(Artifact a, String rootPath) throws RepositoryException {
        int idx;
        String path = rootPath + a.getRelativePath();
        int pos = path.indexOf(91, path.lastIndexOf(47));
        if (pos > 0) {
            idx = Integer.parseInt(path.substring(pos + 1, path.length() - 1));
            path = path.substring(0, pos);
        } else {
            idx = -1;
        }
        if (a.getType() == ArtifactType.FILE && a instanceof PropertyValueArtifact) {
            String parentPath = ((PropertyValueArtifact)a).getProperty().getParent().getPath();
            this.preserveProperties.add(parentPath + "/" + "jcr:data");
            this.preserveProperties.add(parentPath + "/" + "jcr:lastModified");
        } else {
            this.preserveProperties.add(path);
            this.preserveProperties.add(path + "/jcr:content/jcr:data");
            this.preserveProperties.add(path + "/jcr:content/jcr:lastModified");
            this.preserveProperties.add(path + "/jcr:content/jcr:mimeType");
            String parentPath = Text.getRelativeParent(path, 1);
            String name = Text.getName(path);
            Map infoSet = this.binaries.computeIfAbsent(parentPath, p -> new HashMap());
            BlobInfo info = infoSet.computeIfAbsent(name, n -> new BlobInfo(idx >= 0));
            if (idx >= 0) {
                info.add(idx, a);
            } else {
                info.add(a);
            }
        }
        log.trace("scheduling binary: {}{}", (Object)rootPath, (Object)(a.getRelativePath() + a.getExtension()));
    }

    private boolean isIncluded(Item item, int depth) throws RepositoryException {
        String path = this.importInfo.getRemapped().map(item.getPath());
        return this.wspFilter.contains(path) && (depth == 0 || this.filter.contains(item, path, depth));
    }

    public ImportInfoImpl getInfo() {
        return this.importInfo;
    }

    private Node createNodeDeep(String path) throws RepositoryException {
        Node node;
        if (this.session.nodeExists(path)) {
            return this.session.getNode(path);
        }
        int idx = path.lastIndexOf(47);
        if (idx <= 0) {
            return this.session.getRootNode();
        }
        String parentPath = path.substring(0, idx);
        String name = path.substring(idx + 1);
        Node parentNode = this.createNodeDeep(parentPath);
        try {
            node = parentNode.addNode(name);
        }
        catch (RepositoryException e) {
            node = parentNode.addNode(name, "nt:folder");
        }
        this.importInfo.onCreated(node.getPath());
        return node;
    }

    private void handleBinNode(Node node, BlobInfo info, boolean checkIfNtFileOk) throws RepositoryException, IOException {
        log.trace("handling binary file at {}", (Object)node.getPath());
        if (info.isMulti) {
            throw new IllegalStateException("unable to add MV binary to node " + node.getPath());
        }
        if (checkIfNtFileOk) {
            if (node.isNodeType("nt:file")) {
                node = node.hasNode("jcr:content") ? node.getNode("jcr:content") : node.addNode("jcr:content", "nt:resource");
            }
        } else {
            node = node.addNode("jcr:content", "nt:resource");
        }
        Artifact a = (Artifact)info.artifacts.get(0);
        boolean modified = false;
        ValueFactory factory = node.getSession().getValueFactory();
        try (InputStream input = a.getInputStream();){
            Value value = factory.createValue(input);
            if (node.hasProperty("jcr:data")) {
                Property data = node.getProperty("jcr:data");
                if (!value.equals(data.getValue())) {
                    data.setValue(value);
                    this.importInfo.onModified(data.getPath());
                    modified = true;
                }
            } else {
                Property data = node.setProperty("jcr:data", value);
                this.importInfo.onCreated(data.getPath());
                modified = true;
            }
        }
        if (!node.hasProperty("jcr:lastModified") || modified) {
            Calendar lastModified = Calendar.getInstance();
            node.setProperty("jcr:lastModified", lastModified);
            modified = true;
        }
        if (!node.hasProperty("jcr:mimeType")) {
            String mimeType = a.getContentType();
            if (mimeType == null) {
                mimeType = Text.getName(a.getRelativePath(), '.');
                mimeType = MimeTypes.getMimeType(mimeType, "application/octet-stream");
            }
            node.setProperty("jcr:mimeType", mimeType);
            modified = true;
        }
        if (node.isNew()) {
            this.importInfo.onCreated(node.getPath());
        } else if (modified) {
            this.importInfo.onModified(node.getPath());
        }
    }

    private void handleAuthorizable(Node node, DocViewNode2 docViewNode) throws RepositoryException {
        String id = this.userManagement.getAuthorizableId(docViewNode);
        String newPath = node.getPath() + "/" + this.npResolver.getJCRName(docViewNode.getName());
        boolean isIncluded = this.wspFilter.contains(newPath);
        String oldPath = this.userManagement.getAuthorizablePath(this.session, id);
        if (oldPath == null) {
            if (!isIncluded) {
                log.trace("auto-creating authorizable node not in filter {}", (Object)newPath);
            }
            log.trace("Authorizable element detected. starting sysview transformation {}", (Object)newPath);
            this.stack = this.stack.push();
            this.stack.adapter = new JcrSysViewTransformer(node, this.wspFilter.getImportMode(newPath));
            this.stack.adapter.startNode(docViewNode);
            this.importInfo.onCreated(newPath);
            return;
        }
        Node authNode = this.session.getNode(oldPath);
        ImportMode mode = this.wspFilter.getImportMode(newPath);
        if (mode != ImportMode.REPLACE || !isIncluded) {
            this.importInfo.onRemapped(oldPath, newPath);
        }
        if (!isIncluded) {
            this.stack = this.stack.push(new StackElement(authNode, false));
            this.importInfo.onNop(oldPath);
            return;
        }
        switch (mode) {
            case MERGE: 
            case MERGE_PROPERTIES: {
                Optional<DocViewProperty2> prop = docViewNode.getProperty(NAME_REP_MEMBERS);
                if (prop.isPresent()) {
                    this.importInfo.registerMemberships(id, prop.get().getStringValues().toArray(new String[0]));
                }
                log.debug("Skipping import of existing authorizable '{}' due to MERGE import mode.", (Object)id);
                this.stack = this.stack.push(new StackElement(authNode, false));
                this.importInfo.onNop(newPath);
                break;
            }
            case REPLACE: {
                log.trace("Authorizable element detected. starting sysview transformation {}", (Object)newPath);
                this.stack = this.stack.push();
                this.stack.adapter = new JcrSysViewTransformer(node, mode);
                this.stack.adapter.startNode(docViewNode);
                this.importInfo.onReplaced(newPath);
                break;
            }
            case UPDATE: 
            case UPDATE_PROPERTIES: {
                log.trace("Authorizable element detected. starting sysview transformation {}", (Object)newPath);
                this.stack = this.stack.push();
                this.stack.adapter = new JcrSysViewTransformer(node, oldPath, mode);
                String newName = Text.getName(oldPath);
                LinkedList<DocViewProperty2> properties = new LinkedList<DocViewProperty2>(docViewNode.getProperties());
                if (authNode.hasProperty("rep:authorizableId")) {
                    DocViewProperty2 authId = new DocViewProperty2(JackrabbitUserManagement.NAME_REP_AUTHORIZABLE_ID, authNode.getProperty("rep:authorizableId").getString(), 1);
                    properties.removeIf(p -> p.getName().equals(JackrabbitUserManagement.NAME_REP_AUTHORIZABLE_ID));
                    properties.add(authId);
                }
                DocViewNode2 mapped = new DocViewNode2(this.npResolver.getQName(newName), properties);
                this.stack.adapter.startNode(mapped);
                this.importInfo.onReplaced(newPath);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private StackElement addNode(DocViewNode2 docViewNode) throws RepositoryException, IOException {
        boolean isNew;
        Node currentNode = this.stack.getNode();
        LinkedList<DocViewProperty2> preprocessedProperties = new LinkedList<DocViewProperty2>(docViewNode.getProperties());
        Node existingNode = null;
        if (NameConstants.ROOT.equals(docViewNode.getName())) {
            existingNode = currentNode;
        } else {
            Optional<String> identifier;
            if (this.stack.checkForNode() && currentNode.hasNode(docViewNode.getName().toString())) {
                existingNode = currentNode.getNode(docViewNode.getName().toString());
            }
            if ((identifier = docViewNode.getIdentifier()).isPresent()) {
                try {
                    Node sameIdNode = this.session.getNodeByIdentifier(identifier.get());
                    String newNodePath = currentNode.getPath() + "/" + this.npResolver.getJCRName(docViewNode.getName());
                    if (existingNode != null && existingNode.getPath().equals(sameIdNode.getPath())) {
                        log.debug("Node at {} with existing identifier {} is being updated without modifying its identifier", (Object)existingNode.getPath(), docViewNode.getIdentifier());
                    } else {
                        log.warn("Node Collision: To-be imported node {} uses a node identifier {} which is already taken by {}, trying to resolve conflict according to policy {}", new Object[]{newNodePath, docViewNode.getIdentifier(), sameIdNode.getPath(), this.idConflictPolicy.name()});
                        if (this.idConflictPolicy == IdConflictPolicy.FAIL) {
                            if (!this.isIncluded(sameIdNode, 0)) throw new ReferentialIntegrityException("Node identifier " + docViewNode.getIdentifier() + " already taken by node " + sameIdNode.getPath());
                            ImportInfo.Info sameIdNodeInfo = this.importInfo.getInfo(sameIdNode.getPath());
                            if (sameIdNodeInfo != null && sameIdNodeInfo.getType() != ImportInfo.Type.DEL) {
                                throw new ReferentialIntegrityException("Node identifier " + docViewNode.getIdentifier() + " already taken by node " + sameIdNode.getPath() + " from the same package");
                            }
                            log.warn("Trying to remove existing conflicting node {} (and all its references)", (Object)sameIdNode.getPath());
                            this.removeReferences(sameIdNode);
                            String sameIdNodePath = sameIdNode.getPath();
                            this.session.removeItem(sameIdNodePath);
                            log.warn("Node {} and its references removed", (Object)sameIdNodePath);
                            existingNode = null;
                        } else if (this.idConflictPolicy == IdConflictPolicy.LEGACY) {
                            if (sameIdNode.getParent().isSame(currentNode)) {
                                String sameIdNodePath = sameIdNode.getPath();
                                if (this.isIncluded(sameIdNode, 0)) {
                                    log.warn("Existing conflicting node {} has same parent as to-be imported one and is contained in the filter, trying to remove it.", (Object)sameIdNodePath);
                                    this.session.removeItem(sameIdNodePath);
                                    this.importInfo.onDeleted(sameIdNodePath);
                                } else {
                                    log.warn("Existing conflicting node {} has same parent as to-be imported one and is not contained in the filter, ignoring new node but continue with children below existing conflicting node", (Object)sameIdNodePath);
                                    this.importInfo.onRemapped(newNodePath, sameIdNodePath);
                                    existingNode = sameIdNode;
                                }
                            } else {
                                log.warn("To-be imported node and existing conflicting node have different parents. Will create new identifier for the former. ({})", (Object)newNodePath);
                                preprocessedProperties.removeIf(p -> p.getName().equals(NameConstants.JCR_UUID) || p.getName().equals(NameConstants.JCR_BASEVERSION) || p.getName().equals(NameConstants.JCR_PREDECESSORS) || p.getName().equals(NameConstants.JCR_SUCCESSORS) || p.getName().equals(NameConstants.JCR_VERSIONHISTORY));
                            }
                        }
                    }
                }
                catch (ItemNotFoundException sameIdNode) {
                    // empty catch block
                }
            }
        }
        preprocessedProperties.removeIf(p -> p.getName().equals(NameConstants.JCR_ISCHECKEDOUT));
        boolean isCheckedIn = "false".equals(docViewNode.getPropertyValue(NameConstants.JCR_ISCHECKEDOUT).orElse("true"));
        boolean bl = isNew = existingNode == null;
        if (isNew) {
            if (!docViewNode.hasProperty(NameConstants.JCR_MIXINTYPES)) {
                preprocessedProperties.add(new DocViewProperty2(NameConstants.JCR_MIXINTYPES, Collections.emptyList(), 7));
            }
            this.stack.ensureCheckedOut();
            existingNode = this.createNewNode(currentNode, docViewNode.cloneWithDifferentProperties(preprocessedProperties));
            if (existingNode.getDefinition() == null) {
                throw new RepositoryException("Child node not allowed.");
            }
            if (existingNode.isNodeType("nt:resource")) {
                if (!existingNode.hasProperty("jcr:data")) {
                    this.importInfo.onMissing(existingNode.getPath() + "/" + "jcr:data");
                }
            } else if (isCheckedIn) {
                this.importInfo.registerToVersion(existingNode.getPath());
            }
            this.importInfo.onCreated(existingNode.getPath());
            return new StackElement(existingNode, isNew);
        } else if (this.isIncluded(existingNode, existingNode.getDepth() - this.rootDepth)) {
            if (isCheckedIn) {
                this.importInfo.registerToVersion(existingNode.getPath());
            }
            ImportMode importMode = this.wspFilter.getImportMode(existingNode.getPath());
            Node updatedNode = this.updateExistingNode(existingNode, docViewNode.cloneWithDifferentProperties(preprocessedProperties), importMode);
            if (updatedNode != null) {
                if (updatedNode.isNodeType("nt:resource") && !updatedNode.hasProperty("jcr:data")) {
                    this.importInfo.onMissing(existingNode.getPath() + "/" + "jcr:data");
                }
                this.importInfo.onModified(updatedNode.getPath());
                existingNode = updatedNode;
                return new StackElement(existingNode, isNew);
            } else {
                this.importInfo.onNop(existingNode.getPath());
            }
            return new StackElement(existingNode, isNew);
        } else {
            this.binaries.remove(existingNode.getPath());
        }
        return new StackElement(existingNode, isNew);
    }

    private void removeReferences(@NotNull Node node) throws ReferentialIntegrityException, RepositoryException {
        ArrayList<String> removableReferencePaths = new ArrayList<String>();
        PropertyIterator pIter = node.getReferences();
        while (pIter.hasNext()) {
            Property referenceProperty = pIter.nextProperty();
            if (this.isIncluded(referenceProperty, 0) || this.idConflictPolicy == IdConflictPolicy.FORCE_REMOVE_CONFLICTING_ID) {
                removableReferencePaths.add(referenceProperty.getPath());
                continue;
            }
            throw new ReferentialIntegrityException("Found non-removable reference for conflicting UUID " + node.getIdentifier() + " (" + node.getPath() + ") at " + referenceProperty.getPath());
        }
        for (String referencePath : removableReferencePaths) {
            log.info("Remove reference towards {} at {}", (Object)node.getIdentifier(), (Object)referencePath);
            this.session.removeItem(referencePath);
        }
    }

    @Nullable
    private Node updateExistingNode(@NotNull Node node, @NotNull DocViewNode2 ni, @NotNull ImportMode importMode) throws RepositoryException {
        VersioningState vs = new VersioningState(this.stack, node);
        Node updatedNode = null;
        Optional<String> identifier = ni.getIdentifier();
        if (identifier.isPresent() && !node.getIdentifier().equals(identifier.get()) && !"rep:root".equals(ni.getPrimaryType().orElse(""))) {
            NodeStash stash = new NodeStash(this.session, node.getPath());
            stash.stash();
            Node parent = node.getParent();
            this.removeReferences(node);
            node.remove();
            updatedNode = this.createNewNode(parent, ni);
            stash.recover(importMode, this.importInfo);
        } else {
            String primaryType = ni.getPrimaryType().orElseThrow(() -> new IllegalStateException("Mandatory property 'jcr:primaryType' missing from " + ni));
            if (importMode == ImportMode.REPLACE && !"rep:root".equals(primaryType) && this.wspFilter.includesProperty(PathUtil.append(node.getPath(), "jcr:primaryType")) && !node.getPrimaryNodeType().getName().equals(primaryType)) {
                vs.ensureCheckedOut();
                node.setPrimaryType(primaryType);
                updatedNode = node;
            }
            HashSet<String> newMixins = new HashSet<String>();
            if (this.wspFilter.includesProperty(PathUtil.append(node.getPath(), "jcr:mixinTypes"))) {
                AccessControlHandling acHandling = this.getAcHandling(ni.getName());
                for (String mixin : ni.getMixinTypes()) {
                    if (this.aclManagement.isAccessControllableMixin(mixin) && acHandling == AccessControlHandling.CLEAR) continue;
                    newMixins.add(mixin);
                }
                if (importMode == ImportMode.REPLACE) {
                    for (NodeType mix : node.getMixinNodeTypes()) {
                        String name = mix.getName();
                        if (newMixins.remove(name) || this.aclManagement.isAccessControllableMixin(name) && acHandling != AccessControlHandling.CLEAR && acHandling != AccessControlHandling.OVERWRITE) continue;
                        vs.ensureCheckedOut();
                        node.removeMixin(name);
                        updatedNode = node;
                    }
                }
                for (String mixin : newMixins) {
                    vs.ensureCheckedOut();
                    node.addMixin(mixin);
                    updatedNode = node;
                }
            }
            if (importMode == ImportMode.REPLACE) {
                PropertyIterator pIter = node.getProperties();
                while (pIter.hasNext()) {
                    Property p = pIter.nextProperty();
                    String propName = p.getName();
                    if (p.getDefinition().isProtected() || ni.hasProperty(this.npResolver.getQName(propName)) || this.preserveProperties.contains(p.getPath()) || !this.wspFilter.includesProperty(p.getPath())) continue;
                    vs.ensureCheckedOut();
                    p.remove();
                    updatedNode = node;
                }
            }
            EffectiveNodeType effectiveNodeType = EffectiveNodeType.ofNode(node);
            this.logIgnoredProtectedProperties(effectiveNodeType, node.getPath(), ni.getProperties(), PROTECTED_PROPERTIES_CONSIDERED_FOR_UPDATED_NODES);
            if (this.setUnprotectedProperties(effectiveNodeType, node, ni, importMode == ImportMode.REPLACE || importMode == ImportMode.UPDATE || importMode == ImportMode.UPDATE_PROPERTIES, vs)) {
                updatedNode = node;
            }
        }
        return updatedNode;
    }

    @NotNull
    private Node createNewNode(Node parentNode, DocViewNode2 ni) throws RepositoryException {
        int importUuidBehavior;
        switch (this.idConflictPolicy) {
            case CREATE_NEW_ID: {
                importUuidBehavior = 0;
                break;
            }
            case FORCE_REMOVE_CONFLICTING_ID: {
                importUuidBehavior = 1;
                break;
            }
            default: {
                importUuidBehavior = 3;
            }
        }
        try {
            String parentPath = parentNode.getPath();
            ContentHandler handler = this.session.getImportContentHandler(parentPath, importUuidBehavior);
            String[] prefixes = this.session.getNamespacePrefixes();
            handler.startDocument();
            for (String prefix : prefixes) {
                handler.startPrefixMapping(prefix, this.session.getNamespaceURI(prefix));
            }
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("http://www.jcp.org/jcr/sv/1.0", "name", "sv:name", ATTRIBUTE_TYPE_CDATA, this.npResolver.getJCRName(ni.getName()));
            handler.startElement("http://www.jcp.org/jcr/sv/1.0", "node", "sv:node", attrs);
            boolean addMixRef = false;
            if (ni.getIndex() > 0 && !ni.getIdentifier().isPresent()) {
                LinkedList<DocViewProperty2> preprocessedProperties = new LinkedList<DocViewProperty2>(ni.getProperties());
                preprocessedProperties.add(new DocViewProperty2(NameConstants.JCR_UUID, UUID.randomUUID().toString(), 1));
                Object mix = ni.getProperty(NameConstants.JCR_MIXINTYPES).orElse(null);
                addMixRef = true;
                if (mix == null) {
                    mix = new DocViewProperty2(NameConstants.JCR_MIXINTYPES, Collections.singletonList("mix:referenceable"), 7);
                    preprocessedProperties.add((DocViewProperty2)mix);
                } else {
                    for (String v : ((DocViewProperty2)mix).getStringValues()) {
                        if (!v.equals("mix:referenceable")) continue;
                        addMixRef = false;
                        break;
                    }
                    if (addMixRef) {
                        LinkedList<String> mixinValues = new LinkedList<String>(((DocViewProperty2)mix).getStringValues());
                        mixinValues.add("mix:referenceable");
                        preprocessedProperties.remove(mix);
                        mix = new DocViewProperty2(NameConstants.JCR_MIXINTYPES, mixinValues, 7);
                        preprocessedProperties.add((DocViewProperty2)mix);
                    }
                }
                ni = ni.cloneWithDifferentProperties(preprocessedProperties);
            }
            String nodePath = PathUtil.append(parentPath, this.npResolver.getJCRName(ni.getName()));
            for (DocViewProperty2 p : ni.getProperties()) {
                String qualifiedPropertyName = this.npResolver.getJCRName(p.getName());
                if (!p.getStringValue().isPresent() || !PROTECTED_PROPERTIES_CONSIDERED_FOR_NEW_NODES.contains(p.getName()) || !this.wspFilter.includesProperty(nodePath + "/" + qualifiedPropertyName)) continue;
                attrs = new AttributesImpl();
                attrs.addAttribute("http://www.jcp.org/jcr/sv/1.0", "name", "sv:name", ATTRIBUTE_TYPE_CDATA, qualifiedPropertyName);
                attrs.addAttribute("http://www.jcp.org/jcr/sv/1.0", "type", "sv:type", ATTRIBUTE_TYPE_CDATA, PropertyType.nameFromValue(p.getType()));
                handler.startElement("http://www.jcp.org/jcr/sv/1.0", "property", "sv:property", attrs);
                for (String v : p.getStringValues()) {
                    handler.startElement("http://www.jcp.org/jcr/sv/1.0", "value", "sv:value", DocViewSAXHandler.EMPTY_ATTRIBUTES);
                    handler.characters(v.toCharArray(), 0, v.length());
                    handler.endElement("http://www.jcp.org/jcr/sv/1.0", "value", "sv:value");
                }
                handler.endElement("http://www.jcp.org/jcr/sv/1.0", "property", "sv:property");
            }
            handler.endElement("http://www.jcp.org/jcr/sv/1.0", "node", "sv:node");
            handler.endDocument();
            Node node = this.getNodeByIdOrName(parentNode, ni, importUuidBehavior == 0);
            EffectiveNodeType effectiveNodeType = EffectiveNodeType.ofNode(node);
            this.logIgnoredProtectedProperties(effectiveNodeType, node.getPath(), ni.getProperties(), PROTECTED_PROPERTIES_CONSIDERED_FOR_NEW_NODES);
            this.setUnprotectedProperties(effectiveNodeType, node, ni, true, null);
            if (addMixRef) {
                node.removeMixin("mix:referenceable");
            }
            return node;
        }
        catch (SAXException e) {
            Exception root = e.getException();
            if (root instanceof RepositoryException) {
                if (root instanceof ConstraintViolationException) {
                    try {
                        Node node = this.getNodeByIdOrName(parentNode, ni, importUuidBehavior == 0);
                        node.remove();
                    }
                    catch (RepositoryException repositoryException) {
                        // empty catch block
                    }
                }
                throw (RepositoryException)root;
            }
            if (root instanceof RuntimeException) {
                throw (RuntimeException)root;
            }
            throw new RepositoryException("Error while creating node", root);
        }
    }

    private void logIgnoredProtectedProperties(EffectiveNodeType effectiveNodeType, String nodePath, Collection<DocViewProperty2> properties, Set<Name> importedProtectedProperties) {
        properties.stream().filter(p -> p.getStringValue().isPresent() && !importedProtectedProperties.contains(p.getName())).forEach(p -> {
            try {
                if (this.isPropertyProtected(effectiveNodeType, (DocViewProperty2)p)) {
                    log.warn("Ignore protected property '{}' on node '{}'", (Object)this.npResolver.getJCRName(p.getName()), (Object)nodePath);
                }
            }
            catch (RepositoryException e) {
                throw new IllegalStateException("Error retrieving protected status of properties", e);
            }
        });
    }

    private boolean isPropertyProtected(@NotNull EffectiveNodeType effectiveNodeType, @NotNull DocViewProperty2 docViewProperty) throws RepositoryException {
        return effectiveNodeType.getApplicablePropertyDefinition(this.npResolver.getJCRName(docViewProperty.getName()), docViewProperty.isMultiValue(), docViewProperty.getType()).map(ItemDefinition::isProtected).orElse(false);
    }

    private Node getNodeByIdOrName(@NotNull Node currentNode, @NotNull DocViewNode2 ni, boolean isIdNewlyAssigned) throws RepositoryException {
        Node node = null;
        Optional<String> id = ni.getIdentifier();
        if (id.isPresent() && !isIdNewlyAssigned) {
            try {
                node = currentNode.getSession().getNodeByIdentifier(id.get());
            }
            catch (RepositoryException e) {
                log.warn("Newly created node not found by uuid {}: {}", (Object)(currentNode.getPath() + "/" + ni.getName()), (Object)e.toString());
            }
        }
        if (node == null) {
            try {
                node = currentNode.getNode(ni.getSnsAwareName().toString());
            }
            catch (RepositoryException e) {
                log.warn("Newly created node not found by SNS aware name {}: {}", (Object)(currentNode.getPath() + "/" + ni.getSnsAwareName()), (Object)e.toString());
            }
        }
        if (node == null) {
            try {
                node = currentNode.getNode(ni.getName().toString());
            }
            catch (RepositoryException e) {
                log.debug("Newly created node not found by name {}: {}", (Object)(currentNode.getPath() + "/" + ni.getName()), (Object)e.toString());
                throw e;
            }
        }
        return node;
    }

    private boolean setUnprotectedProperties(@NotNull EffectiveNodeType effectiveNodeType, @NotNull Node node, @NotNull DocViewNode2 ni, boolean overwriteExistingProperties, @Nullable VersioningState vs) throws RepositoryException {
        boolean isAtomicCounter = false;
        for (String string : ni.getMixinTypes()) {
            if (!"mix:atomicCounter".equals(string)) continue;
            isAtomicCounter = true;
        }
        boolean modified = false;
        for (DocViewProperty2 prop : ni.getProperties()) {
            if (prop == null || this.isPropertyProtected(effectiveNodeType, prop) || !overwriteExistingProperties && node.hasProperty(prop.getName().toString()) || !this.wspFilter.includesProperty(node.getPath() + "/" + this.npResolver.getJCRName(prop.getName()))) continue;
            try {
                modified |= prop.apply(node);
            }
            catch (RepositoryException e) {
                try {
                    if (vs == null) {
                        throw e;
                    }
                    vs.ensureCheckedOut();
                    modified |= prop.apply(node);
                }
                catch (RepositoryException e1) {
                    if (this.wspFilter.getImportMode(node.getPath()) != ImportMode.REPLACE) {
                        log.warn("Error while setting property {} (ignore due to mode {}): {}", new Object[]{prop.getName(), this.wspFilter.getImportMode(node.getPath()), e1});
                        continue;
                    }
                    throw e;
                }
            }
        }
        if (isAtomicCounter && this.wspFilter.includesProperty(node.getPath() + "/" + this.npResolver.getJCRName(NAME_OAK_COUNTER))) {
            long l = 0L;
            if (node.hasProperty(NAME_OAK_COUNTER.toString())) {
                l = node.getProperty(NAME_OAK_COUNTER.toString()).getLong();
            }
            long counter = 0L;
            try {
                counter = ni.getPropertyValue(NAME_OAK_COUNTER).map(Long::valueOf).orElse(0L);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (counter != l) {
                node.setProperty("oak:increment", counter - l);
                modified = true;
            }
        }
        return modified;
    }

    @NotNull
    private AccessControlHandling getAcHandling(@NotNull Name nodeName) {
        if (this.cugHandling != null && NAME_REP_CUG_POLICY.equals(nodeName)) {
            return this.cugHandling;
        }
        return this.aclHandling;
    }

    static {
        HashSet<Name> props = new HashSet<Name>();
        props.add(NameConstants.JCR_PRIMARYTYPE);
        props.add(NameConstants.JCR_MIXINTYPES);
        props.add(NameConstants.JCR_UUID);
        PROTECTED_PROPERTIES_CONSIDERED_FOR_UPDATED_NODES = Collections.unmodifiableSet(props);
        props.add(NameConstants.JCR_ISCHECKEDOUT);
        props.add(NameConstants.JCR_BASEVERSION);
        props.add(NameConstants.JCR_PREDECESSORS);
        props.add(NameConstants.JCR_SUCCESSORS);
        props.add(NameConstants.JCR_VERSIONHISTORY);
        PROTECTED_PROPERTIES_CONSIDERED_FOR_NEW_NODES = Collections.unmodifiableSet(props);
    }

    private class VersioningState {
        private final StackElement stack;
        private final Node node;
        private boolean isCheckedOut;
        private boolean isParentCheckedOut;

        private VersioningState(StackElement stack, Node node) throws RepositoryException {
            this.stack = stack;
            this.node = node;
            this.isCheckedOut = node == null || !node.isNodeType("mix:versionable") || node.isCheckedOut();
            this.isParentCheckedOut = stack.isCheckedOut();
        }

        public void ensureCheckedOut() throws RepositoryException {
            if (!this.isCheckedOut) {
                DocViewImporter.this.importInfo.registerToVersion(this.node.getPath());
                try {
                    this.node.checkout();
                }
                catch (RepositoryException e) {
                    log.warn("error while checkout node (ignored)", (Throwable)e);
                }
                this.isCheckedOut = true;
            }
            if (!this.isParentCheckedOut) {
                this.stack.ensureCheckedOut();
                this.isParentCheckedOut = true;
            }
        }
    }

    private static class BlobInfo {
        private final boolean isMulti;
        private final List<Artifact> artifacts = new ArrayList<Artifact>();

        public BlobInfo(boolean multi) {
            this.isMulti = multi;
        }

        public boolean isFile() {
            return !this.artifacts.isEmpty() && this.artifacts.get(0).getType() == ArtifactType.FILE;
        }

        public void add(Artifact a) {
            assert (this.artifacts.isEmpty());
            this.artifacts.add(a);
        }

        public void add(int idx, Artifact a) {
            while (idx >= this.artifacts.size()) {
                this.artifacts.add(null);
            }
            this.artifacts.set(idx, a);
        }

        public Value[] getValues(Session session) throws RepositoryException, IOException {
            Value[] values = new Value[this.artifacts.size()];
            for (int i = 0; i < values.length; ++i) {
                Artifact a = this.artifacts.get(i);
                try (InputStream input = a.getInputStream();){
                    values[i] = session.getValueFactory().createValue(input);
                    continue;
                }
            }
            return values;
        }

        public Value getValue(Session session) throws RepositoryException, IOException {
            Artifact a = this.artifacts.get(0);
            try (InputStream input = a.getInputStream();){
                Value value = session.getValueFactory().createValue(input);
                return value;
            }
        }

        public void detach() {
            for (Artifact a : this.artifacts) {
                if (!(a instanceof PropertyValueArtifact)) continue;
                try {
                    ((PropertyValueArtifact)a).detach();
                }
                catch (IOException | RepositoryException e) {
                    log.warn("error while detaching property artifact", (Throwable)e);
                }
            }
        }
    }

    private class StackElement {
        private final Node node;
        private StackElement parent;
        private final NodeNameList childNames = new NodeNameList();
        private boolean isCheckedOut;
        private boolean isNew;
        private DocViewAdapter adapter;

        public StackElement(Node node, boolean isNew) throws RepositoryException {
            this.node = node;
            this.isNew = isNew;
            this.isCheckedOut = node == null || !node.isNodeType("mix:versionable") || node.isCheckedOut();
        }

        public Node getNode() {
            return this.node;
        }

        public boolean isCheckedOut() {
            return this.isCheckedOut && (this.parent == null || this.parent.isCheckedOut());
        }

        public void ensureCheckedOut() throws RepositoryException {
            if (!this.isCheckedOut) {
                DocViewImporter.this.importInfo.registerToVersion(this.node.getPath());
                try {
                    this.node.checkout();
                }
                catch (RepositoryException e) {
                    log.warn("error while checkout node (ignored)", (Throwable)e);
                }
                this.isCheckedOut = true;
            }
            if (this.parent != null) {
                this.parent.ensureCheckedOut();
            }
        }

        public boolean isRoot() {
            return this.parent == null;
        }

        public boolean checkForNode() {
            return !this.isNew || this.parent == null;
        }

        public void addName(Name name) throws NamespaceException {
            this.childNames.addName(DocViewImporter.this.npResolver.getJCRName(name));
        }

        public NodeNameList getChildNames() {
            return this.childNames;
        }

        public void restoreOrder() throws RepositoryException {
            if (this.checkForNode() && this.childNames.needsReorder(this.node)) {
                this.ensureCheckedOut();
                this.childNames.restoreOrder(this.node);
            }
        }

        public StackElement push() throws RepositoryException {
            return this.push(new StackElement(null, false));
        }

        public StackElement push(StackElement elem) throws RepositoryException {
            elem.parent = this;
            return elem;
        }

        public StackElement pop() {
            return this.parent;
        }

        public DocViewAdapter getAdapter() {
            if (this.adapter != null) {
                return this.adapter;
            }
            return this.parent == null ? null : this.parent.getAdapter();
        }
    }
}

