/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.admin.internals;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.admin.FenceProducersOptions;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.admin.internals.AdminApiFuture;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.admin.internals.AdminApiHandler;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.admin.internals.AdminApiLookupStrategy;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.admin.internals.CoordinatorKey;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.admin.internals.CoordinatorStrategy;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.Node;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.errors.TransactionalIdAuthorizationException;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.message.InitProducerIdRequestData;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.Errors;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests.AbstractResponse;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests.InitProducerIdRequest;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests.InitProducerIdResponse;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.LogContext;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.ProducerIdAndEpoch;
import org.apache.skywalking.apm.dependencies.org.slf4j.Logger;

public class FenceProducersHandler
extends AdminApiHandler.Unbatched<CoordinatorKey, ProducerIdAndEpoch> {
    private final Logger log;
    private final AdminApiLookupStrategy<CoordinatorKey> lookupStrategy;
    private final int txnTimeoutMs;

    public FenceProducersHandler(FenceProducersOptions options, LogContext logContext, int requestTimeoutMs) {
        this.log = logContext.logger(FenceProducersHandler.class);
        this.lookupStrategy = new CoordinatorStrategy(FindCoordinatorRequest.CoordinatorType.TRANSACTION, logContext);
        this.txnTimeoutMs = options.timeoutMs() != null ? options.timeoutMs() : requestTimeoutMs;
    }

    public static AdminApiFuture.SimpleAdminApiFuture<CoordinatorKey, ProducerIdAndEpoch> newFuture(Collection<String> transactionalIds) {
        return AdminApiFuture.forKeys(FenceProducersHandler.buildKeySet(transactionalIds));
    }

    private static Set<CoordinatorKey> buildKeySet(Collection<String> transactionalIds) {
        return transactionalIds.stream().map(CoordinatorKey::byTransactionalId).collect(Collectors.toSet());
    }

    @Override
    public String apiName() {
        return "fenceProducer";
    }

    @Override
    public AdminApiLookupStrategy<CoordinatorKey> lookupStrategy() {
        return this.lookupStrategy;
    }

    InitProducerIdRequest.Builder buildSingleRequest(int brokerId, CoordinatorKey key) {
        if (key.type != FindCoordinatorRequest.CoordinatorType.TRANSACTION) {
            throw new IllegalArgumentException("Invalid group coordinator key " + key + " when building `InitProducerId` request");
        }
        InitProducerIdRequestData data = new InitProducerIdRequestData().setProducerEpoch(ProducerIdAndEpoch.NONE.epoch).setProducerId(ProducerIdAndEpoch.NONE.producerId).setTransactionalId(key.idValue).setTransactionTimeoutMs(this.txnTimeoutMs);
        return new InitProducerIdRequest.Builder(data);
    }

    @Override
    public AdminApiHandler.ApiResult<CoordinatorKey, ProducerIdAndEpoch> handleSingleResponse(Node broker, CoordinatorKey key, AbstractResponse abstractResponse) {
        InitProducerIdResponse response = (InitProducerIdResponse)abstractResponse;
        Errors error = Errors.forCode(response.data().errorCode());
        if (error != Errors.NONE) {
            return this.handleError(key, error);
        }
        Map<CoordinatorKey, ProducerIdAndEpoch> completed = Collections.singletonMap(key, new ProducerIdAndEpoch(response.data().producerId(), response.data().producerEpoch()));
        return new AdminApiHandler.ApiResult<CoordinatorKey, ProducerIdAndEpoch>(completed, Collections.emptyMap(), Collections.emptyList());
    }

    private AdminApiHandler.ApiResult<CoordinatorKey, ProducerIdAndEpoch> handleError(CoordinatorKey transactionalIdKey, Errors error) {
        switch (error) {
            case CLUSTER_AUTHORIZATION_FAILED: {
                return AdminApiHandler.ApiResult.failed(transactionalIdKey, new ClusterAuthorizationException("InitProducerId request for transactionalId `" + transactionalIdKey.idValue + "` failed due to cluster authorization failure"));
            }
            case TRANSACTIONAL_ID_AUTHORIZATION_FAILED: {
                return AdminApiHandler.ApiResult.failed(transactionalIdKey, new TransactionalIdAuthorizationException("InitProducerId request for transactionalId `" + transactionalIdKey.idValue + "` failed due to transactional ID authorization failure"));
            }
            case COORDINATOR_LOAD_IN_PROGRESS: {
                this.log.debug("InitProducerId request for transactionalId `{}` failed because the coordinator is still in the process of loading state. Will retry", (Object)transactionalIdKey.idValue);
                return AdminApiHandler.ApiResult.empty();
            }
            case CONCURRENT_TRANSACTIONS: {
                this.log.debug("InitProducerId request for transactionalId `{}` failed because of a concurrent transaction. Will retry", (Object)transactionalIdKey.idValue);
                return AdminApiHandler.ApiResult.empty();
            }
            case NOT_COORDINATOR: 
            case COORDINATOR_NOT_AVAILABLE: {
                this.log.debug("InitProducerId request for transactionalId `{}` returned error {}. Will attempt to find the coordinator again and retry", (Object)transactionalIdKey.idValue, (Object)error);
                return AdminApiHandler.ApiResult.unmapped(Collections.singletonList(transactionalIdKey));
            }
        }
        return AdminApiHandler.ApiResult.failed(transactionalIdKey, error.exception("InitProducerId request for transactionalId `" + transactionalIdKey.idValue + "` failed due to unexpected error"));
    }
}

