/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.activemq.artemis.jakarta.client;

import java.lang.reflect.Method;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.jms.client.ActiveMQMessage;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.AbstractTag;
import org.apache.skywalking.apm.agent.core.context.tag.StringTag;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.activemq.artemis.jakarta.client.define.EnhanceInfo;

public class MessageConsumerInterceptor
implements InstanceMethodsAroundInterceptor {
    private static final String OPERATION_NAME_PREFIX = "ActiveMQ/";
    private static final String CONSUMER_OPERATION_NAME_SUFFIX = "/Consumer";
    public static final StringTag MQ_MESSAGE_ID = new StringTag("mq.message.id");
    private static final String QUEUE = "Queue";
    private static final String TOPIC = "Topic";

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] classes, MethodInterceptResult methodInterceptResult) throws Throwable {
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] objects, Class<?>[] classes, Object ret) throws Throwable {
        ActiveMQMessage message = (ActiveMQMessage)ret;
        if (message == null) {
            return ret;
        }
        ContextCarrier contextCarrier = this.getContextCarrierFromMessage(message);
        EnhanceInfo enhanceInfo = (EnhanceInfo)objInst.getSkyWalkingDynamicField();
        boolean queue = this.isQueue(enhanceInfo.getType());
        AbstractSpan activeSpan = ContextManager.createEntrySpan((String)this.buildOperationName(queue, enhanceInfo.getName()), (ContextCarrier)contextCarrier);
        Tags.MQ_BROKER.set(activeSpan, enhanceInfo.getBrokerUrl());
        if (queue) {
            Tags.MQ_QUEUE.set(activeSpan, enhanceInfo.getName());
        } else {
            Tags.MQ_TOPIC.set(activeSpan, enhanceInfo.getName());
        }
        activeSpan.tag((AbstractTag)MQ_MESSAGE_ID, message.getJMSMessageID());
        activeSpan.setPeer(enhanceInfo.getBrokerUrl());
        activeSpan.setComponent((Component)ComponentsDefine.ACTIVEMQ_CONSUMER);
        SpanLayer.asMQ((AbstractSpan)activeSpan);
        ContextManager.stopSpan((AbstractSpan)activeSpan);
        return ret;
    }

    public void handleMethodException(EnhancedInstance enhancedInstance, Method method, Object[] objects, Class<?>[] classes, Throwable t) {
        ContextManager.activeSpan().log(t);
    }

    private ContextCarrier getContextCarrierFromMessage(ActiveMQMessage message) {
        ContextCarrier contextCarrier = new ContextCarrier();
        CarrierItem next = contextCarrier.items();
        while (next.hasNext()) {
            next = next.next();
            next.setHeadValue(message.getCoreMessage().getStringProperty(next.getHeadKey().replace("-", "_")));
        }
        return contextCarrier;
    }

    private boolean isQueue(ActiveMQDestination.TYPE type) {
        return ActiveMQDestination.TYPE.QUEUE.equals((Object)type) || ActiveMQDestination.TYPE.TEMP_QUEUE.equals((Object)type);
    }

    private String buildOperationName(boolean isQueue, String name) {
        if (isQueue) {
            return "ActiveMQ/Queue/" + name + CONSUMER_OPERATION_NAME_SUFFIX;
        }
        return "ActiveMQ/Topic/" + name + CONSUMER_OPERATION_NAME_SUFFIX;
    }
}

