/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.asyncprofiler;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.skywalking.apm.agent.core.asyncprofiler.AsyncProfilerDataSender;
import org.apache.skywalking.apm.agent.core.asyncprofiler.AsyncProfilerTask;
import org.apache.skywalking.apm.agent.core.asyncprofiler.AsyncProfilerTaskChannelService;
import org.apache.skywalking.apm.agent.core.boot.BootService;
import org.apache.skywalking.apm.agent.core.boot.DefaultImplementor;
import org.apache.skywalking.apm.agent.core.boot.DefaultNamedThreadFactory;
import org.apache.skywalking.apm.agent.core.boot.ServiceManager;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.dependencies.one.profiler.AsyncProfiler;

@DefaultImplementor
public class AsyncProfilerTaskExecutionService
implements BootService {
    private static final ILog LOGGER = LogManager.getLogger(AsyncProfilerTaskChannelService.class);
    private AsyncProfiler asyncProfilerInstance;
    private static final String SUCCESS_RESULT = "Profiling started\n";
    private volatile ScheduledExecutorService asyncProfilerExecutor;
    private volatile long lastCommandCreateTime = -1L;
    private volatile ScheduledFuture<?> scheduledFuture;

    public void processAsyncProfilerTask(AsyncProfilerTask task) {
        if (task.getCreateTime() <= this.lastCommandCreateTime) {
            LOGGER.warn("get repeat task because createTime is less than lastCommandCreateTime", new Object[0]);
            return;
        }
        this.lastCommandCreateTime = task.getCreateTime();
        LOGGER.info("add async profiler task: {}", task.getTaskId());
        this.getAsyncProfilerExecutor().execute(() -> {
            try {
                if (Objects.nonNull(this.scheduledFuture) && !this.scheduledFuture.isDone()) {
                    LOGGER.info("AsyncProfilerTask already running");
                    return;
                }
                String result = task.start(this.getAsyncProfiler());
                if (!SUCCESS_RESULT.equals(result)) {
                    this.stopWhenError(task, result);
                    return;
                }
                this.scheduledFuture = this.getAsyncProfilerExecutor().schedule(() -> this.stopWhenSuccess(task), (long)task.getDuration(), TimeUnit.SECONDS);
            }
            catch (IOException e) {
                LOGGER.error("AsyncProfilerTask executor error:" + e.getMessage(), e);
            }
        });
    }

    private void stopWhenError(AsyncProfilerTask task, String errorMessage) {
        LOGGER.error("AsyncProfilerTask fails to start: " + errorMessage);
        AsyncProfilerDataSender dataSender = ServiceManager.INSTANCE.findService(AsyncProfilerDataSender.class);
        dataSender.sendError(task, errorMessage);
    }

    private void stopWhenSuccess(AsyncProfilerTask task) {
        try {
            File dumpFile = task.stop(this.getAsyncProfiler());
            if (dumpFile != null && dumpFile.exists()) {
                AsyncProfilerDataSender dataSender = ServiceManager.INSTANCE.findService(AsyncProfilerDataSender.class);
                dataSender.sendData(task, dumpFile);
                if (!dumpFile.delete()) {
                    LOGGER.warn("Fail to delete the dump file of async profiler.", new Object[0]);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("stop async profiler task error", e);
            return;
        }
    }

    public long getLastCommandCreateTime() {
        return this.lastCommandCreateTime;
    }

    @Override
    public void prepare() throws Throwable {
    }

    @Override
    public void boot() throws Throwable {
    }

    @Override
    public void onComplete() throws Throwable {
    }

    @Override
    public void shutdown() throws Throwable {
        this.getAsyncProfilerExecutor().shutdown();
        if (Objects.nonNull(this.scheduledFuture)) {
            this.scheduledFuture.cancel(true);
            this.scheduledFuture = null;
        }
    }

    private AsyncProfiler getAsyncProfiler() {
        if (this.asyncProfilerInstance == null) {
            this.asyncProfilerInstance = AsyncProfiler.getInstance();
        }
        return this.asyncProfilerInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScheduledExecutorService getAsyncProfilerExecutor() {
        if (this.asyncProfilerExecutor == null) {
            AsyncProfilerTaskExecutionService asyncProfilerTaskExecutionService = this;
            synchronized (asyncProfilerTaskExecutionService) {
                if (this.asyncProfilerExecutor == null) {
                    this.asyncProfilerExecutor = Executors.newSingleThreadScheduledExecutor(new DefaultNamedThreadFactory("ASYNC-PROFILING-TASK"));
                }
            }
        }
        return this.asyncProfilerExecutor;
    }
}

