/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.bytebuddy;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.description.method.MethodDescription;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.description.type.TypeDefinition;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.description.type.TypeDescription;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.dynamic.scaffold.MethodGraph;

public class SWMethodGraphCompilerDelegate
implements MethodGraph.Compiler {
    private MethodGraph.Compiler originCompiler;

    public SWMethodGraphCompilerDelegate(MethodGraph.Compiler originCompiler) {
        this.originCompiler = originCompiler;
    }

    @Override
    public MethodGraph.Linked compile(TypeDefinition typeDefinition) {
        MethodGraph.Linked methodGraph = this.originCompiler.compile(typeDefinition);
        return new SWMethodGraph(methodGraph);
    }

    @Override
    @Deprecated
    public MethodGraph.Linked compile(TypeDescription typeDescription) {
        return this.originCompiler.compile(typeDescription);
    }

    @Override
    public MethodGraph.Linked compile(TypeDefinition typeDefinition, TypeDescription viewPoint) {
        return this.originCompiler.compile(typeDefinition, viewPoint);
    }

    @Override
    @Deprecated
    public MethodGraph.Linked compile(TypeDescription typeDefinition, TypeDescription viewPoint) {
        return this.originCompiler.compile(typeDefinition, viewPoint);
    }

    static class SWMethodGraph
    implements MethodGraph.Linked {
        private MethodGraph.Linked origin;

        public SWMethodGraph(MethodGraph.Linked origin) {
            this.origin = origin;
        }

        @Override
        public MethodGraph getSuperClassGraph() {
            return this.origin.getSuperClassGraph();
        }

        @Override
        public MethodGraph getInterfaceGraph(TypeDescription typeDescription) {
            return this.origin.getInterfaceGraph(typeDescription);
        }

        @Override
        public MethodGraph.Node locate(MethodDescription.SignatureToken token) {
            return this.origin.locate(token);
        }

        @Override
        public MethodGraph.NodeList listNodes() {
            MethodGraph.NodeList nodeList = this.origin.listNodes();
            List nodes = nodeList.stream().map(n -> new Pair<Integer, MethodGraph.Node>(n.getRepresentative().hashCode(), (MethodGraph.Node)n)).sorted(Comparator.comparing(p -> (Integer)((Pair)p).first)).map(p -> (MethodGraph.Node)((Pair)p).second).collect(Collectors.toList());
            return new MethodGraph.NodeList(nodes);
        }
    }

    static class Pair<T, V> {
        private T first;
        private V second;

        public Pair(T first, V second) {
            this.first = first;
            this.second = second;
        }
    }
}

