/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.rocketMQ.v4;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.rocketMQ.v4.define.ConsumerEnhanceInfos;

public abstract class AbstractMessageConsumeInterceptor
implements InstanceMethodsAroundInterceptor {
    public static final String CONSUMER_OPERATION_NAME_PREFIX = "RocketMQ/";

    public final void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        List msgs = (List)allArguments[0];
        ContextCarrier contextCarrier = this.getContextCarrierFromMessage((MessageExt)msgs.get(0));
        AbstractSpan span = ContextManager.createEntrySpan((String)(CONSUMER_OPERATION_NAME_PREFIX + ((MessageExt)msgs.get(0)).getTopic() + "/Consumer"), (ContextCarrier)contextCarrier);
        Tags.MQ_TOPIC.set(span, ((MessageExt)msgs.get(0)).getTopic());
        if (((MessageExt)msgs.get(0)).getStoreHost() != null) {
            String brokerAddress = ((MessageExt)msgs.get(0)).getStoreHost().toString();
            brokerAddress = StringUtils.removeStart((String)brokerAddress, (String)"/");
            Tags.MQ_BROKER.set(span, brokerAddress);
        }
        span.setComponent((Component)ComponentsDefine.ROCKET_MQ_CONSUMER);
        SpanLayer.asMQ((AbstractSpan)span);
        for (int i = 1; i < msgs.size(); ++i) {
            ContextManager.extract((ContextCarrier)this.getContextCarrierFromMessage((MessageExt)msgs.get(i)));
        }
        Object skyWalkingDynamicField = objInst.getSkyWalkingDynamicField();
        if (skyWalkingDynamicField != null) {
            ConsumerEnhanceInfos consumerEnhanceInfos = (ConsumerEnhanceInfos)skyWalkingDynamicField;
            span.setPeer(consumerEnhanceInfos.getNamesrvAddr());
        }
    }

    public final void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().log(t);
    }

    private ContextCarrier getContextCarrierFromMessage(MessageExt message) {
        ContextCarrier contextCarrier = new ContextCarrier();
        CarrierItem next = contextCarrier.items();
        while (next.hasNext()) {
            next = next.next();
            next.setHeadValue(message.getUserProperty(next.getHeadKey()));
        }
        return contextCarrier;
    }
}

