/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.httpclient.v5;

import java.lang.reflect.Method;
import java.net.URI;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.apache.hc.core5.http.nio.command.RequestExecutionCommand;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.reactor.Command;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.httpclient.v5.Constants;

public class IOSessionImplPollInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        Command command = (Command)ret;
        if (!(command instanceof RequestExecutionCommand)) {
            return ret;
        }
        HttpContext httpContext = ((RequestExecutionCommand)command).getContext();
        ContextSnapshot snapshot = (ContextSnapshot)httpContext.getAttribute(Constants.SKYWALKING_CONTEXT_SNAPSHOT);
        if (snapshot == null) {
            return ret;
        }
        httpContext.removeAttribute(Constants.SKYWALKING_CONTEXT_SNAPSHOT);
        AbstractSpan localSpan = ContextManager.createLocalSpan((String)"httpasyncclient/local");
        localSpan.setComponent((Component)ComponentsDefine.HTTP_ASYNC_CLIENT);
        localSpan.setLayer(SpanLayer.HTTP);
        ContextManager.continued((ContextSnapshot)snapshot);
        ContextCarrier contextCarrier = new ContextCarrier();
        BasicHttpRequest request = (BasicHttpRequest)httpContext.getAttribute("http.request");
        URI uri = request.getUri();
        String operationName = uri.getPath();
        int port = uri.getPort();
        AbstractSpan span = ContextManager.createExitSpan((String)operationName, (ContextCarrier)contextCarrier, (String)(uri.getHost() + ":" + (port == -1 ? 80 : port)));
        span.setComponent((Component)ComponentsDefine.HTTP_ASYNC_CLIENT);
        Tags.URL.set(span, uri.toURL().toString());
        Tags.HTTP.METHOD.set(span, request.getMethod());
        SpanLayer.asHttp((AbstractSpan)span);
        CarrierItem next = contextCarrier.items();
        while (next.hasNext()) {
            next = next.next();
            request.setHeader(next.getHeadKey(), (Object)next.getHeadValue());
        }
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
    }
}

