/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.library.elasticsearch.requests.factory.v7plus.codec;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.apache.skywalking.library.elasticsearch.response.Mappings;

final class V7MappingsDeserializer
extends JsonDeserializer<Mappings> {
    V7MappingsDeserializer() {
    }

    public Mappings deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        Map m = (Map)p.getCodec().readValue(p, (TypeReference)new TypeReference<Map<String, Object>>(){});
        if (m.size() > 0) {
            Object excludes;
            Map properties = (Map)m.get("properties");
            Map source = (Map)m.get("_source");
            Mappings mappings = new Mappings();
            mappings.setType("_doc");
            if (properties != null) {
                mappings.setProperties(properties);
            }
            if (source != null && (excludes = source.get("excludes")) != null) {
                mappings.getSource().setExcludes(new HashSet<String>((ArrayList)excludes));
            }
            return mappings;
        }
        return null;
    }
}

