/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base;

import com.google.gson.Gson;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.skywalking.library.elasticsearch.requests.search.Search;
import org.apache.skywalking.library.elasticsearch.requests.search.SearchParams;
import org.apache.skywalking.library.elasticsearch.response.Documents;
import org.apache.skywalking.library.elasticsearch.response.search.SearchResponse;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingSpan;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingTraceContext;
import org.apache.skywalking.oap.server.core.storage.AbstractDAO;
import org.apache.skywalking.oap.server.library.client.Client;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchScroller;

public abstract class EsDAO
extends AbstractDAO<ElasticSearchClient> {
    protected static final Duration SCROLL_CONTEXT_RETENTION = Duration.ofSeconds(30L);

    public EsDAO(ElasticSearchClient client) {
        super((Client)client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SearchResponse searchDebuggable(Supplier<String[]> indices, Search search) {
        SearchResponse searchResponse;
        block5: {
            DebuggingTraceContext traceContext = (DebuggingTraceContext)DebuggingTraceContext.TRACE_CONTEXT.get();
            DebuggingSpan span = null;
            try {
                StringBuilder builder = new StringBuilder();
                if (traceContext != null) {
                    span = traceContext.createSpan("Query Elasticsearch: search");
                    builder.append("Condition: ").append("indices: ").append(Arrays.toString(indices.get()));
                    span.setMsg(builder.toString());
                }
                SearchResponse response = ((ElasticSearchClient)this.getClient()).search(indices, search);
                if (traceContext != null && traceContext.isDumpStorageRsp()) {
                    builder.append("\n").append(" Response: ").append(new Gson().toJson((Object)response));
                    span.setMsg(builder.toString());
                }
                searchResponse = response;
                if (traceContext == null || span == null) break block5;
            }
            catch (Throwable throwable) {
                if (traceContext != null && span != null) {
                    traceContext.stopSpan(span);
                }
                throw throwable;
            }
            traceContext.stopSpan(span);
        }
        return searchResponse;
    }

    protected SearchResponse searchDebuggable(String indexName, Search search) {
        return this.searchDebuggable(indexName, search, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SearchResponse searchDebuggable(String indexName, Search search, SearchParams params) {
        SearchResponse searchResponse;
        block5: {
            DebuggingTraceContext traceContext = (DebuggingTraceContext)DebuggingTraceContext.TRACE_CONTEXT.get();
            DebuggingSpan span = null;
            try {
                SearchResponse response;
                StringBuilder builder = new StringBuilder();
                if (traceContext != null) {
                    span = traceContext.createSpan("Query Elasticsearch");
                    builder.append("Condition: ").append("indices: ").append(indexName).append(", params: ").append(params);
                    span.setMsg(builder.toString());
                }
                SearchResponse searchResponse2 = response = params == null ? ((ElasticSearchClient)this.getClient()).search(indexName, search) : ((ElasticSearchClient)this.getClient()).search(indexName, search, params);
                if (traceContext != null && traceContext.isDumpStorageRsp()) {
                    builder.append("\n").append(" Response: ").append(new Gson().toJson((Object)response));
                    span.setMsg(builder.toString());
                }
                searchResponse = response;
                if (traceContext == null || span == null) break block5;
            }
            catch (Throwable throwable) {
                if (traceContext != null && span != null) {
                    traceContext.stopSpan(span);
                }
                throw throwable;
            }
            traceContext.stopSpan(span);
        }
        return searchResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Optional<Documents> idsDebuggable(Map<String, List<String>> indexIdsGroup) {
        Optional optional;
        block5: {
            DebuggingTraceContext traceContext = (DebuggingTraceContext)DebuggingTraceContext.TRACE_CONTEXT.get();
            DebuggingSpan span = null;
            try {
                StringBuilder builder = new StringBuilder();
                if (traceContext != null) {
                    span = traceContext.createSpan("Query Elasticsearch: ids");
                    builder.append("Condition: ").append("indices: ").append(indexIdsGroup.keySet());
                    span.setMsg(builder.toString());
                }
                Optional response = ((ElasticSearchClient)this.getClient()).ids(indexIdsGroup);
                if (traceContext != null && traceContext.isDumpStorageRsp()) {
                    builder.append("\n").append(" Response: ").append(response.isPresent() ? new Gson().toJson(response.get()) : "null");
                    span.setMsg(builder.toString());
                }
                optional = response;
                if (traceContext == null || span == null) break block5;
            }
            catch (Throwable throwable) {
                if (traceContext != null && span != null) {
                    traceContext.stopSpan(span);
                }
                throw throwable;
            }
            traceContext.stopSpan(span);
        }
        return optional;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> List<T> scrollDebuggable(ElasticSearchScroller<T> scroller, String index, SearchParams params) {
        List list;
        block5: {
            DebuggingTraceContext traceContext = (DebuggingTraceContext)DebuggingTraceContext.TRACE_CONTEXT.get();
            DebuggingSpan span = null;
            try {
                StringBuilder builder = new StringBuilder();
                if (traceContext != null) {
                    span = traceContext.createSpan("Query Elasticsearch: scroll");
                    builder.append("Condition: ").append("index: ").append(index).append(", params: ").append(params);
                    span.setMsg(builder.toString());
                }
                List response = scroller.scroll();
                if (traceContext != null && traceContext.isDumpStorageRsp()) {
                    builder.append("\n").append(" Response: ").append(new Gson().toJson((Object)response));
                    span.setMsg(builder.toString());
                }
                list = response;
                if (traceContext == null || span == null) break block5;
            }
            catch (Throwable throwable) {
                if (traceContext != null && span != null) {
                    traceContext.stopSpan(span);
                }
                throw throwable;
            }
            traceContext.stopSpan(span);
        }
        return list;
    }
}

