/*
 * Decompiled with CFR 0.152.
 */
package graphql.parser;

import graphql.Internal;
import graphql.language.SourceLocation;
import graphql.org.antlr.v4.runtime.Token;
import graphql.org.antlr.v4.runtime.tree.TerminalNode;
import graphql.parser.MultiSourceReader;
import java.util.List;

@Internal
public class AntlrHelper {
    public static SourceLocation createSourceLocation(MultiSourceReader multiSourceReader, int antrlLine, int charPositionInLine) {
        int tokenLine = antrlLine - 1;
        MultiSourceReader.SourceAndLine sourceAndLine = multiSourceReader.getSourceAndLineFromOverallLine(tokenLine);
        int line = sourceAndLine.getLine() + 1;
        int column = charPositionInLine + 1;
        return new SourceLocation(line, column, sourceAndLine.getSourceName());
    }

    public static SourceLocation createSourceLocation(MultiSourceReader multiSourceReader, Token token) {
        return AntlrHelper.createSourceLocation(multiSourceReader, token.getLine(), token.getCharPositionInLine());
    }

    public static SourceLocation createSourceLocation(MultiSourceReader multiSourceReader, TerminalNode terminalNode) {
        return AntlrHelper.createSourceLocation(multiSourceReader, terminalNode.getSymbol().getLine(), terminalNode.getSymbol().getCharPositionInLine());
    }

    public static String createPreview(MultiSourceReader multiSourceReader, int antrlLine) {
        int line = antrlLine - 1;
        StringBuilder sb = new StringBuilder();
        int startLine = line - 3;
        int endLine = line + 3;
        List<String> lines = multiSourceReader.getData();
        for (int i = 0; i < lines.size(); ++i) {
            if (i < startLine || i > endLine) continue;
            sb.append(lines.get(i)).append('\n');
        }
        return sb.toString();
    }
}

