/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.Internal;
import graphql.execution.FieldCollectorParameters;
import graphql.execution.MergedField;
import graphql.execution.MergedSelectionSet;
import graphql.execution.TypeFromAST;
import graphql.execution.conditional.ConditionalNodes;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLUnionType;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Internal
public class FieldCollector {
    private final ConditionalNodes conditionalNodes = new ConditionalNodes();

    public MergedSelectionSet collectFields(FieldCollectorParameters parameters, MergedField mergedField) {
        LinkedHashMap<String, MergedField> subFields = new LinkedHashMap<String, MergedField>();
        LinkedHashSet<String> visitedFragments = new LinkedHashSet<String>();
        for (Field field : mergedField.getFields()) {
            if (field.getSelectionSet() == null) continue;
            this.collectFields(parameters, field.getSelectionSet(), visitedFragments, subFields);
        }
        return MergedSelectionSet.newMergedSelectionSet().subFields(subFields).build();
    }

    public MergedSelectionSet collectFields(FieldCollectorParameters parameters, SelectionSet selectionSet) {
        LinkedHashMap<String, MergedField> subFields = new LinkedHashMap<String, MergedField>();
        LinkedHashSet<String> visitedFragments = new LinkedHashSet<String>();
        this.collectFields(parameters, selectionSet, visitedFragments, subFields);
        return MergedSelectionSet.newMergedSelectionSet().subFields(subFields).build();
    }

    private void collectFields(FieldCollectorParameters parameters, SelectionSet selectionSet, Set<String> visitedFragments, Map<String, MergedField> fields) {
        for (Selection selection : selectionSet.getSelections()) {
            if (selection instanceof Field) {
                this.collectField(parameters, fields, (Field)selection);
                continue;
            }
            if (selection instanceof InlineFragment) {
                this.collectInlineFragment(parameters, visitedFragments, fields, (InlineFragment)selection);
                continue;
            }
            if (!(selection instanceof FragmentSpread)) continue;
            this.collectFragmentSpread(parameters, visitedFragments, fields, (FragmentSpread)selection);
        }
    }

    private void collectFragmentSpread(FieldCollectorParameters parameters, Set<String> visitedFragments, Map<String, MergedField> fields, FragmentSpread fragmentSpread) {
        if (visitedFragments.contains(fragmentSpread.getName())) {
            return;
        }
        if (!this.conditionalNodes.shouldInclude(fragmentSpread, parameters.getVariables(), parameters.getGraphQLSchema(), parameters.getGraphQLContext())) {
            return;
        }
        visitedFragments.add(fragmentSpread.getName());
        FragmentDefinition fragmentDefinition = parameters.getFragmentsByName().get(fragmentSpread.getName());
        if (!this.conditionalNodes.shouldInclude(fragmentDefinition, parameters.getVariables(), parameters.getGraphQLSchema(), parameters.getGraphQLContext())) {
            return;
        }
        if (!this.doesFragmentConditionMatch(parameters, fragmentDefinition)) {
            return;
        }
        this.collectFields(parameters, fragmentDefinition.getSelectionSet(), visitedFragments, fields);
    }

    private void collectInlineFragment(FieldCollectorParameters parameters, Set<String> visitedFragments, Map<String, MergedField> fields, InlineFragment inlineFragment) {
        if (!this.conditionalNodes.shouldInclude(inlineFragment, parameters.getVariables(), parameters.getGraphQLSchema(), parameters.getGraphQLContext()) || !this.doesFragmentConditionMatch(parameters, inlineFragment)) {
            return;
        }
        this.collectFields(parameters, inlineFragment.getSelectionSet(), visitedFragments, fields);
    }

    private void collectField(FieldCollectorParameters parameters, Map<String, MergedField> fields, Field field) {
        if (!this.conditionalNodes.shouldInclude(field, parameters.getVariables(), parameters.getGraphQLSchema(), parameters.getGraphQLContext())) {
            return;
        }
        String name = field.getResultKey();
        if (fields.containsKey(name)) {
            MergedField curFields = fields.get(name);
            fields.put(name, curFields.transform(builder -> builder.addField(field)));
        } else {
            fields.put(name, MergedField.newMergedField(field).build());
        }
    }

    private boolean doesFragmentConditionMatch(FieldCollectorParameters parameters, InlineFragment inlineFragment) {
        if (inlineFragment.getTypeCondition() == null) {
            return true;
        }
        GraphQLType conditionType = TypeFromAST.getTypeFromAST(parameters.getGraphQLSchema(), inlineFragment.getTypeCondition());
        return this.checkTypeCondition(parameters, conditionType);
    }

    private boolean doesFragmentConditionMatch(FieldCollectorParameters parameters, FragmentDefinition fragmentDefinition) {
        GraphQLType conditionType = TypeFromAST.getTypeFromAST(parameters.getGraphQLSchema(), fragmentDefinition.getTypeCondition());
        return this.checkTypeCondition(parameters, conditionType);
    }

    private boolean checkTypeCondition(FieldCollectorParameters parameters, GraphQLType conditionType) {
        GraphQLObjectType type = parameters.getObjectType();
        if (conditionType.equals(type)) {
            return true;
        }
        if (conditionType instanceof GraphQLInterfaceType) {
            List<GraphQLObjectType> implementations = parameters.getGraphQLSchema().getImplementations((GraphQLInterfaceType)conditionType);
            return implementations.contains(type);
        }
        if (conditionType instanceof GraphQLUnionType) {
            return ((GraphQLUnionType)conditionType).getTypes().contains(type);
        }
        return false;
    }
}

