/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.docs;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpHeadersBuilder;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.ServerCacheControl;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.ThreadFactories;
import com.linecorp.armeria.common.util.UnmodifiableFuture;
import com.linecorp.armeria.common.util.Version;
import com.linecorp.armeria.internal.shaded.futures.CompletableFutures;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableListMultimap;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.internal.shaded.guava.collect.ListMultimap;
import com.linecorp.armeria.internal.shaded.guava.collect.Multimap;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.ServerConfig;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.SimpleDecoratingHttpService;
import com.linecorp.armeria.server.VirtualHost;
import com.linecorp.armeria.server.docs.DescriptiveTypeInfo;
import com.linecorp.armeria.server.docs.DescriptiveTypeInfoProvider;
import com.linecorp.armeria.server.docs.DocServiceBuilder;
import com.linecorp.armeria.server.docs.DocServiceFilter;
import com.linecorp.armeria.server.docs.DocServicePlugin;
import com.linecorp.armeria.server.docs.DocStringSupport;
import com.linecorp.armeria.server.docs.ExampleSupport;
import com.linecorp.armeria.server.docs.JsonSchemaGenerator;
import com.linecorp.armeria.server.docs.ServiceSpecification;
import com.linecorp.armeria.server.file.AbstractHttpVfs;
import com.linecorp.armeria.server.file.AggregatedHttpFile;
import com.linecorp.armeria.server.file.FileService;
import com.linecorp.armeria.server.file.HttpFile;
import com.linecorp.armeria.server.file.HttpFileAttributes;
import com.linecorp.armeria.server.file.HttpFileBuilder;
import com.linecorp.armeria.server.file.HttpVfs;
import com.linecorp.armeria.server.file.MediaTypeResolver;
import java.time.Clock;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DocService
extends SimpleDecoratingHttpService {
    private static final Logger logger = LoggerFactory.getLogger(DocService.class);
    private static final ObjectMapper jsonMapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_ABSENT);
    static final List<DocServicePlugin> plugins = ImmutableList.copyOf(ServiceLoader.load(DocServicePlugin.class, DocService.class.getClassLoader()));
    static final List<DescriptiveTypeInfoProvider> SPI_DESCRIPTIVE_TYPE_INFO_PROVIDERS = ImmutableList.copyOf(ServiceLoader.load(DescriptiveTypeInfoProvider.class, DocService.class.getClassLoader()));
    private final List<BiFunction<ServiceRequestContext, HttpRequest, String>> injectedScriptSuppliers;
    @Nullable
    private Server server;

    public static DocServiceBuilder builder() {
        return new DocServiceBuilder();
    }

    public DocService() {
        this(ImmutableMap.of(), ImmutableMap.of(), ImmutableMap.of(), ImmutableMap.of(), ImmutableList.of(), DocServiceBuilder.ALL_SERVICES, null);
    }

    DocService(Map<String, ListMultimap<String, HttpHeaders>> exampleHeaders, Map<String, ListMultimap<String, String>> exampleRequests, Map<String, ListMultimap<String, String>> examplePaths, Map<String, ListMultimap<String, String>> exampleQueries, List<BiFunction<ServiceRequestContext, HttpRequest, String>> injectedScriptSuppliers, DocServiceFilter filter, @Nullable DescriptiveTypeInfoProvider descriptiveTypeInfoProvider) {
        this(new ExampleSupport(DocService.immutableCopyOf(exampleHeaders, "exampleHeaders"), DocService.immutableCopyOf(exampleRequests, "exampleRequests"), DocService.immutableCopyOf(examplePaths, "examplePaths"), DocService.immutableCopyOf(exampleQueries, "exampleQueries")), injectedScriptSuppliers, filter, descriptiveTypeInfoProvider);
    }

    private DocService(ExampleSupport exampleSupport, List<BiFunction<ServiceRequestContext, HttpRequest, String>> injectedScriptSuppliers, DocServiceFilter filter, @Nullable DescriptiveTypeInfoProvider descriptiveTypeInfoProvider) {
        this(new SpecificationLoader(exampleSupport, filter, descriptiveTypeInfoProvider), injectedScriptSuppliers);
    }

    private DocService(SpecificationLoader specificationLoader, List<BiFunction<ServiceRequestContext, HttpRequest, String>> injectedScriptSuppliers) {
        super(FileService.builder(new DocServiceVfs(specificationLoader)).serveCompressedFiles(true).autoDecompress(true).build());
        this.injectedScriptSuppliers = Objects.requireNonNull(injectedScriptSuppliers, "injectedScriptSuppliers");
    }

    private static <T> Map<String, ListMultimap<String, T>> immutableCopyOf(Map<String, ListMultimap<String, T>> map, String name) {
        Objects.requireNonNull(map, name);
        return map.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> ImmutableListMultimap.copyOf((Multimap)e.getValue())));
    }

    @Override
    public void serviceAdded(ServiceConfig cfg) throws Exception {
        super.serviceAdded(cfg);
        if (this.server != null) {
            if (this.server != cfg.server()) {
                throw new IllegalStateException("cannot be added to more than one server");
            }
            return;
        }
        this.server = cfg.server();
        ServerConfig config = this.server.config();
        List<VirtualHost> virtualHosts = config.findVirtualHosts(this);
        List services = config.serviceConfigs().stream().filter(se -> virtualHosts.contains(se.virtualHost())).collect(ImmutableList.toImmutableList());
        ExecutorService executorService = Executors.newSingleThreadExecutor(ThreadFactories.newThreadFactory("docservice-loader", true));
        this.vfs().specificationLoader.updateServices(services, cfg.route(), executorService).handle((res, e) -> {
            if (e != null) {
                logger.warn("Failed to load specifications completely: ", (Throwable)e);
            }
            executorService.shutdown();
            return null;
        });
    }

    private DocServiceVfs vfs() {
        return (DocServiceVfs)((FileService)this.unwrap()).config().vfs();
    }

    static Set<ServiceConfig> findSupportedServices(DocServicePlugin plugin, List<ServiceConfig> services) {
        Set<Class<? extends Service<?, ?>>> supportedServiceTypes = plugin.supportedServiceTypes();
        return services.stream().filter(serviceCfg -> DocService.isSupported(serviceCfg, supportedServiceTypes)).collect(ImmutableSet.toImmutableSet());
    }

    private static boolean isSupported(ServiceConfig serviceCfg, Set<Class<? extends Service<?, ?>>> supportedServiceTypes) {
        return supportedServiceTypes.stream().anyMatch(type -> serviceCfg.service().as(type) != null);
    }

    @Override
    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        if ("/injected.js".equals(ctx.mappedPath())) {
            return HttpResponse.of(MediaType.JAVASCRIPT_UTF_8, this.injectedScriptSuppliers.stream().map(f -> (String)f.apply(ctx, req)).collect(Collectors.joining("\n")));
        }
        return (HttpResponse)((Service)this.unwrap()).serve(ctx, req);
    }

    static {
        logger.debug("Available {}s: {}", (Object)DocServicePlugin.class.getSimpleName(), (Object)plugins);
        logger.debug("Available {}s: {}", (Object)DescriptiveTypeInfoProvider.class.getSimpleName(), (Object)SPI_DESCRIPTIVE_TYPE_INFO_PROVIDERS);
    }

    static final class SpecificationLoader {
        private static final String VERSIONS_PATH = "/versions.json";
        private static final String SPECIFICATION_PATH = "/specification.json";
        private static final String SCHEMAS_PATH = "/schemas.json";
        private static final Set<String> TARGET_PATHS = ImmutableSet.of("/versions.json", "/specification.json", "/schemas.json");
        private static final CompletableFuture<AggregatedHttpFile> loadFailedFuture = UnmodifiableFuture.exceptionallyCompletedFuture(new IllegalStateException("File load not triggered"));
        private final ExampleSupport exampleSupport;
        private final DocServiceFilter filter;
        private final DescriptiveTypeInfoProvider descriptiveTypeInfoProvider;
        private final Map<String, CompletableFuture<AggregatedHttpFile>> files = new ConcurrentHashMap<String, CompletableFuture<AggregatedHttpFile>>();
        private List<ServiceConfig> services = Collections.emptyList();

        SpecificationLoader(ExampleSupport exampleSupport, DocServiceFilter filter, @Nullable DescriptiveTypeInfoProvider descriptiveTypeInfoProvider) {
            this.exampleSupport = exampleSupport;
            this.filter = filter;
            this.descriptiveTypeInfoProvider = SpecificationLoader.composeDescriptiveTypeInfoProvider(descriptiveTypeInfoProvider);
        }

        boolean contains(String path) {
            return TARGET_PATHS.contains(path);
        }

        CompletableFuture<List<AggregatedHttpFile>> updateServices(List<ServiceConfig> services, Route docServiceRoute, Executor executor) {
            this.services = services;
            CompletableFuture<ServiceSpecification> serviceSpecificationFuture = this.generateServiceSpecification(executor, docServiceRoute);
            List files = TARGET_PATHS.stream().map(path -> this.load((String)path, executor, serviceSpecificationFuture)).collect(ImmutableList.toImmutableList());
            return CompletableFutures.allAsList(files);
        }

        CompletableFuture<AggregatedHttpFile> get(String path) {
            assert (TARGET_PATHS.contains(path));
            return this.files.getOrDefault(path, loadFailedFuture);
        }

        private CompletableFuture<AggregatedHttpFile> load(String path, Executor executor, CompletableFuture<ServiceSpecification> serviceSpecificationFuture) {
            if (VERSIONS_PATH.equals(path)) {
                return this.loadVersions(executor);
            }
            if (SPECIFICATION_PATH.equals(path)) {
                return this.loadSpecifications(serviceSpecificationFuture);
            }
            if (SCHEMAS_PATH.equals(path)) {
                return this.loadSchemas(serviceSpecificationFuture);
            }
            throw new Error();
        }

        private CompletableFuture<AggregatedHttpFile> loadVersions(Executor executor) {
            return this.files.computeIfAbsent(VERSIONS_PATH, key -> CompletableFuture.supplyAsync(() -> {
                ImmutableList<Version> versions = ImmutableList.copyOf(Version.getAll(DocService.class.getClassLoader()).values());
                try {
                    byte[] content = jsonMapper.writerWithDefaultPrettyPrinter().writeValueAsBytes(versions);
                    return SpecificationLoader.toFile(content, MediaType.JSON_UTF_8);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }, executor));
        }

        private CompletableFuture<ServiceSpecification> generateServiceSpecification(Executor executor, Route docServiceRoute) {
            return CompletableFuture.supplyAsync(() -> {
                DocStringSupport docStringSupport = new DocStringSupport(this.services);
                ServiceSpecification spec = this.generate(this.services, docServiceRoute);
                spec = docStringSupport.addDocStrings(spec);
                spec = this.exampleSupport.addExamples(spec);
                return spec;
            }, executor);
        }

        private CompletableFuture<AggregatedHttpFile> loadSpecifications(CompletableFuture<ServiceSpecification> specificationFuture) {
            return this.files.computeIfAbsent(SPECIFICATION_PATH, key -> specificationFuture.thenApply(spec -> {
                try {
                    byte[] content = jsonMapper.writerWithDefaultPrettyPrinter().writeValueAsBytes(spec);
                    return SpecificationLoader.toFile(content, MediaType.JSON_UTF_8);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }));
        }

        private CompletableFuture<AggregatedHttpFile> loadSchemas(CompletableFuture<ServiceSpecification> specificationFuture) {
            return this.files.computeIfAbsent(SCHEMAS_PATH, key -> specificationFuture.thenApply(spec -> {
                try {
                    ArrayNode jsonSpec = JsonSchemaGenerator.generate(spec);
                    byte[] content = jsonMapper.writerWithDefaultPrettyPrinter().writeValueAsBytes(jsonSpec);
                    return SpecificationLoader.toFile(content, MediaType.JSON_UTF_8);
                }
                catch (JsonProcessingException e) {
                    logger.warn("Failed to generate JSON schemas:", e);
                    return SpecificationLoader.toFile("[]".getBytes(), MediaType.JSON_UTF_8);
                }
            }));
        }

        private static AggregatedHttpFile toFile(byte[] content, MediaType mediaType) {
            return AggregatedHttpFile.builder(HttpData.wrap(content)).contentType(mediaType).cacheControl(ServerCacheControl.REVALIDATED).build();
        }

        private ServiceSpecification generate(List<ServiceConfig> services, Route docServiceRoute) {
            return ServiceSpecification.merge(plugins.stream().map(plugin -> plugin.generateSpecification(DocService.findSupportedServices(plugin, services), this.filter, this.descriptiveTypeInfoProvider)).collect(ImmutableList.toImmutableList()), docServiceRoute);
        }

        private static DescriptiveTypeInfoProvider composeDescriptiveTypeInfoProvider(@Nullable DescriptiveTypeInfoProvider descriptiveTypeInfoProvider) {
            return typeDescriptor -> {
                DescriptiveTypeInfo descriptiveTypeInfo;
                if (descriptiveTypeInfoProvider != null && (descriptiveTypeInfo = descriptiveTypeInfoProvider.newDescriptiveTypeInfo(typeDescriptor)) != null) {
                    return descriptiveTypeInfo;
                }
                for (DescriptiveTypeInfoProvider provider : SPI_DESCRIPTIVE_TYPE_INFO_PROVIDERS) {
                    DescriptiveTypeInfo descriptiveTypeInfo2 = provider.newDescriptiveTypeInfo(typeDescriptor);
                    if (descriptiveTypeInfo2 == null) continue;
                    return descriptiveTypeInfo2;
                }
                return null;
            };
        }
    }

    static final class DocServiceVfs
    extends AbstractHttpVfs {
        private final SpecificationLoader specificationLoader;
        private final HttpVfs staticFiles = HttpVfs.of(DocService.class.getClassLoader(), "com/linecorp/armeria/server/docs");

        DocServiceVfs(SpecificationLoader specificationLoader) {
            this.specificationLoader = specificationLoader;
        }

        @Override
        @Deprecated
        public HttpFile get(Executor fileReadExecutor, String path, Clock clock, @Nullable String contentEncoding, HttpHeaders additionalHeaders) {
            return this.get(fileReadExecutor, path, clock, contentEncoding, additionalHeaders, MediaTypeResolver.ofDefault());
        }

        @Override
        public HttpFile get(Executor fileReadExecutor, String path, Clock clock, @Nullable String contentEncoding, HttpHeaders additionalHeaders, MediaTypeResolver mediaTypeResolver) {
            if (this.specificationLoader.contains(path)) {
                return HttpFile.from(this.specificationLoader.get(path).thenApply(file -> {
                    assert (file != AggregatedHttpFile.nonExistent());
                    HttpData fileContent = file.content();
                    ResponseHeaders fileHeaders = file.headers();
                    HttpFileAttributes fileAttrs = file.attributes();
                    assert (fileContent != null);
                    assert (fileHeaders != null);
                    assert (fileAttrs != null);
                    HttpFileBuilder builder = HttpFile.builder(fileContent, fileAttrs.lastModifiedMillis());
                    builder.autoDetectedContentType(false);
                    builder.clock(clock);
                    builder.setHeaders((Iterable)fileHeaders);
                    builder.setHeaders((Iterable)additionalHeaders);
                    if (contentEncoding != null) {
                        builder.setHeader(HttpHeaderNames.CONTENT_ENCODING, contentEncoding);
                    }
                    return builder.build();
                }));
            }
            HttpHeadersBuilder headers = additionalHeaders.toBuilder();
            headers.set((CharSequence)HttpHeaderNames.CACHE_CONTROL, ServerCacheControl.REVALIDATED.asHeaderValue());
            return this.staticFiles.get(fileReadExecutor, path, clock, contentEncoding, headers.build(), MediaTypeResolver.ofDefault());
        }

        @Override
        public String meterTag() {
            return DocService.class.getSimpleName();
        }
    }
}

