/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common;

import com.linecorp.armeria.common.AggregatedHttpRequest;
import com.linecorp.armeria.common.AggregatedHttpResponse;
import com.linecorp.armeria.common.EmptyHttpResponseException;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.unsafe.PooledObjects;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.List;

public final class HttpMessageAggregator {
    public static AggregatedHttpRequest aggregateRequest(RequestHeaders headers, List<HttpObject> objects, @Nullable ByteBufAllocator alloc) {
        int size = objects.size();
        if (size == 0) {
            return AggregatedHttpRequest.of(headers);
        }
        if (size == 1) {
            HttpObject first = objects.get(0);
            if (first instanceof HttpHeaders) {
                return AggregatedHttpRequest.of(headers, HttpData.empty(), (HttpHeaders)first);
            }
            return AggregatedHttpRequest.of(headers, (HttpData)first);
        }
        if (size == 2) {
            HttpObject first = objects.get(0);
            HttpObject second = objects.get(1);
            if (first instanceof HttpHeaders) {
                PooledObjects.close(second);
                return AggregatedHttpRequest.of(headers, HttpData.empty(), (HttpHeaders)first);
            }
            if (second instanceof HttpHeaders) {
                return AggregatedHttpRequest.of(headers, (HttpData)first, (HttpHeaders)second);
            }
            HttpData data = HttpMessageAggregator.aggregateData((HttpData)first, (HttpData)second, alloc);
            return AggregatedHttpRequest.of(headers, data);
        }
        int contentLength = 0;
        int dataEnd = -1;
        HttpHeaders trailers = HttpHeaders.of();
        for (int i = 0; i < size; ++i) {
            HttpObject httpObject = objects.get(i);
            if (dataEnd > -1) {
                PooledObjects.close(httpObject);
                continue;
            }
            if (httpObject instanceof HttpHeaders) {
                trailers = (HttpHeaders)httpObject;
                dataEnd = i;
                continue;
            }
            contentLength += ((HttpData)httpObject).length();
        }
        if (dataEnd == -1) {
            dataEnd = size;
        }
        if (contentLength == 0) {
            return AggregatedHttpRequest.of(headers, HttpData.empty(), trailers);
        }
        HttpData content = HttpMessageAggregator.aggregateData(objects, contentLength, 0, dataEnd, alloc);
        return AggregatedHttpRequest.of(headers, content, trailers);
    }

    public static AggregatedHttpResponse aggregateResponse(List<HttpObject> objects, @Nullable ByteBufAllocator alloc) {
        int i;
        boolean foundNonInformationalHeaders;
        int size = objects.size();
        if (size == 0) {
            throw EmptyHttpResponseException.get();
        }
        ResponseHeaders headers = (ResponseHeaders)objects.get(0);
        boolean bl = foundNonInformationalHeaders = !headers.status().isInformational();
        if (foundNonInformationalHeaders) {
            if (size == 1) {
                return AggregatedHttpResponse.of(headers);
            }
            if (size == 2) {
                HttpObject second = objects.get(1);
                if (second instanceof HttpHeaders) {
                    return AggregatedHttpResponse.of(headers, HttpData.empty(), (HttpHeaders)second);
                }
                return AggregatedHttpResponse.of(headers, (HttpData)second);
            }
            if (size == 3) {
                HttpObject second = objects.get(1);
                HttpObject third = objects.get(2);
                if (second instanceof HttpHeaders) {
                    PooledObjects.close(third);
                    return AggregatedHttpResponse.of(headers, HttpData.empty(), (HttpHeaders)second);
                }
                if (third instanceof HttpHeaders) {
                    return AggregatedHttpResponse.of(headers, (HttpData)second, (HttpHeaders)third);
                }
                HttpData data = HttpMessageAggregator.aggregateData((HttpData)second, (HttpData)third, alloc);
                return AggregatedHttpResponse.of(headers, data);
            }
        }
        AbstractCollection informationals = ImmutableList.of();
        ResponseHeaders responseHeaders = headers;
        int dataStart = 1;
        if (!foundNonInformationalHeaders) {
            informationals = new ArrayList(2);
            informationals.add(headers);
            for (i = 1; i < size; ++i) {
                HttpHeaders headers0;
                HttpObject httpObject = objects.get(i);
                if (httpObject instanceof ResponseHeaders) {
                    headers0 = (ResponseHeaders)httpObject;
                    if (headers0.status().isInformational()) {
                        informationals.add(headers0);
                        continue;
                    }
                    foundNonInformationalHeaders = true;
                    responseHeaders = headers0;
                    dataStart = i + 1;
                    break;
                }
                if (!(httpObject instanceof HttpHeaders)) continue;
                headers0 = (HttpHeaders)httpObject;
                int lastIdx = informationals.size() - 1;
                informationals.set(lastIdx, ((ResponseHeaders)informationals.get(lastIdx)).withMutations(h -> h.add(headers0)));
            }
        }
        if (!foundNonInformationalHeaders) {
            for (i = dataStart; i < size; ++i) {
                PooledObjects.close(objects.get(i));
            }
            throw new IllegalStateException("An aggregated message does not have a non-informational headers.");
        }
        int dataEnd = -1;
        int contentLength = 0;
        HttpHeaders trailers = HttpHeaders.of();
        for (int i2 = dataStart; i2 < size; ++i2) {
            HttpObject httpObject = objects.get(i2);
            if (dataEnd > 0) {
                PooledObjects.close(httpObject);
                continue;
            }
            if (httpObject instanceof HttpHeaders) {
                trailers = (HttpHeaders)httpObject;
                dataEnd = i2;
                continue;
            }
            contentLength += ((HttpData)httpObject).length();
        }
        if (dataEnd == -1) {
            dataEnd = size;
        }
        if (contentLength == 0) {
            return AggregatedHttpResponse.of(informationals, responseHeaders, HttpData.empty(), trailers);
        }
        HttpData content = HttpMessageAggregator.aggregateData(objects, contentLength, dataStart, dataEnd, alloc);
        return AggregatedHttpResponse.of(informationals, responseHeaders, content, trailers);
    }

    private static HttpData aggregateData(List<HttpObject> objects, int contentLength, int start, int end, @Nullable ByteBufAllocator alloc) {
        if (alloc != null) {
            ByteBuf merged = alloc.buffer(contentLength);
            for (int i = start; i < end; ++i) {
                try (HttpData data = (HttpData)objects.get(i);){
                    ByteBuf buf = data.byteBuf();
                    if (data.isEmpty()) continue;
                    merged.writeBytes(buf, buf.readerIndex(), data.length());
                    continue;
                }
            }
            return HttpData.wrap(merged);
        }
        byte[] merged = new byte[contentLength];
        int offset = 0;
        for (int i = start; i < end; ++i) {
            HttpData data = (HttpData)objects.get(i);
            int dataLength = data.length();
            if (dataLength <= 0) continue;
            System.arraycopy(data.array(), 0, merged, offset, dataLength);
            offset += dataLength;
        }
        return HttpData.wrap(merged);
    }

    public static HttpData aggregateData(HttpData data1, HttpData data2, @Nullable ByteBufAllocator alloc) {
        if (data2.isEmpty()) {
            data2.close();
            return data1;
        }
        if (data1.isEmpty()) {
            data1.close();
            return data2;
        }
        int data1Length = data1.length();
        int data2Length = data2.length();
        int contentLength = data1Length + data2Length;
        if (alloc != null) {
            ByteBuf merged = alloc.buffer(contentLength);
            HttpMessageAggregator.copyAndClose(merged, data1, data1Length);
            HttpMessageAggregator.copyAndClose(merged, data2, data2Length);
            return HttpData.wrap(merged);
        }
        byte[] merged = new byte[contentLength];
        System.arraycopy(data1.array(), 0, merged, 0, data1Length);
        System.arraycopy(data2.array(), 0, merged, data1Length, data2Length);
        return HttpData.wrap(merged);
    }

    private static void copyAndClose(ByteBuf merged, HttpData data, int dataLength) {
        try (HttpData ignore = data;){
            ByteBuf buf = data.byteBuf();
            merged.writeBytes(buf, buf.readerIndex(), dataLength);
        }
    }

    private HttpMessageAggregator() {
    }
}

