/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.client;

import com.linecorp.armeria.client.Client;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.PreClient;
import com.linecorp.armeria.client.PreClientRequestContext;
import com.linecorp.armeria.client.UnprocessedRequestException;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.RequestId;
import com.linecorp.armeria.common.Response;
import com.linecorp.armeria.common.RpcRequest;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.logging.RequestLogAccess;
import com.linecorp.armeria.common.logging.RequestLogBuilder;
import com.linecorp.armeria.common.logging.RequestLogProperty;
import com.linecorp.armeria.common.stream.StreamMessage;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.common.util.SafeCloseable;
import com.linecorp.armeria.internal.client.ClientRequestContextExtension;
import java.net.URI;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class ClientUtil {
    public static final URI UNDEFINED_URI = URI.create("http://undefined");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <I extends Request, O extends Response, U extends Client<I, O>> O initContextAndExecuteWithFallback(U delegate, ClientRequestContextExtension ctx, Function<CompletableFuture<O>, O> futureConverter, BiFunction<ClientRequestContext, Throwable, O> errorResponseFactory, I req) {
        Objects.requireNonNull(delegate, "delegate");
        Objects.requireNonNull(ctx, "ctx");
        Objects.requireNonNull(futureConverter, "futureConverter");
        Objects.requireNonNull(errorResponseFactory, "errorResponseFactory");
        boolean initialized = false;
        boolean success = false;
        try {
            CompletableFuture<Boolean> initFuture = ctx.init();
            initialized = initFuture.isDone();
            if (initialized) {
                try {
                    success = initFuture.get();
                }
                catch (Exception e) {
                    throw UnprocessedRequestException.of(Exceptions.peel(e));
                }
                O o = ClientUtil.initContextAndExecuteWithFallback(delegate, ctx, errorResponseFactory, success, req);
                return o;
            }
            Response response = (Response)futureConverter.apply((CompletableFuture<O>)initFuture.handle((success0, cause) -> {
                try {
                    if (cause != null) {
                        throw UnprocessedRequestException.of(Exceptions.peel(cause));
                    }
                    Object o = ClientUtil.initContextAndExecuteWithFallback(delegate, ctx, errorResponseFactory, success0, req);
                    return o;
                }
                catch (Throwable t) {
                    ClientUtil.fail(ctx, t);
                    Response response = (Response)errorResponseFactory.apply(ctx, t);
                    return response;
                }
                finally {
                    ctx.finishInitialization((boolean)success0);
                }
            }));
            return (O)response;
        }
        catch (Throwable cause2) {
            ClientUtil.fail(ctx, cause2);
            Response response = (Response)errorResponseFactory.apply(ctx, cause2);
            return (O)response;
        }
        finally {
            if (initialized) {
                ctx.finishInitialization(success);
            }
        }
    }

    private static <I extends Request, O extends Response, U extends Client<I, O>> O initContextAndExecuteWithFallback(U delegate, ClientRequestContextExtension ctx, BiFunction<ClientRequestContext, Throwable, O> errorResponseFactory, boolean succeeded, I req) throws Exception {
        if (succeeded) {
            return ClientUtil.pushAndExecute(delegate, ctx, req);
        }
        Throwable cause = ctx.log().partial().requestCause();
        assert (cause != null);
        O res = ClientUtil.pushAndExecute(delegate, ctx, req);
        if (res instanceof StreamMessage) {
            ((StreamMessage)res).abort(cause);
        }
        return (O)((Response)errorResponseFactory.apply(ctx, cause));
    }

    public static <I extends Request, O extends Response, U extends Client<I, O>> O executeWithFallback(U delegate, ClientRequestContext ctx, BiFunction<ClientRequestContext, Throwable, O> errorResponseFactory, I req) {
        Objects.requireNonNull(delegate, "delegate");
        Objects.requireNonNull(ctx, "ctx");
        Objects.requireNonNull(errorResponseFactory, "errorResponseFactory");
        try {
            return ClientUtil.pushAndExecute(delegate, ctx, req);
        }
        catch (Throwable cause) {
            ClientUtil.fail(ctx, cause);
            return (O)((Response)errorResponseFactory.apply(ctx, cause));
        }
    }

    public static <I extends Request, O extends Response, U extends PreClient<I, O>> O executeWithFallback(U execution, PreClientRequestContext ctx, I req, BiFunction<ClientRequestContext, Throwable, O> errorResponseFactory) {
        ClientRequestContextExtension ctxExt = ctx.as(ClientRequestContextExtension.class);
        if (ctxExt != null) {
            ctxExt.runContextCustomizer();
        }
        try {
            return execution.execute(ctx, req);
        }
        catch (Exception e) {
            UnprocessedRequestException upe = UnprocessedRequestException.of(e);
            ClientUtil.fail(ctx, upe);
            return (O)((Response)errorResponseFactory.apply(ctx, upe));
        }
    }

    private static <I extends Request, O extends Response, U extends Client<I, O>> O pushAndExecute(U delegate, ClientRequestContext ctx, I req) throws Exception {
        try (SafeCloseable ignored = ctx.push();){
            O o = delegate.execute(ctx, req);
            return o;
        }
    }

    private static void fail(ClientRequestContext ctx, Throwable cause) {
        HttpRequest req = ctx.request();
        if (req != null) {
            req.abort(cause);
        }
        RequestLogBuilder logBuilder = ctx.logBuilder();
        logBuilder.endRequest(cause);
        logBuilder.endResponse(cause);
    }

    public static ClientRequestContext newDerivedContext(ClientRequestContext ctx, @Nullable HttpRequest req, @Nullable RpcRequest rpcReq, boolean initialAttempt) {
        RequestLogBuilder parentLogBuilder;
        RequestId id = ctx.options().requestIdGenerator().get();
        EndpointGroup endpointGroup = ctx.endpointGroup();
        ClientRequestContext derived = endpointGroup != null && !initialAttempt ? ctx.newDerivedContext(id, req, rpcReq, endpointGroup.selectNow(ctx)) : ctx.newDerivedContext(id, req, rpcReq, ctx.endpoint());
        RequestLogAccess parentLog = ctx.log();
        RequestLog partial = parentLog.partial();
        RequestLogBuilder logBuilder = derived.logBuilder();
        logBuilder.serializationFormat(partial.serializationFormat());
        if (parentLog.isAvailable(RequestLogProperty.NAME)) {
            String serviceName = partial.serviceName();
            String name = partial.name();
            if (serviceName != null) {
                logBuilder.name(serviceName, name);
            } else {
                logBuilder.name(name);
            }
        }
        if ((parentLogBuilder = ctx.logBuilder()).isDeferred(RequestLogProperty.REQUEST_CONTENT)) {
            logBuilder.defer(RequestLogProperty.REQUEST_CONTENT);
        }
        parentLog.whenAvailable(RequestLogProperty.REQUEST_CONTENT).thenAccept(requestLog -> logBuilder.requestContent(requestLog.requestContent(), requestLog.rawRequestContent()));
        if (parentLogBuilder.isDeferred(RequestLogProperty.REQUEST_CONTENT_PREVIEW)) {
            logBuilder.defer(RequestLogProperty.REQUEST_CONTENT_PREVIEW);
        }
        parentLog.whenAvailable(RequestLogProperty.REQUEST_CONTENT_PREVIEW).thenAccept(requestLog -> logBuilder.requestContentPreview(requestLog.requestContentPreview()));
        if (parentLogBuilder.isDeferred(RequestLogProperty.RESPONSE_CONTENT)) {
            logBuilder.defer(RequestLogProperty.RESPONSE_CONTENT);
            parentLog.whenAvailable(RequestLogProperty.RESPONSE_CONTENT).thenAccept(requestLog -> logBuilder.responseContent(requestLog.responseContent(), requestLog.rawResponseContent()));
        }
        if (parentLogBuilder.isDeferred(RequestLogProperty.RESPONSE_CONTENT_PREVIEW)) {
            logBuilder.defer(RequestLogProperty.RESPONSE_CONTENT_PREVIEW);
            parentLog.whenAvailable(RequestLogProperty.RESPONSE_CONTENT_PREVIEW).thenAccept(requestLog -> logBuilder.responseContentPreview(requestLog.responseContentPreview()));
        }
        ctx.logBuilder().addChild(derived.log());
        return derived;
    }

    private ClientUtil() {
    }
}

