/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.logging;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.logging.HeaderMaskingFunction;
import com.linecorp.armeria.common.logging.HeadersSanitizer;
import com.linecorp.armeria.common.logging.JsonHeadersSanitizerBuilder;
import com.linecorp.armeria.common.logging.TextHeadersSanitizer;
import io.netty.util.AsciiString;
import java.util.Set;

final class JsonHeadersSanitizer
implements HeadersSanitizer<JsonNode> {
    static final HeadersSanitizer<JsonNode> INSTANCE = new JsonHeadersSanitizerBuilder().build();
    private final Set<AsciiString> sensitiveHeaders;
    private final HeaderMaskingFunction maskingFunction;
    private final ObjectMapper objectMapper;

    JsonHeadersSanitizer(Set<AsciiString> sensitiveHeaders, HeaderMaskingFunction maskingFunction, ObjectMapper objectMapper) {
        this.sensitiveHeaders = sensitiveHeaders;
        this.maskingFunction = maskingFunction;
        this.objectMapper = objectMapper;
    }

    @Override
    public JsonNode sanitize(RequestContext requestContext, HttpHeaders headers) {
        ObjectNode result = this.objectMapper.createObjectNode();
        TextHeadersSanitizer.maskHeaders(headers, this.sensitiveHeaders, this.maskingFunction, (header, values) -> result.put(header.toString(), values.size() > 1 ? values.toString() : (String)values.get(0)));
        return result;
    }
}

