/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.alarm.provider;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.skywalking.mqe.rt.exception.IllegalExpressionException;
import org.apache.skywalking.mqe.rt.exception.ParseErrorListener;
import org.apache.skywalking.mqe.rt.grammar.MQELexer;
import org.apache.skywalking.mqe.rt.grammar.MQEParser;
import org.apache.skywalking.oap.server.core.alarm.provider.expr.rt.AlarmMQEVerifyVisitor;
import org.apache.skywalking.oap.server.core.query.mqe.ExpressionResult;
import org.apache.skywalking.oap.server.core.query.mqe.ExpressionResultType;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingTraceContext;
import org.apache.skywalking.oap.server.core.storage.annotation.ValueColumnMetadata;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.StringUtil;

public class AlarmRule {
    private final ModuleManager moduleManager;
    private String alarmRuleName;
    private String expression;
    private Set<String> includeMetrics;
    private ArrayList<String> includeNames;
    private String includeNamesRegex;
    private ArrayList<String> excludeNames;
    private String excludeNamesRegex;
    private int period;
    private int silencePeriod;
    private String message;
    private Map<String, String> tags;
    private Set<String> hooks;
    private int maxTrendRange;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExpression(String expression) throws IllegalExpressionException {
        MQEParser.ExpressionContext tree;
        MQELexer lexer = new MQELexer((CharStream)CharStreams.fromString((String)expression));
        lexer.addErrorListener((ANTLRErrorListener)new ParseErrorListener());
        MQEParser parser = new MQEParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        parser.addErrorListener((ANTLRErrorListener)new ParseErrorListener());
        try {
            tree = parser.expression();
        }
        catch (ParseCancellationException e) {
            throw new IllegalExpressionException("Expression: " + expression + " error: " + e.getMessage());
        }
        try {
            DebuggingTraceContext.TRACE_CONTEXT.set(new DebuggingTraceContext(expression, false, false));
            AlarmMQEVerifyVisitor visitor = new AlarmMQEVerifyVisitor(this.moduleManager);
            ExpressionResult parseResult = (ExpressionResult)visitor.visit((ParseTree)tree);
            if (StringUtil.isNotBlank((String)parseResult.getError())) {
                throw new IllegalExpressionException("Expression: " + expression + " error: " + parseResult.getError());
            }
            if (!parseResult.isBoolResult()) {
                throw new IllegalExpressionException("Expression: " + expression + " root operation is not a Compare Operation.");
            }
            if (ExpressionResultType.SINGLE_VALUE != parseResult.getType()) {
                throw new IllegalExpressionException("Expression: " + expression + " is not a SINGLE_VALUE result expression.");
            }
            this.verifyIncludeMetrics(visitor.getIncludeMetrics(), expression);
            this.expression = expression;
            this.includeMetrics = visitor.getIncludeMetrics();
            this.maxTrendRange = visitor.getMaxTrendRange();
        }
        finally {
            DebuggingTraceContext.TRACE_CONTEXT.remove();
        }
    }

    private void verifyIncludeMetrics(Set<String> includeMetrics, String expression) throws IllegalExpressionException {
        HashSet<String> scopeSet = new HashSet<String>();
        for (String metricName : includeMetrics) {
            scopeSet.add(ValueColumnMetadata.INSTANCE.getScope(metricName).name());
        }
        if (scopeSet.size() != 1) {
            throw new IllegalExpressionException("The metrics in expression: " + expression + " must have the same scope level, but got: " + String.valueOf(scopeSet) + ".");
        }
    }

    @Generated
    public ModuleManager getModuleManager() {
        return this.moduleManager;
    }

    @Generated
    public String getAlarmRuleName() {
        return this.alarmRuleName;
    }

    @Generated
    public String getExpression() {
        return this.expression;
    }

    @Generated
    public Set<String> getIncludeMetrics() {
        return this.includeMetrics;
    }

    @Generated
    public ArrayList<String> getIncludeNames() {
        return this.includeNames;
    }

    @Generated
    public String getIncludeNamesRegex() {
        return this.includeNamesRegex;
    }

    @Generated
    public ArrayList<String> getExcludeNames() {
        return this.excludeNames;
    }

    @Generated
    public String getExcludeNamesRegex() {
        return this.excludeNamesRegex;
    }

    @Generated
    public int getPeriod() {
        return this.period;
    }

    @Generated
    public int getSilencePeriod() {
        return this.silencePeriod;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public Map<String, String> getTags() {
        return this.tags;
    }

    @Generated
    public Set<String> getHooks() {
        return this.hooks;
    }

    @Generated
    public int getMaxTrendRange() {
        return this.maxTrendRange;
    }

    @Generated
    public void setAlarmRuleName(String alarmRuleName) {
        this.alarmRuleName = alarmRuleName;
    }

    @Generated
    public void setIncludeNames(ArrayList<String> includeNames) {
        this.includeNames = includeNames;
    }

    @Generated
    public void setIncludeNamesRegex(String includeNamesRegex) {
        this.includeNamesRegex = includeNamesRegex;
    }

    @Generated
    public void setExcludeNames(ArrayList<String> excludeNames) {
        this.excludeNames = excludeNames;
    }

    @Generated
    public void setExcludeNamesRegex(String excludeNamesRegex) {
        this.excludeNamesRegex = excludeNamesRegex;
    }

    @Generated
    public void setPeriod(int period) {
        this.period = period;
    }

    @Generated
    public void setSilencePeriod(int silencePeriod) {
        this.silencePeriod = silencePeriod;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    @Generated
    public void setHooks(Set<String> hooks) {
        this.hooks = hooks;
    }

    @Generated
    public void setMaxTrendRange(int maxTrendRange) {
        this.maxTrendRange = maxTrendRange;
    }

    @Generated
    public String toString() {
        return "AlarmRule(moduleManager=" + String.valueOf(this.getModuleManager()) + ", alarmRuleName=" + this.getAlarmRuleName() + ", expression=" + this.getExpression() + ", includeMetrics=" + String.valueOf(this.getIncludeMetrics()) + ", includeNames=" + String.valueOf(this.getIncludeNames()) + ", includeNamesRegex=" + this.getIncludeNamesRegex() + ", excludeNames=" + String.valueOf(this.getExcludeNames()) + ", excludeNamesRegex=" + this.getExcludeNamesRegex() + ", period=" + this.getPeriod() + ", silencePeriod=" + this.getSilencePeriod() + ", message=" + this.getMessage() + ", tags=" + String.valueOf(this.getTags()) + ", hooks=" + String.valueOf(this.getHooks()) + ", maxTrendRange=" + this.getMaxTrendRange() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlarmRule)) {
            return false;
        }
        AlarmRule other = (AlarmRule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPeriod() != other.getPeriod()) {
            return false;
        }
        if (this.getSilencePeriod() != other.getSilencePeriod()) {
            return false;
        }
        if (this.getMaxTrendRange() != other.getMaxTrendRange()) {
            return false;
        }
        ModuleManager this$moduleManager = this.getModuleManager();
        ModuleManager other$moduleManager = other.getModuleManager();
        if (this$moduleManager == null ? other$moduleManager != null : !this$moduleManager.equals(other$moduleManager)) {
            return false;
        }
        String this$alarmRuleName = this.getAlarmRuleName();
        String other$alarmRuleName = other.getAlarmRuleName();
        if (this$alarmRuleName == null ? other$alarmRuleName != null : !this$alarmRuleName.equals(other$alarmRuleName)) {
            return false;
        }
        String this$expression = this.getExpression();
        String other$expression = other.getExpression();
        if (this$expression == null ? other$expression != null : !this$expression.equals(other$expression)) {
            return false;
        }
        Set<String> this$includeMetrics = this.getIncludeMetrics();
        Set<String> other$includeMetrics = other.getIncludeMetrics();
        if (this$includeMetrics == null ? other$includeMetrics != null : !((Object)this$includeMetrics).equals(other$includeMetrics)) {
            return false;
        }
        ArrayList<String> this$includeNames = this.getIncludeNames();
        ArrayList<String> other$includeNames = other.getIncludeNames();
        if (this$includeNames == null ? other$includeNames != null : !((Object)this$includeNames).equals(other$includeNames)) {
            return false;
        }
        String this$includeNamesRegex = this.getIncludeNamesRegex();
        String other$includeNamesRegex = other.getIncludeNamesRegex();
        if (this$includeNamesRegex == null ? other$includeNamesRegex != null : !this$includeNamesRegex.equals(other$includeNamesRegex)) {
            return false;
        }
        ArrayList<String> this$excludeNames = this.getExcludeNames();
        ArrayList<String> other$excludeNames = other.getExcludeNames();
        if (this$excludeNames == null ? other$excludeNames != null : !((Object)this$excludeNames).equals(other$excludeNames)) {
            return false;
        }
        String this$excludeNamesRegex = this.getExcludeNamesRegex();
        String other$excludeNamesRegex = other.getExcludeNamesRegex();
        if (this$excludeNamesRegex == null ? other$excludeNamesRegex != null : !this$excludeNamesRegex.equals(other$excludeNamesRegex)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        Map<String, String> this$tags = this.getTags();
        Map<String, String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        Set<String> this$hooks = this.getHooks();
        Set<String> other$hooks = other.getHooks();
        return !(this$hooks == null ? other$hooks != null : !((Object)this$hooks).equals(other$hooks));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AlarmRule;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPeriod();
        result = result * 59 + this.getSilencePeriod();
        result = result * 59 + this.getMaxTrendRange();
        ModuleManager $moduleManager = this.getModuleManager();
        result = result * 59 + ($moduleManager == null ? 43 : $moduleManager.hashCode());
        String $alarmRuleName = this.getAlarmRuleName();
        result = result * 59 + ($alarmRuleName == null ? 43 : $alarmRuleName.hashCode());
        String $expression = this.getExpression();
        result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
        Set<String> $includeMetrics = this.getIncludeMetrics();
        result = result * 59 + ($includeMetrics == null ? 43 : ((Object)$includeMetrics).hashCode());
        ArrayList<String> $includeNames = this.getIncludeNames();
        result = result * 59 + ($includeNames == null ? 43 : ((Object)$includeNames).hashCode());
        String $includeNamesRegex = this.getIncludeNamesRegex();
        result = result * 59 + ($includeNamesRegex == null ? 43 : $includeNamesRegex.hashCode());
        ArrayList<String> $excludeNames = this.getExcludeNames();
        result = result * 59 + ($excludeNames == null ? 43 : ((Object)$excludeNames).hashCode());
        String $excludeNamesRegex = this.getExcludeNamesRegex();
        result = result * 59 + ($excludeNamesRegex == null ? 43 : $excludeNamesRegex.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        Map<String, String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        Set<String> $hooks = this.getHooks();
        result = result * 59 + ($hooks == null ? 43 : ((Object)$hooks).hashCode());
        return result;
    }

    @Generated
    public AlarmRule(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }
}

