/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.datacarrier.consumer;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.skywalking.oap.server.library.datacarrier.EnvUtil;
import org.apache.skywalking.oap.server.library.datacarrier.buffer.Channels;
import org.apache.skywalking.oap.server.library.datacarrier.consumer.ConsumerPool;
import org.apache.skywalking.oap.server.library.datacarrier.consumer.IConsumer;
import org.apache.skywalking.oap.server.library.datacarrier.consumer.MultipleChannelsConsumer;

public class BulkConsumePool
implements ConsumerPool {
    private List<MultipleChannelsConsumer> allConsumers;
    private volatile boolean isStarted = false;

    public BulkConsumePool(String name, int size, long consumeCycle, boolean isSignalDrivenMode) {
        size = EnvUtil.getInt(name + "_THREAD", size);
        this.allConsumers = new ArrayList<MultipleChannelsConsumer>(size);
        for (int i = 0; i < size; ++i) {
            MultipleChannelsConsumer multipleChannelsConsumer = new MultipleChannelsConsumer("DataCarrier." + name + ".BulkConsumePool." + i + ".Thread", consumeCycle, isSignalDrivenMode);
            multipleChannelsConsumer.setDaemon(true);
            this.allConsumers.add(multipleChannelsConsumer);
        }
    }

    @Override
    public synchronized void add(String name, Channels channels, IConsumer consumer) {
        MultipleChannelsConsumer multipleChannelsConsumer = this.getLowestPayload();
        multipleChannelsConsumer.addNewTarget(channels, consumer);
    }

    private MultipleChannelsConsumer getLowestPayload() {
        MultipleChannelsConsumer winner = this.allConsumers.get(0);
        for (int i = 1; i < this.allConsumers.size(); ++i) {
            MultipleChannelsConsumer option = this.allConsumers.get(i);
            if (option.size() >= winner.size()) continue;
            winner = option;
        }
        return winner;
    }

    @Override
    public boolean isRunning(Channels channels) {
        return this.isStarted;
    }

    @Override
    public void close(Channels channels) {
        for (MultipleChannelsConsumer consumer : this.allConsumers) {
            consumer.shutdown();
        }
    }

    @Override
    public void begin(Channels channels) {
        if (this.isStarted) {
            return;
        }
        for (MultipleChannelsConsumer consumer : this.allConsumers) {
            consumer.start();
        }
        this.isStarted = true;
    }

    public void notifyConsumers() {
        for (MultipleChannelsConsumer consumer : this.allConsumers) {
            consumer.setConsumeFlag(true);
        }
    }

    public static class Creator
    implements Callable<ConsumerPool> {
        private String name;
        private int size;
        private long consumeCycle;
        private final boolean isSignalDrivenMode;

        public Creator(String name, int poolSize, long consumeCycle, boolean isSignalDrivenMode) {
            this.name = name;
            this.size = poolSize;
            this.consumeCycle = consumeCycle;
            this.isSignalDrivenMode = isSignalDrivenMode;
        }

        @Override
        public ConsumerPool call() {
            return new BulkConsumePool(this.name, this.size, this.consumeCycle, this.isSignalDrivenMode);
        }

        public static int recommendMaxSize() {
            return Runtime.getRuntime().availableProcessors() * 2;
        }
    }
}

