/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.query.type.AsyncProfilerEventType;
import org.apache.skywalking.oap.server.core.query.type.AsyncProfilerTask;
import org.apache.skywalking.oap.server.core.storage.profiling.asyncprofiler.IAsyncProfilerTaskQueryDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCClient;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.TableHelper;

public class JDBCAsyncProfilerTaskQueryDAO
implements IAsyncProfilerTaskQueryDAO {
    private static final Gson GSON = new Gson();
    private final JDBCClient jdbcClient;
    private final TableHelper tableHelper;

    public List<AsyncProfilerTask> getTaskList(String serviceId, Long startTimeBucket, Long endTimeBucket, Integer limit) throws IOException {
        ArrayList<AsyncProfilerTask> results = new ArrayList<AsyncProfilerTask>();
        List<String> tables = startTimeBucket == null || endTimeBucket == null ? this.tableHelper.getTablesWithinTTL("async_profiler_task") : this.tableHelper.getTablesForRead("async_profiler_task", startTimeBucket, endTimeBucket);
        for (String table : tables) {
            ArrayList<Object> condition = new ArrayList<Object>(4);
            StringBuilder sql = new StringBuilder().append("select * from ").append(table).append(" where ").append("table_name").append(" = ?");
            condition.add("async_profiler_task");
            if (StringUtil.isNotEmpty((String)serviceId)) {
                sql.append(" and ").append("service_id").append("=? ");
                condition.add(serviceId);
            }
            if (startTimeBucket != null) {
                sql.append(" and ").append("time_bucket").append(" >= ? ");
                condition.add(startTimeBucket);
            }
            if (endTimeBucket != null) {
                sql.append(" and ").append("time_bucket").append(" <= ? ");
                condition.add(endTimeBucket);
            }
            sql.append(" ORDER BY ").append("create_time").append(" DESC ");
            if (limit != null) {
                sql.append(" LIMIT ").append(limit);
            }
            results.addAll((Collection)this.jdbcClient.executeQuery(sql.toString(), resultSet -> {
                ArrayList<AsyncProfilerTask> tasks = new ArrayList<AsyncProfilerTask>();
                while (resultSet.next()) {
                    tasks.add(this.buildAsyncProfilerTask(resultSet));
                }
                return tasks;
            }, condition.toArray(new Object[0])));
        }
        return limit == null ? results : results.stream().limit(limit.intValue()).collect(Collectors.toList());
    }

    public AsyncProfilerTask getById(String id) throws IOException {
        List<String> tables = this.tableHelper.getTablesWithinTTL("async_profiler_task");
        for (String table : tables) {
            StringBuilder sql = new StringBuilder();
            ArrayList<String> condition = new ArrayList<String>(1);
            sql.append("select * from ").append(table).append(" where ").append("table_name").append(" = ? ").append(" and ").append("task_id=? LIMIT 1");
            condition.add("async_profiler_task");
            condition.add(id);
            AsyncProfilerTask r = (AsyncProfilerTask)this.jdbcClient.executeQuery(sql.toString(), resultSet -> {
                if (resultSet.next()) {
                    return this.buildAsyncProfilerTask(resultSet);
                }
                return null;
            }, condition.toArray(new Object[0]));
            if (r == null) continue;
            return r;
        }
        return null;
    }

    private AsyncProfilerTask buildAsyncProfilerTask(ResultSet data) throws SQLException {
        Type listType = new TypeToken<List<String>>(){}.getType();
        String events = data.getString("events");
        List eventList = (List)GSON.fromJson(events, listType);
        String serviceInstanceIds = data.getString("service_instance_ids");
        List serviceInstanceIdList = (List)GSON.fromJson(serviceInstanceIds, listType);
        return AsyncProfilerTask.builder().id(data.getString("task_id")).serviceId(data.getString("service_id")).serviceInstanceIds(serviceInstanceIdList).createTime(data.getLong("create_time")).duration(data.getInt("duration")).events(AsyncProfilerEventType.valueOfList((List)eventList)).execArgs(data.getString("exec_args")).build();
    }

    @Generated
    public JDBCAsyncProfilerTaskQueryDAO(JDBCClient jdbcClient, TableHelper tableHelper) {
        this.jdbcClient = jdbcClient;
        this.tableHelper = tableHelper;
    }
}

