/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.server.ssl;

import io.netty.handler.ssl.SslContextBuilder;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import javax.net.ssl.SSLException;
import org.apache.skywalking.oap.server.library.server.ssl.AbstractSslContext;
import org.apache.skywalking.oap.server.library.server.ssl.PrivateKeyUtil;

public class HTTPDynamicSslContext
extends AbstractSslContext {
    public static HTTPDynamicSslContext forServer(String privateKeyFile, String certChainFile) {
        return new HTTPDynamicSslContext(privateKeyFile, certChainFile);
    }

    public static HTTPDynamicSslContext forClient(String caFile) {
        return new HTTPDynamicSslContext(caFile);
    }

    protected HTTPDynamicSslContext(String privateKeyFile, String certChainFile) {
        super(privateKeyFile, certChainFile, null);
    }

    protected HTTPDynamicSslContext(String caFile) {
        super(caFile);
    }

    @Override
    protected void updateContext(String caFile) {
        try {
            this.setCtx(SslContextBuilder.forClient().trustManager(Paths.get(caFile, new String[0]).toFile()).build());
        }
        catch (SSLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    protected void updateContext(String privateKeyFile, String certChainFile, String trustedCAsFile) {
        try (FileInputStream cert = new FileInputStream(Paths.get(certChainFile, new String[0]).toFile());
             InputStream key = PrivateKeyUtil.loadDecryptionKey(privateKeyFile);){
            this.setCtx(SslContextBuilder.forServer((InputStream)cert, (InputStream)key).build());
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

