/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.file;

import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.encoding.StaticHttpDecodedResponse;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.file.AggregatedHttpFile;
import com.linecorp.armeria.server.file.FileService;
import com.linecorp.armeria.server.file.HttpFile;
import com.linecorp.armeria.server.file.HttpFileAttributes;
import io.netty.buffer.ByteBufAllocator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

final class DecompressingHttpFile
implements HttpFile {
    private final HttpFile compressedFile;
    private final FileService.ContentEncoding encoding;
    @Nullable
    private final MediaType contentType;

    DecompressingHttpFile(HttpFile compressedFile, FileService.ContentEncoding encoding, @Nullable MediaType contentType) {
        this.compressedFile = compressedFile;
        this.encoding = encoding;
        this.contentType = contentType;
    }

    @Override
    public CompletableFuture<@Nullable HttpFileAttributes> readAttributes(Executor fileReadExecutor) {
        return this.compressedFile.readAttributes(fileReadExecutor);
    }

    @Override
    public CompletableFuture<@Nullable ResponseHeaders> readHeaders(Executor fileReadExecutor) {
        return this.compressedFile.readHeaders(fileReadExecutor);
    }

    @Override
    public CompletableFuture<@Nullable HttpResponse> read(Executor fileReadExecutor, ByteBufAllocator alloc) {
        return this.compressedFile.read(fileReadExecutor, alloc);
    }

    @Override
    public CompletableFuture<AggregatedHttpFile> aggregate(Executor fileReadExecutor) {
        return this.compressedFile.aggregate(fileReadExecutor);
    }

    @Override
    public CompletableFuture<AggregatedHttpFile> aggregateWithPooledObjects(Executor fileReadExecutor, ByteBufAllocator alloc) {
        return this.compressedFile.aggregateWithPooledObjects(fileReadExecutor, alloc);
    }

    @Override
    public HttpService asService() {
        return (ctx, req) -> {
            HttpResponse response = this.compressedFile.asService().serve(ctx, req);
            return new StaticHttpDecodedResponse(response, this.encoding.decoderFactory.newDecoder(ctx.alloc()), this.contentType);
        };
    }
}

