/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.auth;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.auth.AuthToken;
import com.linecorp.armeria.common.auth.OAuth1aTokenBuilder;
import com.linecorp.armeria.internal.common.PercentEncoder;
import com.linecorp.armeria.internal.common.util.TemporaryThreadLocals;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import java.util.Map;
import java.util.Objects;

public final class OAuth1aToken
extends AuthToken {
    static final String REALM = "realm";
    static final String OAUTH_CONSUMER_KEY = "oauth_consumer_key";
    static final String OAUTH_TOKEN = "oauth_token";
    static final String OAUTH_SIGNATURE_METHOD = "oauth_signature_method";
    static final String OAUTH_SIGNATURE = "oauth_signature";
    static final String OAUTH_TIMESTAMP = "oauth_timestamp";
    static final String OAUTH_NONCE = "oauth_nonce";
    static final String OAUTH_VERSION = "version";
    private final String consumerKey;
    private final String token;
    private final String signatureMethod;
    private final String signature;
    private final String timestamp;
    private final String nonce;
    private final String version;
    private final Map<String, String> additionals;
    @Nullable
    private final String realm;
    @Nullable
    private String headerValue;

    @Deprecated
    public static OAuth1aTokenBuilder builder() {
        return new OAuth1aTokenBuilder();
    }

    OAuth1aToken(String consumerKey, String token, String signatureMethod, String signature, String timestamp, String nonce, String version, Map<String, String> additionals, @Nullable String realm) {
        this.consumerKey = consumerKey;
        this.token = token;
        this.signatureMethod = signatureMethod;
        this.signature = signature;
        this.timestamp = timestamp;
        this.nonce = nonce;
        this.version = version;
        this.additionals = additionals;
        this.realm = realm;
    }

    @Nullable
    public String realm() {
        return this.realm;
    }

    public String consumerKey() {
        return this.consumerKey;
    }

    public String token() {
        return this.token;
    }

    public String signatureMethod() {
        return this.signatureMethod;
    }

    public String signature() {
        return this.signature;
    }

    public String timestamp() {
        return this.timestamp;
    }

    public String nonce() {
        return this.nonce;
    }

    public String version() {
        return this.version;
    }

    public Map<String, String> additionals() {
        return this.additionals;
    }

    @Override
    public String asHeaderValue() {
        if (this.headerValue != null) {
            return this.headerValue;
        }
        try (TemporaryThreadLocals tempThreadLocals = TemporaryThreadLocals.acquire();){
            StringBuilder builder = tempThreadLocals.stringBuilder();
            builder.append("OAuth ");
            if (!Strings.isNullOrEmpty(this.realm)) {
                OAuth1aToken.appendValue(builder, REALM, this.realm, true);
            }
            OAuth1aToken.appendValue(builder, OAUTH_CONSUMER_KEY, this.consumerKey, true);
            OAuth1aToken.appendValue(builder, OAUTH_TOKEN, this.token, true);
            OAuth1aToken.appendValue(builder, OAUTH_SIGNATURE_METHOD, this.signatureMethod, true);
            OAuth1aToken.appendValue(builder, OAUTH_SIGNATURE, this.signature, true);
            OAuth1aToken.appendValue(builder, OAUTH_TIMESTAMP, this.timestamp, true);
            OAuth1aToken.appendValue(builder, OAUTH_NONCE, this.nonce, true);
            OAuth1aToken.appendValue(builder, OAUTH_VERSION, this.version, false);
            for (Map.Entry<String, String> entry : this.additionals.entrySet()) {
                builder.append(',');
                OAuth1aToken.appendValue(builder, entry.getKey(), entry.getValue(), false);
            }
            this.headerValue = builder.toString();
            String string = this.headerValue;
            return string;
        }
    }

    private static void appendValue(StringBuilder builder, String key, String value, boolean addComma) {
        builder.append(key);
        builder.append("=\"");
        PercentEncoder.encodeComponent(builder, value);
        if (addComma) {
            builder.append("\",");
        } else {
            builder.append('\"');
        }
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OAuth1aToken)) {
            return false;
        }
        OAuth1aToken that = (OAuth1aToken)o;
        boolean equals = Objects.equals(this.realm, that.realm);
        equals &= this.consumerKey.equals(that.consumerKey);
        equals &= this.token.equals(that.token);
        equals &= this.signatureMethod.equals(that.signatureMethod);
        equals &= this.signature.equals(that.signature);
        equals &= this.timestamp.equals(that.timestamp);
        equals &= this.nonce.equals(that.nonce);
        equals &= this.version.equals(that.version);
        return equals &= Objects.equals(this.additionals, that.additionals);
    }

    public int hashCode() {
        return Objects.hash(this.realm, this.consumerKey, this.token, this.signatureMethod, this.signature, this.timestamp, this.nonce, this.version, this.additionals);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add(REALM, this.realm).add("consumerKey", this.consumerKey).add("token", "****").add("signatureMethod", this.signatureMethod).add("signature", this.signature).add("timestamp", this.timestamp).add("nonce", this.nonce).add(OAUTH_VERSION, this.version).add("additionals", this.additionals).toString();
    }
}

